/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupported;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.ExecutionInfo;
import org.jetbrains.plugins.gradle.execution.ExecutionNode;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.NodeProgressAnimator;
import org.jetbrains.plugins.gradle.execution.TaskExecutionTreeTable;

public class TaskExecutionView
implements ConsoleView,
DataProvider {
    private static final int TREE_COLUMN_MIN_WIDTH = 300;
    private static final int TIME_COLUMN_MIN_WIDTH = 140;
    private final Project myProject;
    private final Map<String, ExecutionNode> nodeMap = ContainerUtil.newHashMap();
    private final JScrollPane myPane;
    private final TreeTable myTreeTable;
    private final SimpleTreeBuilder myBuilder;
    private final NodeProgressAnimator myProgressAnimator;
    private final ExecutionNode myRoot;
    private String myWorkingDir;

    public TaskExecutionView(Project project) {
        this.myProject = project;
        ColumnInfo[] COLUMNS = new ColumnInfo[]{new TreeColumnInfo("name"), new ColumnInfo("time elapsed"){

            @Nullable
            public Object valueOf(Object o) {
                Object userObject;
                if (o instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)o).getUserObject()) instanceof ExecutionNode) {
                    return ((ExecutionNode)((Object)userObject)).getDuration();
                }
                return null;
            }
        }, new ColumnInfo(""){

            @Nullable
            public Object valueOf(Object o) {
                return "";
            }
        }};
        this.myRoot = new ExecutionNode(project, this.myWorkingDir);
        this.myRoot.setInfo(new ExecutionInfo(null, "Run build", this.myWorkingDir));
        ListTreeTableModelOnColumns model = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode((Object)this.myRoot), COLUMNS);
        this.myTreeTable = new TaskExecutionTreeTable(model);
        this.myTreeTable.setRowHeight(this.myTreeTable.getRowHeight() + 2);
        final TreeCellRenderer treeCellRenderer = this.myTreeTable.getTree().getCellRenderer();
        this.myTreeTable.getTree().setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component rendererComponent = treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (rendererComponent instanceof SimpleColoredComponent) {
                    Color fg;
                    Color bg = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                    Color color = fg = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
                    if (selected) {
                        SimpleColoredComponent.ColoredIterator it = ((SimpleColoredComponent)rendererComponent).iterator();
                        while (it.hasNext()) {
                            it.next();
                            int offset = it.getOffset();
                            int endOffset = it.getEndOffset();
                            SimpleTextAttributes currentAttributes = it.getTextAttributes();
                            SimpleTextAttributes newAttributes = new SimpleTextAttributes(bg, fg, currentAttributes.getWaveColor(), currentAttributes.getStyle());
                            it.split(endOffset - offset, newAttributes);
                        }
                    }
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)TaskExecutionView.this.myTreeTable, (SimpleColoredComponent)((SimpleColoredComponent)rendererComponent), (boolean)true, (boolean)selected);
                }
                return rendererComponent;
            }
        });
        new TreeTableSpeedSearch(this.myTreeTable).setComparator(new SpeedSearchComparator(false));
        this.myTreeTable.setTableHeader(null);
        TableColumn treeColumn = this.myTreeTable.getColumnModel().getColumn(0);
        treeColumn.setMinWidth(300);
        TableColumn timeColumn = this.myTreeTable.getColumnModel().getColumn(1);
        timeColumn.setMinWidth(140);
        TreeTableTree tree = this.myTreeTable.getTree();
        SimpleTreeStructure.Impl treeStructure = new SimpleTreeStructure.Impl((SimpleNode)this.myRoot);
        this.myBuilder = new SimpleTreeBuilder((JTree)tree, (DefaultTreeModel)model, (AbstractTreeStructure)treeStructure, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.expand(treeStructure.getRootElement(), null);
        this.myBuilder.initRoot();
        this.myBuilder.expand((Object)this.myRoot, null);
        this.myProgressAnimator = new NodeProgressAnimator((AbstractTreeBuilder)this.myBuilder);
        this.myProgressAnimator.setCurrentNode((SimpleNode)this.myRoot);
        this.myBuilder.queueUpdateFrom((Object)this.myRoot, false, true);
        this.myPane = ScrollPaneFactory.createScrollPane((Component)this.myTreeTable, (int)20, (int)30);
        DataManager.registerDataProvider((JComponent)this.myTreeTable, (DataProvider)this);
    }

    public void onStatusChange(ExternalSystemTaskExecutionEvent event) {
        ExternalSystemProgressEvent progressEvent = event.getProgressEvent();
        String parentEventId = progressEvent.getParentEventId();
        if (progressEvent instanceof ExternalSystemStartEvent) {
            ExecutionNode parentNode;
            ExecutionNode currentNode;
            ExecutionInfo executionInfo = new ExecutionInfo(progressEvent.getEventId(), progressEvent.getDescriptor(), this.myWorkingDir);
            executionInfo.setStartTime(progressEvent.getEventTime());
            ExecutionNode executionNode = currentNode = parentEventId == null ? this.myRoot : new ExecutionNode(this.myProject, this.myWorkingDir);
            if (parentEventId != null && (parentNode = this.nodeMap.get(parentEventId)) != null) {
                parentNode.add(currentNode);
            }
            currentNode.setInfo(executionInfo);
            this.nodeMap.put(progressEvent.getEventId(), currentNode);
            this.myProgressAnimator.setCurrentNode((SimpleNode)currentNode);
            this.myBuilder.queueUpdateFrom((Object)currentNode, false, true);
        } else if (progressEvent instanceof ExternalSystemFinishEvent) {
            ExecutionNode node = this.nodeMap.get(progressEvent.getEventId());
            ExecutionInfo executionInfo = node.getInfo();
            executionInfo.setDescriptor(progressEvent.getDescriptor());
            executionInfo.setEndTime(progressEvent.getEventTime());
            OperationResult operationResult = ((ExternalSystemFinishEvent)progressEvent).getOperationResult();
            if (operationResult instanceof FailureResult) {
                executionInfo.setFailed(true);
            } else if (operationResult instanceof SkippedResult) {
                executionInfo.setSkipped(true);
            } else if (operationResult instanceof SuccessResult) {
                executionInfo.setUpToDate(((SuccessResult)operationResult).isUpToDate());
            }
            if (parentEventId == null) {
                this.myProgressAnimator.stopMovie();
            }
            this.myBuilder.queueUpdateFrom((Object)node, false, false);
        } else if (progressEvent instanceof ExternalSystemProgressEventUnsupported) {
            ExecutionInfo executionInfo = new ExecutionInfo(null, "Build/task progress visualization available in Gradle version >= 2.5", this.myWorkingDir);
            executionInfo.setSkipped(true);
            this.myRoot.setInfo(executionInfo);
            this.myProgressAnimator.stopMovie();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        TreePath[] paths;
        TreeTableTree tree = this.myTreeTable.getTree();
        if (Location.DATA_KEYS.is(dataId) && (paths = tree.getSelectionModel().getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<Location> locations = new ArrayList<Location>(paths.length);
            for (TreePath path : paths) {
                Location location;
                ExecutionInfo executionInfo;
                if (tree.isPathSelected(path.getParentPath()) || (executionInfo = TaskExecutionView.getSelectedExecution(path)) == null || (location = (Location)GradleRunnerUtil.getData(this.myProject, Location.DATA_KEY.getName(), executionInfo)) == null) continue;
                locations.add(location);
            }
            return locations.isEmpty() ? null : locations.toArray(new Location[locations.size()]);
        }
        if (Location.DATA_KEY.is(dataId) && (paths = tree.getSelectionModel().getSelectionPaths()) != null && paths.length > 1) {
            ArrayList executionInfos = ContainerUtil.newArrayListWithCapacity((int)paths.length);
            for (TreePath path : paths) {
                if (tree.isPathSelected(path.getParentPath())) continue;
                ExecutionInfo executionInfo = TaskExecutionView.getSelectedExecution(path);
                ContainerUtil.addIfNotNull((Object)executionInfo, (Collection)executionInfos);
            }
            return executionInfos.isEmpty() ? null : GradleRunnerUtil.getTaskLocation(this.myProject, executionInfos.toArray(new ExecutionInfo[executionInfos.size()]));
        }
        TreePath selectionPath = tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        ExecutionInfo executionInfo = TaskExecutionView.getSelectedExecution(selectionPath);
        if (executionInfo == null) {
            return null;
        }
        return GradleRunnerUtil.getData(this.myProject, dataId, executionInfo);
    }

    public void dispose() {
        DataManager.removeDataProvider((JComponent)this.myTreeTable);
    }

    public void onFailure(Exception e) {
        this.myRoot.getInfo().setFailed(true);
        this.myProgressAnimator.stopMovie();
    }

    void setWorkingDir(String workingDir) {
        this.myWorkingDir = workingDir;
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
    }

    public void clear() {
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler) {
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
    }

    public void setHelpId(String helpId) {
    }

    public void addMessageFilter(Filter filter) {
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        return new AnAction[0];
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myPane;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTreeTable;
    }

    private static ExecutionInfo getSelectedExecution(@NotNull TreePath selectionPath) {
        Object lastComponent = selectionPath.getLastPathComponent();
        assert (lastComponent != null);
        return TaskExecutionView.getExecutionInfo(lastComponent);
    }

    @Nullable
    private static ExecutionInfo getExecutionInfo(Object treeNode) {
        Object userObj = ((DefaultMutableTreeNode)treeNode).getUserObject();
        if (userObj instanceof ExecutionNode) {
            return ((ExecutionNode)((Object)userObj)).getInfo();
        }
        return null;
    }
}

