/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.actions.JavaRerunFailedTestsAction;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public class GradleRerunFailedTestsAction
extends JavaRerunFailedTestsAction {
    public GradleRerunFailedTestsAction(GradleTestsExecutionConsole consoleView) {
        super((ComponentContainer)consoleView.getConsole(), consoleView.getProperties());
    }

    @Nullable
    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)this.myConsoleProperties.getConfiguration();
        final List failedTests = this.getFailedTests(configuration.getProject());
        return new AbstractRerunFailedTestsAction.MyRunProfile((RunConfigurationBase)configuration){

            @NotNull
            public Module[] getModules() {
                return new Module[0];
            }

            @Nullable
            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                ExternalSystemRunConfiguration runProfile = ((ExternalSystemRunConfiguration)this.getPeer()).clone();
                Project project = runProfile.getProject();
                LinkedHashSet scriptParameters = ContainerUtil.newLinkedHashSet();
                LinkedHashSet tasksToRun = ContainerUtil.newLinkedHashSet();
                boolean useResolvedTasks = true;
                for (AbstractTestProxy test : failedTests) {
                    if (!(test instanceof GradleSMTestProxy)) continue;
                    String testName = test.getName();
                    String className = ((GradleSMTestProxy)test).getClassName();
                    scriptParameters.add(TestMethodGradleConfigurationProducer.createTestFilter(className, testName));
                    if (!useResolvedTasks) continue;
                    if (className == null) {
                        useResolvedTasks = false;
                        continue;
                    }
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.projectScope((Project)project));
                    if (psiClass == null) {
                        useResolvedTasks = false;
                        continue;
                    }
                    PsiFile psiFile = psiClass.getContainingFile();
                    if (psiFile == null) {
                        useResolvedTasks = false;
                        continue;
                    }
                    Module moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(psiFile.getVirtualFile());
                    if (moduleForFile == null) {
                        useResolvedTasks = false;
                        continue;
                    }
                    ContainerUtil.addAllNotNull((Collection)tasksToRun, GradleTestRunConfigurationProducer.getTasksToRun(moduleForFile));
                }
                runProfile.getSettings().setScriptParameters(StringUtil.join((Collection)scriptParameters, (String)" "));
                if (useResolvedTasks && !tasksToRun.isEmpty()) {
                    runProfile.getSettings().setTaskNames((List)ContainerUtil.newArrayList((Iterable)tasksToRun));
                }
                return runProfile.getState(executor, environment);
            }
        };
    }
}

