/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2.targets;

import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.sdklib.repositoryv2.targets.AddonTarget;
import com.android.sdklib.repositoryv2.targets.PlatformTarget;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AndroidTargetManager {
    private Map<LocalPackage, IAndroidTarget> mTargets;
    private final FileOp mFop;
    private final AndroidSdkHandler mSdkHandler;
    private Map<String, String> mLoadErrors;
    private Comparator<LocalPackage> TARGET_COMPARATOR;

    public AndroidTargetManager(AndroidSdkHandler handler, FileOp fop) {
        this.mSdkHandler = handler;
        this.mFop = fop;
    }

    public Collection<IAndroidTarget> getTargets(ProgressIndicator progress) {
        return this.getTargetMap(progress).values();
    }

    private Map<LocalPackage, IAndroidTarget> getTargetMap(ProgressIndicator progress) {
        if (this.mTargets == null) {
            TypeDetails details;
            HashMap newErrors = Maps.newHashMap();
            this.TARGET_COMPARATOR = new Comparator<LocalPackage>(){

                @Override
                public int compare(LocalPackage o1, LocalPackage o2) {
                    DetailsTypes.ApiDetailsType details1 = (DetailsTypes.ApiDetailsType)o1.getTypeDetails();
                    DetailsTypes.ApiDetailsType details2 = (DetailsTypes.ApiDetailsType)o2.getTypeDetails();
                    AndroidVersion version1 = DetailsTypes.getAndroidVersion(details1);
                    AndroidVersion version2 = DetailsTypes.getAndroidVersion(details2);
                    return ComparisonChain.start().compare((Comparable)version1, (Comparable)version2).compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath())).compare((Comparable)((Object)details1.getClass().getName()), (Comparable)((Object)details2.getClass().getName())).result();
                }
            };
            TreeMap result = Maps.newTreeMap(this.TARGET_COMPARATOR);
            RepoManager manager = this.mSdkHandler.getSdkManager(progress);
            HashMap platformTargets = Maps.newHashMap();
            for (LocalPackage p : manager.getPackages().getLocalPackages().values()) {
                details = p.getTypeDetails();
                if (!(details instanceof DetailsTypes.PlatformDetailsType)) continue;
                try {
                    PlatformTarget target = new PlatformTarget(p, this.mSdkHandler, this.mFop, progress);
                    result.put(p, target);
                    platformTargets.put(target.getVersion(), target);
                }
                catch (IllegalArgumentException e) {
                    newErrors.put(p.getPath(), e.getMessage());
                }
            }
            for (LocalPackage p : manager.getPackages().getLocalPackages().values()) {
                AndroidVersion addonVersion;
                PlatformTarget baseTarget;
                details = p.getTypeDetails();
                if (!(details instanceof DetailsTypes.AddonDetailsType) || (baseTarget = (PlatformTarget)platformTargets.get(addonVersion = DetailsTypes.getAndroidVersion((DetailsTypes.AddonDetailsType)details))) == null) continue;
                result.put(p, new AddonTarget(p, baseTarget, this.mSdkHandler.getSystemImageManager(progress), progress, this.mFop));
            }
            this.mTargets = result;
            this.mLoadErrors = newErrors;
        }
        return this.mTargets;
    }

    public IAndroidTarget getTargetFromHashString(String hash, ProgressIndicator progress) {
        if (hash != null) {
            for (IAndroidTarget target : this.getTargets(progress)) {
                if (target == null || !hash.equals(AndroidTargetHash.getTargetHashString(target))) continue;
                return target;
            }
        }
        return null;
    }

    public String getErrorForPackage(String path) {
        if (this.mLoadErrors == null) {
            this.getTargetMap((ProgressIndicator)new ConsoleProgressIndicator());
        }
        return this.mLoadErrors.get(path);
    }

    public IAndroidTarget getTargetFromPackage(LocalPackage p, ProgressIndicator progress) {
        return this.getTargetMap(progress).get(p);
    }
}

