/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ListIterator;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayInitializer;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.BooleanLiteral;
import lombok.ast.Cast;
import lombok.ast.CharLiteral;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeReference;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class ConstantEvaluator {
    private final JavaContext mContext;
    private boolean mAllowUnknown;

    public ConstantEvaluator(JavaContext context) {
        this.mContext = context;
    }

    public ConstantEvaluator allowUnknowns() {
        this.mAllowUnknown = true;
        return this;
    }

    @Deprecated
    public Object evaluate(Node node) {
        if (node instanceof NullLiteral) {
            return null;
        }
        if (node instanceof BooleanLiteral) {
            return ((BooleanLiteral)node).astValue();
        }
        if (node instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)node;
            return string.astValue();
        }
        if (node instanceof CharLiteral) {
            return ((CharLiteral)node).astValue();
        }
        if (node instanceof IntegralLiteral) {
            IntegralLiteral literal = (IntegralLiteral)node;
            if (literal.astMarkedAsLong()) {
                return literal.astLongValue();
            }
            return literal.astIntValue();
        }
        if (node instanceof FloatingPointLiteral) {
            FloatingPointLiteral literal = (FloatingPointLiteral)node;
            if (literal.astMarkedAsFloat()) {
                return Float.valueOf(literal.astFloatValue());
            }
            return literal.astDoubleValue();
        }
        if (node instanceof UnaryExpression) {
            UnaryOperator operator = ((UnaryExpression)node).astOperator();
            Object operand = this.evaluate((Node)((UnaryExpression)node).astOperand());
            if (operand == null) {
                return null;
            }
            switch (operator) {
                case LOGICAL_NOT: {
                    if (!(operand instanceof Boolean)) break;
                    return (Boolean)operand == false;
                }
                case UNARY_PLUS: {
                    return operand;
                }
                case BINARY_NOT: {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (!(operand instanceof Byte)) break;
                    return (int)(~((Byte)operand).byteValue());
                }
                case UNARY_MINUS: {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (!(operand instanceof Byte)) break;
                    return (int)(-((Byte)operand).byteValue());
                }
            }
        } else if (node instanceof InlineIfExpression) {
            InlineIfExpression expression = (InlineIfExpression)node;
            Object known = this.evaluate((Node)expression.astCondition());
            if (known == Boolean.TRUE && expression.astIfTrue() != null) {
                return this.evaluate((Node)expression.astIfTrue());
            }
            if (known == Boolean.FALSE && expression.astIfFalse() != null) {
                return this.evaluate((Node)expression.astIfFalse());
            }
        } else if (node instanceof BinaryExpression) {
            BinaryOperator operator = ((BinaryExpression)node).astOperator();
            Object operandLeft = this.evaluate((Node)((BinaryExpression)node).astLeft());
            Object operandRight = this.evaluate((Node)((BinaryExpression)node).astRight());
            if (operandLeft == null || operandRight == null) {
                if (this.mAllowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == BinaryOperator.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                switch (operator) {
                    case LOGICAL_OR: {
                        return left || right;
                    }
                    case LOGICAL_AND: {
                        return left && right;
                    }
                    case BITWISE_OR: {
                        return left | right;
                    }
                    case BITWISE_XOR: {
                        return left ^ right;
                    }
                    case BITWISE_AND: {
                        return left & right;
                    }
                    case EQUALS: {
                        return left == right;
                    }
                    case NOT_EQUALS: {
                        return left != right;
                    }
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean isWide = isInteger ? left instanceof Long || right instanceof Long : left instanceof Double || right instanceof Double;
                switch (operator) {
                    case BITWISE_OR: {
                        if (isWide) {
                            return left.longValue() | right.longValue();
                        }
                        return left.intValue() | right.intValue();
                    }
                    case BITWISE_XOR: {
                        if (isWide) {
                            return left.longValue() ^ right.longValue();
                        }
                        return left.intValue() ^ right.intValue();
                    }
                    case BITWISE_AND: {
                        if (isWide) {
                            return left.longValue() & right.longValue();
                        }
                        return left.intValue() & right.intValue();
                    }
                    case EQUALS: {
                        if (isInteger) {
                            return left.longValue() == right.longValue();
                        }
                        return left.doubleValue() == right.doubleValue();
                    }
                    case NOT_EQUALS: {
                        if (isInteger) {
                            return left.longValue() != right.longValue();
                        }
                        return left.doubleValue() != right.doubleValue();
                    }
                    case GREATER: {
                        if (isInteger) {
                            return left.longValue() > right.longValue();
                        }
                        return left.doubleValue() > right.doubleValue();
                    }
                    case GREATER_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() >= right.longValue();
                        }
                        return left.doubleValue() >= right.doubleValue();
                    }
                    case LESS: {
                        if (isInteger) {
                            return left.longValue() < right.longValue();
                        }
                        return left.doubleValue() < right.doubleValue();
                    }
                    case LESS_OR_EQUAL: {
                        if (isInteger) {
                            return left.longValue() <= right.longValue();
                        }
                        return left.doubleValue() <= right.doubleValue();
                    }
                    case SHIFT_LEFT: {
                        if (isWide) {
                            return left.longValue() << right.intValue();
                        }
                        return left.intValue() << right.intValue();
                    }
                    case SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >> right.intValue();
                        }
                        return left.intValue() >> right.intValue();
                    }
                    case BITWISE_SHIFT_RIGHT: {
                        if (isWide) {
                            return left.longValue() >>> right.intValue();
                        }
                        return left.intValue() >>> right.intValue();
                    }
                    case PLUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() + right.longValue();
                            }
                            return left.intValue() + right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() + right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() + right.floatValue());
                    }
                    case MINUS: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() - right.longValue();
                            }
                            return left.intValue() - right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() - right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() - right.floatValue());
                    }
                    case MULTIPLY: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() * right.longValue();
                            }
                            return left.intValue() * right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() * right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() * right.floatValue());
                    }
                    case DIVIDE: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() / right.longValue();
                            }
                            return left.intValue() / right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() / right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() / right.floatValue());
                    }
                    case REMAINDER: {
                        if (isInteger) {
                            if (isWide) {
                                return left.longValue() % right.longValue();
                            }
                            return left.intValue() % right.intValue();
                        }
                        if (isWide) {
                            return left.doubleValue() % right.doubleValue();
                        }
                        return Float.valueOf(left.floatValue() % right.floatValue());
                    }
                }
                return null;
            }
        } else {
            if (node instanceof Cast) {
                Cast cast = (Cast)node;
                Object operandValue = this.evaluate((Node)cast.astOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    String typeName = cast.astTypeReference().getTypeName();
                    if (typeName.equals("float")) {
                        return Float.valueOf(number.floatValue());
                    }
                    if (typeName.equals("double")) {
                        return number.doubleValue();
                    }
                    if (typeName.equals("int")) {
                        return number.intValue();
                    }
                    if (typeName.equals("long")) {
                        return number.longValue();
                    }
                    if (typeName.equals("short")) {
                        return number.shortValue();
                    }
                    if (typeName.equals("byte")) {
                        return number.byteValue();
                    }
                }
                return operandValue;
            }
            if (this.mContext != null && (node instanceof VariableReference || node instanceof Select)) {
                Statement statement;
                JavaParser.ResolvedNode resolved = this.mContext.resolve(node);
                if (resolved instanceof JavaParser.ResolvedField) {
                    VariableDefinitionEntry first;
                    StrictListAccessor variables;
                    VariableDeclaration declaration;
                    VariableDefinition definition;
                    JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
                    Object value = field.getValue();
                    if (value != null) {
                        return value;
                    }
                    Node astNode = field.findAstNode();
                    if (astNode instanceof VariableDeclaration && (definition = (declaration = (VariableDeclaration)astNode).astDefinition()) != null && definition.astModifiers().isFinal() && (variables = definition.astVariables()).size() == 1 && (first = (VariableDefinitionEntry)variables.first()).astInitializer() != null) {
                        return this.evaluate((Node)first.astInitializer());
                    }
                    return null;
                }
                if (node instanceof VariableReference && (statement = JavaContext.getParentOfType(node, Statement.class, false)) != null) {
                    ListIterator iterator = statement.getParent().getChildren().listIterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != statement) continue;
                        if (!iterator.hasPrevious()) break;
                        iterator.previous();
                        break;
                    }
                    String targetName = ((VariableReference)node).astIdentifier().astValue();
                    while (iterator.hasPrevious()) {
                        BinaryExpression binaryExpression;
                        ExpressionStatement expressionStatement;
                        Expression expression;
                        Node previous = (Node)iterator.previous();
                        if (previous instanceof VariableDeclaration) {
                            VariableDeclaration declaration = (VariableDeclaration)previous;
                            VariableDefinition definition = declaration.astDefinition();
                            for (VariableDefinitionEntry entry : definition.astVariables()) {
                                if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                                return this.evaluate((Node)entry.astInitializer());
                            }
                            continue;
                        }
                        if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                        return this.evaluate((Node)binaryExpression.astRight());
                    }
                }
            } else if (node instanceof ArrayCreation) {
                ArrayCreation creation = (ArrayCreation)node;
                ArrayInitializer initializer = creation.astInitializer();
                if (initializer != null) {
                    TypeReference typeReference = creation.astComponentTypeReference();
                    StrictListAccessor expressions = initializer.astExpressions();
                    ArrayList values = Lists.newArrayListWithExpectedSize((int)expressions.size());
                    Class<?> commonType = null;
                    for (Expression expression : expressions) {
                        Object value = this.evaluate((Node)expression);
                        if (value != null) {
                            values.add(value);
                            if (commonType == null) {
                                commonType = value.getClass();
                                continue;
                            }
                            while (!commonType.isAssignableFrom(value.getClass())) {
                                commonType = commonType.getSuperclass();
                            }
                            continue;
                        }
                        if (this.mAllowUnknown) continue;
                        return null;
                    }
                    if (!values.isEmpty()) {
                        Object o = Array.newInstance(commonType, values.size());
                        return values.toArray((Object[])o);
                    }
                    if (this.mContext != null) {
                        JavaParser.ResolvedNode type = this.mContext.resolve((Node)typeReference);
                        System.out.println(type);
                    }
                } else {
                    String type = creation.astComponentTypeReference().toString();
                    int size = 0;
                    if ("byte".equals(type)) {
                        return new byte[size];
                    }
                    if ("boolean".equals(type)) {
                        return new boolean[size];
                    }
                    if ("int".equals(type)) {
                        return new int[size];
                    }
                    if ("long".equals(type)) {
                        return new long[size];
                    }
                    if ("char".equals(type)) {
                        return new char[size];
                    }
                    if ("float".equals(type)) {
                        return new float[size];
                    }
                    if ("double".equals(type)) {
                        return new double[size];
                    }
                    if ("java.lang.String".equals(type)) {
                        return new String[size];
                    }
                    if ("short".equals(type)) {
                        return new short[size];
                    }
                    if ("java.lang.Object".equals(type)) {
                        return new Object[size];
                    }
                }
            }
        }
        return null;
    }

    public Object evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PsiLiteral) {
            return ((PsiLiteral)node).getValue();
        }
        if (node instanceof PsiPrefixExpression) {
            IElementType operator = ((PsiPrefixExpression)node).getOperationTokenType();
            Object operand = this.evaluate((PsiElement)((PsiPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == JavaTokenType.EXCL) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == JavaTokenType.PLUS) {
                    return operand;
                }
                if (operator == JavaTokenType.TILDE) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == JavaTokenType.MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)node;
            Object known = this.evaluate((PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((PsiElement)expression.getElseExpression());
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return this.evaluate((PsiElement)expression);
            }
        } else if (node instanceof PsiBinaryExpression) {
            IElementType operator = ((PsiBinaryExpression)node).getOperationTokenType();
            Object operandLeft = this.evaluate((PsiElement)((PsiBinaryExpression)node).getLOperand());
            Object operandRight = this.evaluate((PsiElement)((PsiBinaryExpression)node).getROperand());
            if (operandLeft == null || operandRight == null) {
                if (this.mAllowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && operandRight instanceof String) {
                if (operator == JavaTokenType.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                if (operator == JavaTokenType.OROR) {
                    return left || right;
                }
                if (operator == JavaTokenType.ANDAND) {
                    return left && right;
                }
                if (operator == JavaTokenType.OR) {
                    return left | right;
                }
                if (operator == JavaTokenType.XOR) {
                    return left ^ right;
                }
                if (operator == JavaTokenType.AND) {
                    return left & right;
                }
                if (operator == JavaTokenType.EQEQ) {
                    return left == right;
                }
                if (operator == JavaTokenType.NE) {
                    return left != right;
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isWide;
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        return left.longValue() | right.longValue();
                    }
                    return left.intValue() | right.intValue();
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        return left.longValue() ^ right.longValue();
                    }
                    return left.intValue() ^ right.intValue();
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        return left.longValue() & right.longValue();
                    }
                    return left.intValue() & right.intValue();
                }
                if (operator == JavaTokenType.EQEQ) {
                    if (isInteger) {
                        return left.longValue() == right.longValue();
                    }
                    return left.doubleValue() == right.doubleValue();
                }
                if (operator == JavaTokenType.NE) {
                    if (isInteger) {
                        return left.longValue() != right.longValue();
                    }
                    return left.doubleValue() != right.doubleValue();
                }
                if (operator == JavaTokenType.GT) {
                    if (isInteger) {
                        return left.longValue() > right.longValue();
                    }
                    return left.doubleValue() > right.doubleValue();
                }
                if (operator == JavaTokenType.GE) {
                    if (isInteger) {
                        return left.longValue() >= right.longValue();
                    }
                    return left.doubleValue() >= right.doubleValue();
                }
                if (operator == JavaTokenType.LT) {
                    if (isInteger) {
                        return left.longValue() < right.longValue();
                    }
                    return left.doubleValue() < right.doubleValue();
                }
                if (operator == JavaTokenType.LE) {
                    if (isInteger) {
                        return left.longValue() <= right.longValue();
                    }
                    return left.doubleValue() <= right.doubleValue();
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        return left.longValue() << right.intValue();
                    }
                    return left.intValue() << right.intValue();
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        return left.longValue() >> right.intValue();
                    }
                    return left.intValue() >> right.intValue();
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        return left.longValue() >>> right.intValue();
                    }
                    return left.intValue() >>> right.intValue();
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() + right.longValue();
                        }
                        return left.intValue() + right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() + right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() + right.floatValue());
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() - right.longValue();
                        }
                        return left.intValue() - right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() - right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() - right.floatValue());
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() * right.longValue();
                        }
                        return left.intValue() * right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() * right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() * right.floatValue());
                }
                if (operator == JavaTokenType.DIV) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() / right.longValue();
                        }
                        return left.intValue() / right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() / right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() / right.floatValue());
                }
                if (operator == JavaTokenType.PERC) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() % right.longValue();
                        }
                        return left.intValue() % right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() % right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() % right.floatValue());
                }
                return null;
            }
        } else {
            if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                Object operandValue = this.evaluate((PsiElement)cast.getOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    PsiTypeElement typeElement = cast.getCastType();
                    if (typeElement != null) {
                        PsiType type = typeElement.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                }
                return operandValue;
            }
            if (node instanceof PsiReference) {
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    Object value = field.computeConstantValue();
                    if (value != null) {
                        return value;
                    }
                    if (field.getInitializer() != null) {
                        return this.evaluate((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)resolved;
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                    if (statement != null) {
                        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                        String targetName = variable.getName();
                        if (targetName == null) {
                            return null;
                        }
                        while (prev != null) {
                            PsiReferenceExpression reference;
                            PsiAssignmentExpression assign;
                            PsiExpression lhs;
                            PsiExpression expression;
                            if (prev instanceof PsiDeclarationStatement) {
                                for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                    if (!variable.equals(element)) continue;
                                    return this.evaluate((PsiElement)variable.getInitializer());
                                }
                            } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                                return this.evaluate((PsiElement)assign.getRExpression());
                            }
                            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                        }
                    }
                }
            } else if (node instanceof PsiNewExpression) {
                PsiNewExpression creation = (PsiNewExpression)node;
                PsiArrayInitializerExpression initializer = creation.getArrayInitializer();
                PsiType type = creation.getType();
                if (type instanceof PsiArrayType) {
                    Object fixedSize;
                    if (initializer != null) {
                        int i;
                        Object[] array;
                        PsiExpression[] initializers = initializer.getInitializers();
                        Class<?> commonType = null;
                        ArrayList values = Lists.newArrayListWithExpectedSize((int)initializers.length);
                        int count = 0;
                        for (PsiExpression expression : initializers) {
                            Object value = this.evaluate((PsiElement)expression);
                            if (value != null) {
                                values.add(value);
                                if (commonType == null) {
                                    commonType = value.getClass();
                                } else {
                                    while (!commonType.isAssignableFrom(value.getClass())) {
                                        commonType = commonType.getSuperclass();
                                    }
                                }
                            } else if (!this.mAllowUnknown) {
                                return null;
                            }
                            if (++count == 20) break;
                        }
                        if ((type = type.getDeepComponentType()) == PsiType.INT) {
                            if (!values.isEmpty()) {
                                array = new int[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Integer)) continue;
                                    array[i] = (Integer)o;
                                }
                                return array;
                            }
                            return new int[0];
                        }
                        if (type == PsiType.BOOLEAN) {
                            if (!values.isEmpty()) {
                                array = new boolean[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Boolean)) continue;
                                    array[i] = ((Boolean)o).booleanValue() ? 1 : 0;
                                }
                                return array;
                            }
                            return new boolean[0];
                        }
                        if (type == PsiType.DOUBLE) {
                            if (!values.isEmpty()) {
                                array = new double[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Double)) continue;
                                    array[i] = (int)((Double)o).doubleValue();
                                }
                                return array;
                            }
                            return new double[0];
                        }
                        if (type == PsiType.LONG) {
                            if (!values.isEmpty()) {
                                array = new long[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Long)) continue;
                                    array[i] = (int)((Long)o).longValue();
                                }
                                return array;
                            }
                            return new long[0];
                        }
                        if (type == PsiType.FLOAT) {
                            if (!values.isEmpty()) {
                                array = new float[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Float)) continue;
                                    array[i] = (int)((Float)o).floatValue();
                                }
                                return array;
                            }
                            return new float[0];
                        }
                        if (type == PsiType.CHAR) {
                            if (!values.isEmpty()) {
                                array = new char[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Character)) continue;
                                    array[i] = ((Character)o).charValue();
                                }
                                return array;
                            }
                            return new char[0];
                        }
                        if (type == PsiType.BYTE) {
                            if (!values.isEmpty()) {
                                array = new byte[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Byte)) continue;
                                    array[i] = ((Byte)o).byteValue();
                                }
                                return array;
                            }
                            return new byte[0];
                        }
                        if (type == PsiType.SHORT) {
                            if (!values.isEmpty()) {
                                array = new short[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Short)) continue;
                                    array[i] = ((Short)o).shortValue();
                                }
                                return array;
                            }
                            return new short[0];
                        }
                        if (!values.isEmpty()) {
                            Object o = Array.newInstance(commonType, values.size());
                            return values.toArray((Object[])o);
                        }
                        return null;
                    }
                    PsiExpression[] arrayDimensions = creation.getArrayDimensions();
                    int size = 0;
                    if (arrayDimensions.length == 1 && (fixedSize = this.evaluate((PsiElement)arrayDimensions[0])) instanceof Number && (size = ((Number)fixedSize).intValue()) > 30) {
                        size = 30;
                    }
                    if ((type = type.getDeepComponentType()) instanceof PsiPrimitiveType) {
                        if (PsiType.BYTE.equals((Object)type)) {
                            return new byte[size];
                        }
                        if (PsiType.BOOLEAN.equals((Object)type)) {
                            return new boolean[size];
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return new int[size];
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return new long[size];
                        }
                        if (PsiType.CHAR.equals((Object)type)) {
                            return new char[size];
                        }
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return new float[size];
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return new double[size];
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return new short[size];
                        }
                    } else if (type instanceof PsiClassType) {
                        String className = type.getCanonicalText();
                        if ("java.lang.String".equals(className)) {
                            return new String[size];
                        }
                        if ("java.lang.Object".equals(className)) {
                            return new Object[size];
                        }
                    }
                }
            }
        }
        return null;
    }

    public static boolean isArrayLiteral(PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand;
        if (node instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return ConstantEvaluator.isArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable.getName();
                    if (targetName == null) {
                        return false;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression;
                        if (prev instanceof PsiDeclarationStatement) {
                            for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                if (!variable.equals(element)) continue;
                                return ConstantEvaluator.isArrayLiteral((PsiElement)variable.getInitializer());
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            return ConstantEvaluator.isArrayLiteral((PsiElement)assign.getRExpression());
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type = creation.getType();
            if (type instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)expression);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return ConstantEvaluator.isArrayLiteral((PsiElement)operand);
        }
        return false;
    }

    @Deprecated
    public static Object evaluate(JavaContext context, Node node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    @Deprecated
    public static String evaluateString(JavaContext context, Node node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }

    public static Object evaluate(JavaContext context, PsiElement node) {
        return new ConstantEvaluator(context).evaluate(node);
    }

    public static String evaluateString(JavaContext context, PsiElement node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator(context);
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }
}

