/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32Bitfield
implements Bitfield {
    private static final int UNIT_SIZE = 32;
    private int storage = 0;

    @Override
    public int size() {
        return 32;
    }

    @Override
    public final void clearField(boolean bl) {
        this.storage = bl ? -1 : 0;
    }

    private static final void check(int n, int n2) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 >= n) {
            int n3 = n - 1;
            throw new IndexOutOfBoundsException(new StringBuilder(60).append("Bitnum should be within [0..").append(n3).append("], but is ").append(n2).toString());
        }
    }

    @Override
    public final int get32(int n, int n2) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 > 32) {
            throw new IndexOutOfBoundsException(new StringBuilder(51).append("length should be within [0..32], but is ").append(n2).toString());
        }
        Int32Bitfield.check(32 - n2 + 1, n);
        int n3 = 32 - n;
        if (32 == n3) {
            int n4 = Bitfield.Util.getBitMask(n2);
            return n4 & this.storage;
        }
        int n5 = Math.min(n2, n3);
        int n6 = (1 << n5) - 1;
        return n6 & this.storage >>> n;
    }

    @Override
    public final void put32(int n, int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n2 || n2 > 32) {
            throw new IndexOutOfBoundsException(new StringBuilder(51).append("length should be within [0..32], but is ").append(n2).toString());
        }
        Int32Bitfield.check(32 - n2 + 1, n);
        int n4 = 32 - n;
        if (32 == n4) {
            int n5 = Bitfield.Util.getBitMask(n2);
            this.storage = ~n5 & this.storage | n5 & n3;
        } else {
            int n6 = Math.min(n2, n4);
            int n7 = (1 << n6) - 1;
            this.storage = ~(n7 << n) & this.storage | (n7 & n3) << n;
        }
    }

    @Override
    public final int copy32(int n, int n2, int n3) throws IndexOutOfBoundsException {
        int n4 = this.get32(n, n3);
        this.put32(n2, n3, n4);
        return n4;
    }

    @Override
    public final boolean get(int n) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n);
        return 0 != (this.storage & 1 << n);
    }

    @Override
    public final boolean put(int n, boolean bl) throws IndexOutOfBoundsException {
        boolean bl2;
        Int32Bitfield.check(32, n);
        int n2 = 1 << n;
        boolean bl3 = bl2 = 0 != (this.storage & n2);
        if (bl2 != bl) {
            this.storage = bl ? (this.storage |= n2) : (this.storage &= ~n2);
        }
        return bl2;
    }

    @Override
    public final void set(int n) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n);
        int n2 = 1 << n;
        this.storage |= n2;
    }

    @Override
    public final void clear(int n) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n);
        int n2 = 1 << n;
        this.storage &= ~n2;
    }

    @Override
    public final boolean copy(int n, int n2) throws IndexOutOfBoundsException {
        Int32Bitfield.check(32, n);
        Int32Bitfield.check(32, n2);
        boolean bl = 0 != (this.storage & 1 << n);
        int n3 = 1 << n2;
        this.storage = bl ? (this.storage |= n3) : (this.storage &= ~n3);
        return bl;
    }

    @Override
    public int bitCount() {
        return Bitfield.Util.bitCount(this.storage);
    }
}

