/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.InterruptSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import jogamp.common.Debug;

public class TempFileCache {
    private static final boolean DEBUG = Debug.debug("TempFileCache");
    private static boolean staticInitError = false;
    private static final String tmpDirPrefix = "file_cache";
    private static final File tmpBaseDir;
    static final String tmpRootPropName = "jnlp.jogamp.tmp.cache.root";
    private static String tmpRootPropValue;
    private static File tmpRootDir;
    private boolean initError = false;
    private File individualTmpDir;

    public static boolean initSingleton() {
        return !staticInitError;
    }

    private static void initTmpRoot() throws IOException {
        Object object;
        tmpRootPropValue = System.getProperty(tmpRootPropName);
        if (tmpRootPropValue != null) {
            if (tmpRootPropValue.indexOf(47) >= 0 || tmpRootPropValue.indexOf(File.separatorChar) >= 0) {
                throw new IOException("Illegal value of: jnlp.jogamp.tmp.cache.root");
            }
            if (DEBUG) {
                String string = String.valueOf("TempFileCache: Trying existing value of: jnlp.jogamp.tmp.cache.root=");
                String string2 = String.valueOf(tmpRootPropValue);
                System.err.println(string2.length() != 0 ? string.concat(string2) : new String(string));
            }
            tmpRootDir = new File(tmpBaseDir, tmpRootPropValue);
            if (DEBUG) {
                String string = String.valueOf(tmpRootDir.getAbsolutePath());
                System.err.println(string.length() != 0 ? "TempFileCache: Trying tmpRootDir = ".concat(string) : new String("TempFileCache: Trying tmpRootDir = "));
            }
            if (tmpRootDir.isDirectory()) {
                if (!tmpRootDir.canWrite()) {
                    String string = String.valueOf(tmpRootDir.getAbsolutePath());
                    throw new IOException(string.length() != 0 ? "Temp root directory is not writable: ".concat(string) : new String("Temp root directory is not writable: "));
                }
            } else {
                object = String.valueOf(tmpRootDir.getAbsolutePath());
                System.err.println(new StringBuilder(75 + String.valueOf(object).length()).append("TempFileCache: None existing tmpRootDir = ").append((String)object).append(", assuming new path due to update").toString());
                tmpRootPropValue = null;
                tmpRootDir = null;
                System.clearProperty(tmpRootPropName);
            }
        }
        if (tmpRootPropValue == null) {
            object = File.createTempFile("jln", ".tmp", tmpBaseDir);
            if (DEBUG) {
                String string = String.valueOf(((File)object).getAbsolutePath());
                System.err.println(string.length() != 0 ? "TempFileCache: tmpFile = ".concat(string) : new String("TempFileCache: tmpFile = "));
            }
            final FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            FileChannel fileChannel = fileOutputStream.getChannel();
            final FileLock fileLock = fileChannel.lock();
            String string = ((File)object).getAbsolutePath();
            String string3 = string.substring(0, string.lastIndexOf(".tmp"));
            String string4 = String.valueOf(string3).concat(".lck");
            File file = new File(string4);
            if (DEBUG) {
                String string5 = String.valueOf(file.getAbsolutePath());
                System.err.println(string5.length() != 0 ? "TempFileCache: lckFile = ".concat(string5) : new String("TempFileCache: lckFile = "));
            }
            file.createNewFile();
            final FileOutputStream fileOutputStream2 = new FileOutputStream(file);
            FileChannel fileChannel2 = fileOutputStream2.getChannel();
            final FileLock fileLock2 = fileChannel2.lock();
            tmpRootDir = new File(string3);
            if (DEBUG) {
                String string6 = String.valueOf(tmpRootDir.getAbsolutePath());
                System.err.println(string6.length() != 0 ? "TempFileCache: tmpRootDir = ".concat(string6) : new String("TempFileCache: tmpRootDir = "));
            }
            if (!tmpRootDir.mkdir()) {
                String string7 = String.valueOf(tmpRootDir);
                throw new IOException(new StringBuilder(14 + String.valueOf(string7).length()).append("Cannot create ").append(string7).toString());
            }
            Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread(){

                @Override
                public void run() {
                    try {
                        fileOutputStream.close();
                        fileLock.release();
                        fileOutputStream2.close();
                        fileLock2.release();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            tmpRootPropValue = string3.substring(string3.lastIndexOf(File.separator) + 1);
            System.setProperty(tmpRootPropName, tmpRootPropValue);
            if (DEBUG) {
                String string8 = String.valueOf("TempFileCache: Setting jnlp.jogamp.tmp.cache.root=");
                String string9 = String.valueOf(tmpRootPropValue);
                System.err.println(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            }
            InterruptSource.Thread thread = new InterruptSource.Thread(){

                @Override
                public void run() {
                    TempFileCache.deleteOldTempDirs();
                }
            };
            thread.setName("TempFileCache-Reaper");
            thread.start();
        }
    }

    private static void deleteOldTempDirs() {
        String string;
        FilenameFilter filenameFilter;
        String[] stringArray;
        if (DEBUG) {
            String string2 = String.valueOf(tmpBaseDir.getAbsolutePath());
            System.err.println(string2.length() != 0 ? "TempFileCache: *** Reaper: deleteOldTempDirs in ".concat(string2) : new String("TempFileCache: *** Reaper: deleteOldTempDirs in "));
        }
        if ((stringArray = tmpBaseDir.list(filenameFilter = new FilenameFilter(string = String.valueOf(tmpRootPropValue).concat(".lck")){
            final /* synthetic */ String val$ourLockFile;
            {
                this.val$ourLockFile = string;
            }

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".lck") && !string.equals(this.val$ourLockFile);
            }
        })) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                String string4 = string3.substring(0, string3.lastIndexOf(".lck"));
                String string5 = String.valueOf(string4).concat(".tmp");
                File file = new File(tmpBaseDir, string3);
                File file2 = new File(tmpBaseDir, string5);
                File file3 = new File(tmpBaseDir, string4);
                if (file.exists() && file2.exists() && file3.isDirectory()) {
                    FileLock fileLock;
                    FileOutputStream fileOutputStream;
                    FileLock fileLock2;
                    FileOutputStream fileOutputStream2;
                    block17: {
                        block16: {
                            fileOutputStream2 = null;
                            FileChannel fileChannel = null;
                            fileLock2 = null;
                            try {
                                fileOutputStream2 = new FileOutputStream(file2);
                                fileChannel = fileOutputStream2.getChannel();
                                fileLock2 = fileChannel.tryLock();
                            }
                            catch (Exception exception) {
                                if (!DEBUG) break block16;
                                exception.printStackTrace();
                            }
                        }
                        if (fileLock2 == null) continue;
                        fileOutputStream = null;
                        FileChannel fileChannel = null;
                        fileLock = null;
                        try {
                            fileOutputStream = new FileOutputStream(file);
                            fileChannel = fileOutputStream.getChannel();
                            fileLock = fileChannel.tryLock();
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block17;
                            exception.printStackTrace();
                        }
                    }
                    if (fileLock != null) {
                        TempFileCache.removeAll(file3);
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        file.delete();
                        try {
                            fileOutputStream2.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        file2.delete();
                        continue;
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        fileOutputStream2.close();
                        fileLock2.release();
                    }
                    catch (IOException iOException) {
                        if (!DEBUG) continue;
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (!DEBUG) continue;
                String string6 = String.valueOf(file3.getAbsolutePath());
                System.err.println(string6.length() != 0 ? "TempFileCache: Skipping: ".concat(string6) : new String("TempFileCache: Skipping: "));
            }
        }
    }

    private static void removeAll(File file) {
        File[] fileArray;
        if (DEBUG) {
            fileArray = String.valueOf(file);
            System.err.println(new StringBuilder(26 + String.valueOf(fileArray).length()).append("TempFileCache: removeAll(").append((String)fileArray).append(")").toString());
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                TempFileCache.removeAll(fileArray[i]);
            }
        }
        file.delete();
    }

    public TempFileCache() {
        String string;
        if (DEBUG) {
            boolean bl = !staticInitError;
            System.err.println(new StringBuilder(75).append("TempFileCache: new TempFileCache() --------------------- (static ok: ").append(bl).append(")").toString());
            string = String.valueOf(Thread.currentThread().getName());
            String string2 = String.valueOf(Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()));
            String string3 = String.valueOf(Integer.toHexString(this.hashCode()));
            System.err.println(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("TempFileCache: Thread: ").append(string).append(", CL 0x").append(string2).append(", this 0x").append(string3).toString());
        }
        if (!staticInitError) {
            try {
                this.createTmpDir();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.initError = true;
            }
        }
        if (DEBUG) {
            string = String.valueOf(this.individualTmpDir);
            boolean bl = !this.initError;
            System.err.println(new StringBuilder(35 + String.valueOf(string).length()).append("TempFileCache: tempDir ").append(string).append(" (ok: ").append(bl).append(")").toString());
            System.err.println("----------------------------------------------------------");
        }
    }

    public void destroy() {
        if (DEBUG) {
            boolean bl = !staticInitError;
            System.err.println(new StringBuilder(65).append("TempFileCache: destroy() --------------------- (static ok: ").append(bl).append(")").toString());
            String string = String.valueOf(Thread.currentThread().getName());
            String string2 = String.valueOf(Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()));
            String string3 = String.valueOf(Integer.toHexString(this.hashCode()));
            System.err.println(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("TempFileCache: Thread: ").append(string).append(", CL 0x").append(string2).append(", this 0x").append(string3).toString());
        }
        if (!staticInitError) {
            try {
                TempFileCache.removeAll(this.individualTmpDir);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.individualTmpDir = null;
        if (DEBUG) {
            System.err.println("TempFileCache: destroy() END");
        }
    }

    public boolean isValid() {
        return !staticInitError && !this.initError;
    }

    public File getBaseDir() {
        return tmpBaseDir;
    }

    public File getRootDir() {
        return tmpRootDir;
    }

    public File getTempDir() {
        return this.individualTmpDir;
    }

    private void createTmpDir() throws IOException {
        File file = File.createTempFile("jln", ".tmp", tmpRootDir);
        String string = file.getAbsolutePath();
        String string2 = string.substring(0, string.lastIndexOf(".tmp"));
        this.individualTmpDir = new File(string2);
        if (!this.individualTmpDir.mkdir()) {
            String string3 = String.valueOf(this.individualTmpDir);
            throw new IOException(new StringBuilder(14 + String.valueOf(string3).length()).append("Cannot create ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            File file = null;
            try {
                file = new File(IOUtil.getTempDir(true), tmpDirPrefix);
                file = IOUtil.testDir(file, true, false);
            }
            catch (Exception exception) {
                System.err.println("Warning: Caught Exception while retrieving executable temp base directory:");
                exception.printStackTrace();
                staticInitError = true;
            }
            tmpBaseDir = file;
            if (DEBUG) {
                String string = null != tmpBaseDir ? tmpBaseDir.getAbsolutePath() : null;
                boolean bl = !staticInitError;
                System.err.println(new StringBuilder(93).append("TempFileCache: Static Initialization ---------------------------------------------- OK: ").append(bl).toString());
                String string2 = String.valueOf(Thread.currentThread().getName());
                String string3 = String.valueOf(Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()));
                System.err.println(new StringBuilder(44 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string).length()).append("TempFileCache: Thread: ").append(string2).append(", CL 0x").append(string3).append(", tempBaseDir ").append(string).toString());
            }
            if (!staticInitError) {
                try {
                    TempFileCache.initTmpRoot();
                }
                catch (Exception exception) {
                    System.err.println("Warning: Caught Exception due to initializing TmpRoot:");
                    exception.printStackTrace();
                    staticInitError = true;
                }
            }
            if (DEBUG) {
                boolean bl = !staticInitError;
                System.err.println(new StringBuilder(76).append("------------------------------------------------------------------ OK: ").append(bl).toString());
            }
        }
    }
}

