/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArrayHashMap<K, V>
implements Cloneable,
Map<K, V> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final HashMap<K, V> map;
    private final ArrayList<V> data;
    private final boolean supportNullValue;

    public ArrayHashMap(boolean bl, int n, float f) {
        this.map = new HashMap(n, f);
        this.data = new ArrayList(n);
        this.supportNullValue = bl;
    }

    public ArrayHashMap(ArrayHashMap<K, V> arrayHashMap) {
        this.map = new HashMap<K, V>(arrayHashMap.map);
        this.data = new ArrayList<V>(arrayHashMap.data);
        this.supportNullValue = arrayHashMap.supportNullValue;
    }

    public final boolean supportsNullValue() {
        return this.supportNullValue;
    }

    public final Object clone() {
        return new ArrayHashMap<K, V>(this);
    }

    public final ArrayList<V> getData() {
        return this.data;
    }

    public final ArrayList<V> toArrayList() {
        return new ArrayList<V>(this.data);
    }

    public final HashMap<K, V> getMap() {
        return this.map;
    }

    public final String toString() {
        return this.data.toString();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public final V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public final V put(K k, V v) throws NullPointerException {
        V v2;
        if (this.supportNullValue) {
            boolean bl = this.map.containsKey(k);
            if (!bl) {
                v2 = this.map.put(k, v);
                if (null != v2) {
                    String string = String.valueOf(k);
                    String string2 = String.valueOf(v2);
                    throw new InternalError(new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Already existing, but checked before: ").append(string).append(" -> ").append(string2).toString());
                }
            } else {
                v2 = this.map.put(k, v);
                if (!this.data.remove(v2)) {
                    String string = String.valueOf(v2);
                    throw new InternalError(new StringBuilder(35 + String.valueOf(string).length()).append("Already existing, but not in list: ").append(string).toString());
                }
            }
        } else {
            ArrayHashMap.checkNullValue(v);
            v2 = this.map.put(k, v);
            if (null != v2 && !this.data.remove(v2)) {
                String string = String.valueOf(v2);
                throw new InternalError(new StringBuilder(35 + String.valueOf(string).length()).append("Already existing, but not in list: ").append(string).toString());
            }
        }
        if (!this.data.add(v)) {
            String string = String.valueOf(v);
            throw new InternalError(new StringBuilder(28 + String.valueOf(string).length()).append("Couldn't add value to list: ").append(string).toString());
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final V remove(Object object) {
        if (this.supportNullValue) {
            if (this.map.containsKey(object)) {
                V v = this.map.remove(object);
                if (!this.data.remove(v)) {
                    String string = String.valueOf(object);
                    String string2 = String.valueOf(v);
                    throw new InternalError(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Couldn't remove prev mapped pair: ").append(string).append(" -> ").append(string2).toString());
                }
                return v;
            }
        } else {
            V v = this.map.remove(object);
            if (null != v && !this.data.remove(v)) {
                String string = String.valueOf(object);
                String string3 = String.valueOf(v);
                throw new InternalError(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Couldn't remove prev mapped pair: ").append(string).append(" -> ").append(string3).toString());
            }
            return v;
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof ArrayHashMap)) {
            return false;
        }
        return this.map.equals(((ArrayHashMap)object).map);
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    private static final void checkNullValue(Object object) throws NullPointerException {
        if (null == object) {
            throw new NullPointerException("Null value not supported");
        }
    }
}

