/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class GitXmlRpcHandlerService<T> {
    @NotNull
    private final String myScriptTempFilePrefix;
    @NotNull
    private final String myHandlerName;
    @NotNull
    private final Class<? extends GitExternalApp> myScriptMainClass;
    @Nullable
    private File myScriptPath;
    @NotNull
    private final Object SCRIPT_FILE_LOCK = new Object();
    @NotNull
    private final THashMap<UUID, T> handlers = new THashMap();
    @NotNull
    private final Object HANDLERS_LOCK = new Object();

    protected GitXmlRpcHandlerService(@NotNull String prefix, @NotNull String handlerName, @NotNull Class<? extends GitExternalApp> aClass) {
        this.myScriptTempFilePrefix = prefix;
        this.myHandlerName = handlerName;
        this.myScriptMainClass = aClass;
    }

    public int getXmlRcpPort() {
        return BuiltInServerManager.getInstance().waitForStart().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public File getScriptPath() throws IOException {
        ScriptGenerator generator = new ScriptGenerator(this.myScriptTempFilePrefix, this.myScriptMainClass);
        generator.addClasses(XmlRpcClientLite.class, DecoderException.class, FileUtilRt.class);
        this.customizeScriptGenerator(generator);
        Object object = this.SCRIPT_FILE_LOCK;
        synchronized (object) {
            if (this.myScriptPath == null || !this.myScriptPath.exists()) {
                this.myScriptPath = generator.generate();
            }
            return this.myScriptPath;
        }
    }

    protected abstract void customizeScriptGenerator(@NotNull ScriptGenerator var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID registerHandler(@NotNull T handler, @NotNull Disposable parentDisposable) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
            if (!xmlRpcServer.hasHandler(this.myHandlerName)) {
                xmlRpcServer.addHandler(this.myHandlerName, this.createRpcRequestHandlerDelegate());
            }
            final UUID key = UUID.randomUUID();
            this.handlers.put((Object)key, handler);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    GitXmlRpcHandlerService.this.handlers.remove((Object)key);
                }
            });
            return key;
        }
    }

    @NotNull
    protected abstract Object createRpcRequestHandlerDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected T getHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            Object rc = this.handlers.get((Object)key);
            if (rc == null) {
                throw new IllegalStateException("No handler for the key " + key);
            }
            return (T)rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            if (this.handlers.remove((Object)key) == null) {
                throw new IllegalArgumentException("The handler " + key + " is not registered");
            }
        }
    }
}

