/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.FilePathChangesTreeList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitSimplePathsBrowser
extends JPanel {
    public GitSimplePathsBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        super(new BorderLayout());
        FilePathChangesTreeList browser = GitSimplePathsBrowser.createBrowser(project, absolutePaths);
        ActionToolbar toolbar = GitSimplePathsBrowser.createToolbar(browser);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)browser);
    }

    @NotNull
    private static FilePathChangesTreeList createBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        List<FilePath> filePaths = GitSimplePathsBrowser.toFilePaths(absolutePaths);
        FilePathChangesTreeList browser = new FilePathChangesTreeList(project, filePaths, false, false, null, null);
        browser.setChangesToDisplay(filePaths);
        return browser;
    }

    @NotNull
    private static ActionToolbar createToolbar(@NotNull FilePathChangesTreeList browser) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(browser.getTreeActions());
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
    }

    @NotNull
    private static List<FilePath> toFilePaths(@NotNull Collection<String> absolutePaths) {
        return ContainerUtil.map(absolutePaths, (Function)new Function<String, FilePath>(){

            public FilePath fun(String path) {
                return VcsUtil.getFilePath((String)path, (boolean)false);
            }
        });
    }
}

