/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import org.jetbrains.annotations.NotNull;

public class GitFreezingProcess {
    private static final Logger LOG = Logger.getInstance(GitFreezingProcess.class);
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final ChangeListManagerEx myChangeListManager;

    public GitFreezingProcess(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull String operationTitle, @NotNull Runnable runnable) {
        this.myFacade = facade;
        this.myOperationTitle = operationTitle;
        this.myRunnable = runnable;
        this.myChangeListManager = this.myFacade.getChangeListManager(project);
    }

    public void execute() {
        LOG.debug("starting");
        try {
            LOG.debug("saving documents, blocking project autosync");
            this.saveAndBlockInAwt();
            LOG.debug("freezing the ChangeListManager");
            this.freeze();
            try {
                LOG.debug("running the operation");
                this.myRunnable.run();
                LOG.debug("operation completed.");
            }
            finally {
                LOG.debug("unfreezing the ChangeListManager");
                this.unfreezeInAwt();
            }
        }
        finally {
            LOG.debug("unblocking project autosync");
            this.unblockInAwt();
        }
        LOG.debug("finished.");
    }

    public static void saveAndBlock(@NotNull GitPlatformFacade platformFacade) {
        platformFacade.getProjectManager().blockReloadingProjectOnExternalChanges();
        platformFacade.saveAllDocuments();
        platformFacade.getSaveAndSyncHandler().blockSaveOnFrameDeactivation();
        platformFacade.getSaveAndSyncHandler().blockSyncOnFrameActivation();
    }

    private void saveAndBlockInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.saveAndBlock(GitFreezingProcess.this.myFacade);
            }
        });
        UIUtil.invokeAndWaitIfNeeded((Runnable)rethrowingRunnable);
        rethrowingRunnable.rethrowIfHappened();
    }

    private void unblockInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.unblock(GitFreezingProcess.this.myFacade);
            }
        });
        UIUtil.invokeAndWaitIfNeeded((Runnable)rethrowingRunnable);
        rethrowingRunnable.rethrowIfHappened();
    }

    public static void unblock(@NotNull GitPlatformFacade platformFacade) {
        platformFacade.getProjectManager().unblockReloadingProjectOnExternalChanges();
        platformFacade.getSaveAndSyncHandler().unblockSaveOnFrameDeactivation();
        platformFacade.getSaveAndSyncHandler().unblockSyncOnFrameActivation();
    }

    private void freeze() {
        this.myChangeListManager.freezeImmediately("Local changes are not available until Git " + this.myOperationTitle + " is finished.");
    }

    private void unfreeze() {
        this.myChangeListManager.letGo();
    }

    private void unfreezeInAwt() {
        RethrowingRunnable rethrowingRunnable = new RethrowingRunnable(new Runnable(){

            @Override
            public void run() {
                GitFreezingProcess.this.unfreeze();
            }
        });
        UIUtil.invokeAndWaitIfNeeded((Runnable)rethrowingRunnable);
        rethrowingRunnable.rethrowIfHappened();
    }

    private static class RethrowingRunnable
    implements Runnable {
        private final Runnable myRunnable;
        private RuntimeException myException;

        RethrowingRunnable(@NotNull Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.myRunnable.run();
            }
            catch (Throwable t) {
                RuntimeException re;
                this.myException = re = new RuntimeException(t);
                throw re;
            }
        }

        void rethrowIfHappened() {
            if (this.myException != null) {
                throw this.myException;
            }
        }
    }
}

