/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.update.GitFetcher;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    private final boolean myCheckRebaseOverMergeProblem;
    private final UpdatedFiles myUpdatedFiles;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final GitMerger myMerger;
    private final Map<VirtualFile, GitBranchPair> myTrackedBranches = new HashMap<VirtualFile, GitBranchPair>();

    public GitUpdateProcess(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories, @NotNull UpdatedFiles updatedFiles, boolean checkRebaseOverMergeProblem) {
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
        this.myRepositories = repositories;
        this.myCheckRebaseOverMergeProblem = checkRebaseOverMergeProblem;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myUpdatedFiles = updatedFiles;
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitUpdateResult update(UpdateMethod updateMethod) {
        GitUpdateResult result;
        LOG.info("update started|" + (Object)((Object)updateMethod));
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Updating...");
        for (GitRepository repository : this.myRepositories) {
            repository.update();
        }
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles() || !this.checkTrackedBranchesConfigured()) {
            return GitUpdateResult.NOT_READY;
        }
        if (!this.fetchAndNotify()) {
            return GitUpdateResult.NOT_READY;
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            result = this.updateImpl(updateMethod);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        this.myProgressIndicator.setText(oldText);
        return result;
    }

    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod) {
        Collection<VirtualFile> problematicRoots;
        Map<VirtualFile, GitUpdater> updaters;
        try {
            updaters = this.defineUpdaters(updateMethod);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", e.getMessage(), true, (Exception)((Object)e));
            return GitUpdateResult.ERROR;
        }
        if (updaters.isEmpty()) {
            return GitUpdateResult.NOTHING_TO_UPDATE;
        }
        if ((updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters)).isEmpty()) {
            return GitUpdateResult.SUCCESS;
        }
        if (this.myCheckRebaseOverMergeProblem && !(problematicRoots = this.findRootsRebasingOverMerge(updaters)).isEmpty()) {
            Object decision = GitRebaseOverMergeProblem.showDialog();
            if (decision == GitRebaseOverMergeProblem.Decision.MERGE_INSTEAD) {
                for (VirtualFile root : problematicRoots) {
                    updaters.put(root, new GitMergeUpdater(this.myProject, this.myGit, root, this.myTrackedBranches, this.myProgressIndicator, this.myUpdatedFiles));
                }
            } else if (decision == GitRebaseOverMergeProblem.Decision.CANCEL_OPERATION) {
                return GitUpdateResult.CANCEL;
            }
        }
        ArrayList myRootsToSave = ContainerUtil.newArrayList();
        LOG.info("updateImpl: identifying if save is needed...");
        for (Map.Entry entry : updaters.entrySet()) {
            VirtualFile root;
            root = (VirtualFile)entry.getKey();
            GitUpdater updater = (GitUpdater)entry.getValue();
            if (!updater.isSaveNeeded()) continue;
            myRootsToSave.add(root);
            LOG.info("update| root " + root + " needs save");
        }
        LOG.info("updateImpl: saving local changes...");
        final Ref incomplete = Ref.create((Object)false);
        final Ref ref = Ref.create();
        final Map<VirtualFile, GitUpdater> finalUpdaters = updaters;
        new GitPreservingProcess(this.myProject, this.myPlatformFacade, this.myGit, myRootsToSave, "Update", "Remote", GitVcsSettings.getInstance(this.myProject).updateChangesPolicy(), this.myProgressIndicator, new Runnable(){

            @Override
            public void run() {
                LOG.info("updateImpl: updating...");
                VirtualFile currentlyUpdatedRoot = null;
                try {
                    for (Map.Entry entry : finalUpdaters.entrySet()) {
                        currentlyUpdatedRoot = (VirtualFile)entry.getKey();
                        GitUpdater updater = (GitUpdater)entry.getValue();
                        GitUpdateResult res = updater.update();
                        LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + (Object)((Object)res));
                        if (res == GitUpdateResult.INCOMPLETE) {
                            incomplete.set((Object)true);
                        }
                        ref.set((Object)GitUpdateProcess.joinResults((GitUpdateResult)((Object)ref.get()), res));
                    }
                }
                catch (VcsException e) {
                    String rootName = currentlyUpdatedRoot == null ? "" : currentlyUpdatedRoot.getName();
                    LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
                    GitUIUtil.notifyImportantError(GitUpdateProcess.this.myProject, "Error updating " + rootName, "Updating " + rootName + " failed with an error: " + e.getLocalizedMessage());
                }
            }
        }).execute(new Computable<Boolean>(){

            public Boolean compute() {
                return (Boolean)incomplete.get() == false && !ref.isNull() && ((GitUpdateResult)((Object)ref.get())).isSuccess();
            }
        });
        return (GitUpdateResult)((Object)ref.get());
    }

    @NotNull
    private Collection<VirtualFile> findRootsRebasingOverMerge(final @NotNull Map<VirtualFile, GitUpdater> updaters) {
        return ContainerUtil.mapNotNull(updaters.keySet(), (Function)new Function<VirtualFile, VirtualFile>(){

            public VirtualFile fun(VirtualFile root) {
                GitUpdater updater = (GitUpdater)updaters.get(root);
                if (updater instanceof GitRebaseUpdater) {
                    String currentRef = updater.getSourceAndTarget().getBranch().getFullName();
                    String baseRef = ((GitRemoteBranch)ObjectUtils.assertNotNull((Object)updater.getSourceAndTarget().getDest())).getFullName();
                    return GitRebaseOverMergeProblem.hasProblem(GitUpdateProcess.this.myProject, root, baseRef, currentRef) ? root : null;
                }
                return null;
            }
        });
    }

    @NotNull
    private Map<VirtualFile, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<VirtualFile, GitUpdater> updaters) {
        HashMap<VirtualFile, GitUpdater> modifiedUpdaters = new HashMap<VirtualFile, GitUpdater>();
        Map changesUnderRoots = new LocalChangesUnderRoots(ChangeListManager.getInstance((Project)this.myProject), ProjectLevelVcsManager.getInstance((Project)this.myProject)).getChangesUnderRoots(updaters.keySet());
        for (Map.Entry<VirtualFile, GitUpdater> updaterEntry : updaters.entrySet()) {
            GitRebaseUpdater rebaseUpdater;
            VirtualFile root = updaterEntry.getKey();
            GitUpdater updater = updaterEntry.getValue();
            Collection changes = (Collection)changesUnderRoots.get(root);
            if (updater instanceof GitRebaseUpdater && changes != null && !changes.isEmpty() && (rebaseUpdater = (GitRebaseUpdater)updater).fastForwardMerge()) continue;
            modifiedUpdaters.put(root, updater);
        }
        return modifiedUpdaters;
    }

    @NotNull
    private Map<VirtualFile, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod) throws VcsException {
        HashMap<VirtualFile, GitUpdater> updaters = new HashMap<VirtualFile, GitUpdater>();
        LOG.info("updateImpl: defining updaters...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitUpdater updater = GitUpdater.getUpdater(this.myProject, this.myGit, this.myTrackedBranches, root, this.myProgressIndicator, this.myUpdatedFiles, updateMethod);
            if (updater.isUpdateNeeded()) {
                updaters.put(root, updater);
            }
            LOG.info("update| root=" + root + " ,updater=" + updater);
        }
        return updaters;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result) {
        if (compoundResult == null) {
            return result;
        }
        return compoundResult.join(result);
    }

    private boolean fetchAndNotify() {
        return new GitFetcher(this.myProject, this.myProgressIndicator, false).fetchRootsAndNotify(this.myRepositories, "Update failed", false);
    }

    private boolean checkTrackedBranchesConfigured() {
        LOG.info("checking tracked branch configuration...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch == null) {
                LOG.info("checkTrackedBranchesConfigured: current branch is null in " + repository);
                GitUIUtil.notifyImportantError(this.myProject, "Can't update: no current branch", "You are in 'detached HEAD' state, which means that you're not on any branch" + this.rootStringIfNeeded(root) + "Checkout a branch to make update possible.");
                return false;
            }
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch);
            if (trackInfo == null) {
                String branchName = branch.getName();
                LOG.info(String.format("checkTrackedBranchesConfigured: no track info for current branch %s in %s", branch, repository));
                GitUIUtil.notifyImportantError(this.myProject, "Can't update: no tracked branch", "No tracked branch configured for branch " + GitUIUtil.code(branchName) + this.rootStringIfNeeded(root) + "To make your branch track a remote branch call, for example,<br/>" + "<code>git branch --set-upstream " + branchName + " origin/" + branchName + "</code>");
                return false;
            }
            this.myTrackedBranches.put(root, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
        }
        return true;
    }

    private String rootStringIfNeeded(@NotNull VirtualFile root) {
        if (this.myRepositories.size() < 2) {
            return ".<br/>";
        }
        return "<br/>in Git repository " + GitUIUtil.code(root.getPresentableUrl()) + "<br/>";
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished merge. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Update was not started");
        params.setMergeDescription("Unmerged files detected. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator);
        final Collection<VirtualFile> rebasingRoots = rebaser.getRebasingRoots();
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished rebase process. These conflicts must be resolved before update.");
        params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, this.myGit, (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class), rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return rebaser.continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return rebaser.continueRebase(rebasingRoots);
            }
        }.merge();
    }
}

