/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import org.jetbrains.annotations.NotNull;

public enum GitResetMode {
    SOFT("Soft", "--soft", "Files won't change, differences will be staged for commit."),
    MIXED("Mixed", "--mixed", "Files won't change, differences won't be staged."),
    HARD("Hard", "--hard", "Files will be reverted to the state of the selected commit.<br/>Warning: any local changes will be lost."),
    KEEP("Keep", "--keep", "Files will be reverted to the state of the selected commit,<br/>but local changes will be kept intact.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myArgument;
    @NotNull
    private final String myDescription;

    private GitResetMode(@NotNull String name, String argument, String description) {
        this.myName = name;
        this.myArgument = argument;
        this.myDescription = description;
    }

    @NotNull
    public static GitResetMode getDefault() {
        return MIXED;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getArgument() {
        return this.myArgument;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }
}

