/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRemote
implements Comparable<GitRemote> {
    public static final GitRemote DOT = new GitRemote(".", Collections.singletonList("."), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    public static final String ORIGIN_NAME = "origin";
    @NotNull
    private final String myName;
    @NotNull
    private final List<String> myUrls;
    @NotNull
    private final Collection<String> myPushUrls;
    @NotNull
    final List<String> myFetchRefSpecs;
    @NotNull
    private final List<String> myPushRefSpecs;

    public GitRemote(@NotNull String name, @NotNull List<String> urls, @NotNull Collection<String> pushUrls, @NotNull List<String> fetchRefSpecs, @NotNull List<String> pushRefSpecs) {
        this.myName = name;
        this.myUrls = urls;
        this.myPushUrls = pushUrls;
        this.myFetchRefSpecs = fetchRefSpecs;
        this.myPushRefSpecs = pushRefSpecs;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<String> getUrls() {
        return this.myUrls;
    }

    @Nullable
    public String getFirstUrl() {
        return this.myUrls.isEmpty() ? null : this.myUrls.get(0);
    }

    @NotNull
    public Collection<String> getPushUrls() {
        return this.myPushUrls;
    }

    @NotNull
    public List<String> getFetchRefSpecs() {
        return this.myFetchRefSpecs;
    }

    @NotNull
    public List<String> getPushRefSpecs() {
        return this.myPushRefSpecs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRemote gitRemote = (GitRemote)o;
        return this.myName.equals(gitRemote.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return String.format("GitRemote{myName='%s', myUrls=%s, myPushUrls=%s, myFetchRefSpec='%s', myPushRefSpec='%s'}", this.myName, this.myUrls, this.myPushUrls, this.myFetchRefSpecs, this.myPushRefSpecs);
    }

    @Override
    public int compareTo(@NotNull GitRemote o) {
        return this.getName().compareTo(o.getName());
    }
}

