/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.DialogManager;
import git4idea.commands.GitHandler;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEditor;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseUnstructuredEditor;
import java.io.Closeable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitInteractiveRebaseEditorHandler
implements Closeable,
GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance((String)GitInteractiveRebaseEditorHandler.class.getName());
    private final GitRebaseEditorService myService;
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitHandler myHandler;
    private final int myHandlerNo;
    private boolean myIsClosed;
    protected boolean myRebaseEditorShown = false;
    private boolean myNoopSituation;
    private boolean myEditorCancelled;

    public GitInteractiveRebaseEditorHandler(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root, @NotNull GitHandler handler) {
        this.myService = service;
        this.myProject = project;
        this.myRoot = root;
        this.myHandler = handler;
        this.myHandlerNo = service.registerHandler(this);
    }

    @Override
    public GitHandler getHandler() {
        return this.myHandler;
    }

    @Override
    public int editCommits(final String path) {
        this.ensureOpen();
        final Ref isSuccess = new Ref();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    GitInteractiveRebaseEditorHandler.this.myEditorCancelled = false;
                    GitInteractiveRebaseEditorHandler.this.myNoopSituation = false;
                    if (GitInteractiveRebaseEditorHandler.this.myRebaseEditorShown) {
                        GitRebaseUnstructuredEditor editor = new GitRebaseUnstructuredEditor(GitInteractiveRebaseEditorHandler.this.myProject, GitInteractiveRebaseEditorHandler.this.myRoot, path);
                        DialogManager.show(editor);
                        if (editor.isOK()) {
                            editor.save();
                        } else {
                            GitInteractiveRebaseEditorHandler.this.myEditorCancelled = true;
                        }
                        isSuccess.set((Object)true);
                        return;
                    }
                    GitInteractiveRebaseEditorHandler.this.setRebaseEditorShown();
                    GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(GitInteractiveRebaseEditorHandler.this.myProject, GitInteractiveRebaseEditorHandler.this.myRoot, path);
                    try {
                        List<GitRebaseEntry> entries = rebaseFile.load();
                        GitRebaseEditor editor = new GitRebaseEditor(GitInteractiveRebaseEditorHandler.this.myProject, GitInteractiveRebaseEditorHandler.this.myRoot, entries);
                        DialogManager.show(editor);
                        if (editor.isOK()) {
                            rebaseFile.save(editor.getEntries());
                            isSuccess.set((Object)true);
                            return;
                        }
                        rebaseFile.cancel();
                        GitInteractiveRebaseEditorHandler.this.myEditorCancelled = true;
                    }
                    catch (GitInteractiveRebaseFile.NoopException e) {
                        LOG.info("Noop situation while rebasing " + GitInteractiveRebaseEditorHandler.this.myRoot);
                        String message = "There are no commits to rebase because the current branch is directly below the base branch, or they point to the same commit (the 'noop' situation).\nDo you want to continue (this will reset the current branch to the base branch)?";
                        int rebase = DialogManager.showOkCancelDialog(GitInteractiveRebaseEditorHandler.this.myProject, message, "Git Rebase", CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
                        if (rebase == 0) {
                            isSuccess.set((Object)true);
                            GitInteractiveRebaseEditorHandler.this.myNoopSituation = true;
                            return;
                        }
                        GitInteractiveRebaseEditorHandler.this.myEditorCancelled = true;
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to edit the git rebase file: " + path, (Throwable)e);
                }
                isSuccess.set((Object)false);
            }
        });
        return isSuccess.isNull() || (Boolean)isSuccess.get() == false ? 2 : 0;
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    private void ensureOpen() {
        if (this.myIsClosed) {
            throw new IllegalStateException("The handler was already closed");
        }
    }

    @Override
    public void close() {
        this.ensureOpen();
        this.myIsClosed = true;
        this.myService.unregisterHandler(this.myHandlerNo);
    }

    public int getHandlerNo() {
        return this.myHandlerNo;
    }

    public boolean wasNoopSituationDetected() {
        return this.myNoopSituation;
    }

    public boolean wasEditorCancelled() {
        return this.myEditorCancelled;
    }
}

