/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushResultNotification;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPusher
extends Pusher<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    GitPusher(@NotNull Project project, @NotNull GitVcsSettings settings, @NotNull GitPushSupport pushSupport) {
        this.myProject = project;
        this.mySettings = settings;
        this.myPushSupport = pushSupport;
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void push(@NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable VcsPushOptionValue optionValue, boolean force) {
        GitPushTagMode pushTagMode = (GitPushTagMode)optionValue;
        GitPushResult result = new GitPushOperation(this.myProject, this.myPushSupport, pushSpecs, pushTagMode, force).execute();
        GitPushResultNotification notification = GitPushResultNotification.create(this.myProject, result, this.myRepositoryManager.moreThanOneRoot());
        notification.notify(this.myProject);
        this.mySettings.setPushTagMode(pushTagMode);
        this.rememberTargets(pushSpecs);
    }

    private void rememberTargets(@NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs) {
        for (Map.Entry<GitRepository, PushSpec<GitPushSource, GitPushTarget>> entry : pushSpecs.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushSource source = (GitPushSource)entry.getValue().getSource();
            GitPushTarget target = (GitPushTarget)entry.getValue().getTarget();
            GitPushTarget defaultTarget = this.myPushSupport.getDefaultTarget(repository);
            if (defaultTarget != null && target.getBranch().equals(defaultTarget.getBranch())) continue;
            this.mySettings.setPushTarget(repository, source.getBranch().getName(), target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
        }
    }
}

