/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushSpecParser;
import git4idea.push.GitSpecialRefRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTarget
implements PushTarget {
    private static final Logger LOG = Logger.getInstance(GitPushTarget.class);
    @NotNull
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myIsNewBranchCreated;
    private final boolean myPushingToSpecialRef;

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated) {
        this(remoteBranch, isNewBranchCreated, false);
    }

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated, boolean isPushingToSpecialRef) {
        this.myRemoteBranch = remoteBranch;
        this.myIsNewBranchCreated = isNewBranchCreated;
        this.myPushingToSpecialRef = isPushingToSpecialRef;
    }

    @NotNull
    public GitRemoteBranch getBranch() {
        return this.myRemoteBranch;
    }

    public boolean hasSomethingToPush() {
        return this.isNewBranchCreated();
    }

    @NotNull
    public String getPresentation() {
        return this.myPushingToSpecialRef ? this.myRemoteBranch.getFullName() : this.myRemoteBranch.getNameForRemoteOperations();
    }

    public boolean isNewBranchCreated() {
        return this.myIsNewBranchCreated;
    }

    boolean isSpecialRef() {
        return this.myPushingToSpecialRef;
    }

    @NotNull
    public static GitPushTarget parse(@NotNull GitRepository repository, @Nullable String remoteName, @NotNull String branchName) throws ParseException {
        if (remoteName == null) {
            throw new ParseException("No remotes defined", -1);
        }
        if (!GitRefNameValidator.getInstance().checkInput(branchName)) {
            throw new ParseException("Invalid destination branch name: " + branchName, -1);
        }
        GitRemote remote = GitPushTarget.findRemote(repository.getRemotes(), remoteName);
        if (remote == null) {
            LOG.error("Remote [" + remoteName + "] is not found among " + repository.getRemotes());
            throw new ParseException("Invalid remote: " + remoteName, -1);
        }
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        GitStandardRemoteBranch rb = new GitStandardRemoteBranch(remote, branchName);
        return new GitPushTarget(rb, true);
    }

    @Nullable
    private static GitRemote findRemote(@NotNull Collection<GitRemote> remotes, final @NotNull String candidate) {
        return (GitRemote)ContainerUtil.find(remotes, (Condition)new Condition<GitRemote>(){

            public boolean value(GitRemote remote) {
                return remote.getName().equals(candidate);
            }
        });
    }

    @Nullable
    public static GitPushTarget getFromPushSpec(@NotNull GitRepository repository, @NotNull GitLocalBranch sourceBranch) {
        GitRemote remote = GitPushTarget.getRemoteToPush(repository, GitBranchUtil.getTrackInfoForBranch(repository, sourceBranch));
        if (remote == null) {
            return null;
        }
        List<String> specs = remote.getPushRefSpecs();
        if (specs.isEmpty()) {
            return null;
        }
        String targetRef = GitPushSpecParser.getTargetRef(repository, sourceBranch.getName(), specs);
        if (targetRef == null) {
            return null;
        }
        String remotePrefix = "refs/remotes/" + remote.getName() + "/";
        if (targetRef.startsWith(remotePrefix)) {
            targetRef = targetRef.substring(remotePrefix.length());
            GitRemoteBranch remoteBranch = GitUtil.findOrCreateRemoteBranch(repository, remote, targetRef);
            boolean existingBranch = repository.getBranches().getRemoteBranches().contains(remoteBranch);
            return new GitPushTarget(remoteBranch, !existingBranch, false);
        }
        GitSpecialRefRemoteBranch remoteBranch = new GitSpecialRefRemoteBranch(targetRef, remote);
        return new GitPushTarget(remoteBranch, true, true);
    }

    @Nullable
    private static GitRemote getRemoteToPush(@NotNull GitRepository repository, @Nullable GitBranchTrackInfo trackInfo) {
        if (trackInfo != null) {
            return trackInfo.getRemote();
        }
        return GitUtil.findOrigin(repository.getRemotes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitPushTarget)) {
            return false;
        }
        GitPushTarget target = (GitPushTarget)o;
        if (this.myIsNewBranchCreated != target.myIsNewBranchCreated) {
            return false;
        }
        return this.myRemoteBranch.equals(target.myRemoteBranch);
    }

    public int hashCode() {
        int result = this.myRemoteBranch.hashCode();
        result = 31 * result + (this.myIsNewBranchCreated ? 1 : 0);
        return result;
    }
}

