/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import git4idea.GitLocalBranch;
import org.jetbrains.annotations.NotNull;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        return new OnBranch(branch);
    }

    @NotNull
    public static GitPushSource create(@NotNull String revision) {
        return new DetachedHead(revision);
    }

    @NotNull
    abstract GitLocalBranch getBranch();

    private static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        public DetachedHead(@NotNull String revision) {
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            return DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        @NotNull
        GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }
    }

    private static class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;

        private OnBranch(@NotNull GitLocalBranch branch) {
            this.myBranch = branch;
        }

        @NotNull
        public String getPresentation() {
            return this.myBranch.getName();
        }

        @Override
        @NotNull
        GitLocalBranch getBranch() {
            return this.myBranch;
        }
    }
}

