/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.UserNameRegex;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitBekParentFixer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = new Function<VcsRef, String>(){

        public String fun(VcsRef ref) {
            return ref.getType() == GitRefManager.TAG ? ref.getName() : null;
        }
    };
    public static final TObjectHashingStrategy<VcsRef> DONT_CONSIDER_SHA = new TObjectHashingStrategy<VcsRef>(){

        public int computeHashCode(@NotNull VcsRef ref) {
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            return ref1.getName().equals(ref2.getName()) && ref1.getType().equals(ref2.getType());
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitUserRegistry myUserRegistry;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory, @NotNull GitUserRegistry userRegistry) {
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myUserRegistry = userRegistry;
        this.myRefSorter = new GitRefManager((RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = factory;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection<Object> allDetails;
        if (!this.isRepositoryReady(root)) {
            return LogDataImpl.empty();
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = requirements instanceof VcsLogProviderRequirementsEx && ((VcsLogProviderRequirementsEx)requirements).isRefresh();
        VcsLogProvider.DetailedLogData data = GitHistoryUtils.loadMetadata(this.myProject, root, true, params);
        Set safeRefs = data.getRefs();
        OpenTHashSet allRefs = new OpenTHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches = this.readBranches(repository);
        GitLogProvider.addNewElements(allRefs, branches);
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh) {
            allDetails = data.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = GitLogProvider.newHashSet(data.getCommits());
            Set previousTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            Set safeTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        StopWatch sw = StopWatch.start((String)("sorting commits in " + root.getName()));
        List<VcsCommitMetadata> sortedCommits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
        sortedCommits = sortedCommits.subList(0, Math.min(sortedCommits.size(), requirements.getCommitCount()));
        sw.report();
        if (LOG.isDebugEnabled()) {
            GitLogProvider.validateDataAndReportError(root, (Set<VcsRef>)allRefs, sortedCommits, data, branches, currentTagNames, commitsFromTags);
        }
        return new LogDataImpl((Set)allRefs, sortedCommits);
    }

    private static void validateDataAndReportError(final @NotNull VirtualFile root, final @NotNull Set<VcsRef> allRefs, final @NotNull List<VcsCommitMetadata> sortedCommits, final @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, final @NotNull Set<VcsRef> manuallyReadBranches, final @Nullable Set<String> currentTagNames, final @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StopWatch sw = StopWatch.start((String)("validating data in " + root.getName()));
        final Set refs = ContainerUtil.map2Set(allRefs, (Function)new Function<VcsRef, Hash>(){

            public Hash fun(VcsRef ref) {
                return ref.getCommitHash();
            }
        });
        PermanentGraphImpl.newInstance(sortedCommits, (GraphColorManager)new GraphColorManager<Hash>(){

            public int getColorOfBranch(@NotNull Hash headCommit) {
                return 0;
            }

            public int getColorOfFragment(@NotNull Hash headCommit, int magicIndex) {
                return 0;
            }

            public int compareHeads(@NotNull Hash head1, @NotNull Hash head2) {
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags))});
                }
                return 0;
            }
        }, (Set)refs);
        sw.report();
    }

    private static String printErrorDetails(@NotNull VirtualFile root, @NotNull Set<VcsRef> allRefs, @NotNull List<VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    @NotNull
    private static String printLogData(@NotNull VcsLogProvider.DetailedLogData firstBlockSyncData) {
        return String.format("Last 100 commits:\n%s\nRefs:\n%s", GitLogProvider.printCommits(firstBlockSyncData.getCommits()), GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
    }

    @NotNull
    private static String printCommits(@NotNull List<VcsCommitMetadata> commits) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits.size(), 100); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit.getId()).toShortString(), StringUtil.join((Collection)commit.getParents(), (Function)new Function<Hash, String>(){

                public String fun(Hash hash) {
                    return hash.toShortString();
                }
            }, (String)", ")));
        }
        return sb.toString();
    }

    @NotNull
    private static String printRefs(@NotNull Set<VcsRef> refs) {
        return StringUtil.join(refs, (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getCommitHash().toShortString() + " : " + ref.getName();
            }
        }, (String)"\n");
    }

    private static void addOldStillExistingTags(@NotNull Set<VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Set<VcsRef> previousRefs) {
        for (VcsRef ref : previousRefs) {
            if (allRefs.contains(ref) || !currentTags.contains(ref.getName())) continue;
            allRefs.add(ref);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        StopWatch sw = StopWatch.start((String)("reading tags in " + root.getName()));
        Set<String> tags = GitLogProvider.newHashSet();
        GitTag.listAsStrings(this.myProject, root, tags, null);
        sw.report();
        return tags;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<T> original, Set<T> ... toRemove) {
        Set<T> result = GitLogProvider.newHashSet(original);
        for (Set<T> set : toRemove) {
            result.removeAll(set);
        }
        return result;
    }

    private static <T> void addNewElements(@NotNull Collection<T> original, @NotNull Collection<T> toAdd) {
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        StopWatch sw = StopWatch.start((String)("loading commits on tagged branch in " + root.getName()));
        ArrayList<String> params = new ArrayList<String>();
        params.add("--max-count=" + commitCount);
        params.addAll(unmatchedTags);
        sw.report();
        return GitHistoryUtils.loadMetadata(this.myProject, root, true, ArrayUtil.toStringArray(params));
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, final @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (!this.isRepositoryReady(root)) {
            return LogDataImpl.empty();
        }
        ArrayList<String> parameters = new ArrayList<String>(GitHistoryUtils.LOG_ALL);
        parameters.add("--date-order");
        final GitBekParentFixer parentFixer = GitBekParentFixer.prepare(root, this);
        Set userRegistry = GitLogProvider.newHashSet();
        Set refs = GitLogProvider.newHashSet();
        GitHistoryUtils.readCommits(this.myProject, root, parameters, (Consumer<VcsUser>)new CollectConsumer(userRegistry), (Consumer<VcsRef>)new CollectConsumer(refs), new Consumer<TimedVcsCommit>(){

            public void consume(TimedVcsCommit commit) {
                commitConsumer.consume((Object)parentFixer.fixCommit(commit));
            }
        });
        return new LogDataImpl(refs, userRegistry);
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        return VcsFileUtil.foreachChunk(hashes, (ThrowableNotNullFunction)new ThrowableNotNullFunction<List<String>, List<? extends VcsShortCommitDetails>, VcsException>(){

            @NotNull
            public List<? extends VcsShortCommitDetails> fun(@NotNull List<String> hashes) throws VcsException {
                return GitHistoryUtils.readMiniDetails(GitLogProvider.this.myProject, root, hashes);
            }
        });
    }

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        return VcsFileUtil.foreachChunk(hashes, (ThrowableNotNullFunction)new ThrowableNotNullFunction<List<String>, List<? extends VcsFullCommitDetails>, VcsException>(){

            @NotNull
            public List<? extends VcsFullCommitDetails> fun(@NotNull List<String> hashes) throws VcsException {
                String noWalk = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(GitLogProvider.this.myVcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
                ArrayList<String> params = new ArrayList<String>();
                params.add(noWalk);
                params.addAll(hashes);
                return GitHistoryUtils.history(GitLogProvider.this.myProject, root, ArrayUtil.toStringArray(params));
            }
        });
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository) {
        Hash hash;
        StopWatch sw = StopWatch.start((String)("readBranches in " + repository.getRoot().getName()));
        VirtualFile root = repository.getRoot();
        repository.update();
        GitBranchesCollection branches = repository.getBranches();
        Collection<GitLocalBranch> localBranches = branches.getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = branches.getRemoteBranches();
        THashSet refs = new THashSet(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            hash = branches.getHash(localBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            hash = branches.getHash(remoteBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        sw.report();
        return refs;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        return this.myRefSorter;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(final @NotNull Collection<VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                VirtualFile root = repository.getRoot();
                if (roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
        return connection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Collection files;
        if (!this.isRepositoryReady(root)) {
            return Collections.emptyList();
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        VcsLogBranchFilter branchFilter = filterCollection.getBranchFilter();
        if (branchFilter != null) {
            GitRepository repository = this.getRepository(root);
            assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
            ArrayList branches = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{repository.getBranches().getLocalBranches(), repository.getBranches().getRemoteBranches()}));
            Collection<String> branchNames = GitBranchUtil.convertBranchesToNames(branches);
            List predefinedNames = ContainerUtil.list((Object[])new String[]{"HEAD"});
            boolean atLeastOneBranchExists = false;
            for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, predefinedNames})) {
                if (!branchFilter.matches(branchName)) continue;
                filterParameters.add(branchName);
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                return Collections.emptyList();
            }
        } else {
            filterParameters.addAll(GitHistoryUtils.LOG_ALL);
        }
        if (filterCollection.getUserFilter() != null) {
            String authorFilter = StringUtil.join((Collection)ContainerUtil.map((Collection)filterCollection.getUserFilter().getUserNames(root), (Function)UserNameRegex.INSTANCE), (String)"|");
            filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.escapeBackSlashes((String)authorFilter)));
            filterParameters.add("--extended-regexp");
        }
        if (filterCollection.getDateFilter() != null) {
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", filter.getAfter().toString()));
            }
            if (filter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", filter.getBefore().toString()));
            }
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            filterParameters.add(GitLogProvider.prepareParameter("grep", StringUtil.escapeChars((String)textFilter, (char[])new char[]{'[', ']'})));
        }
        filterParameters.add("--regexp-ignore-case");
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        if (filterCollection.getStructureFilter() != null && !(files = filterCollection.getStructureFilter().getFiles()).isEmpty()) {
            filterParameters.add("--full-history");
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (FilePath file : files) {
                filterParameters.add(file.getPath());
            }
        }
        ArrayList commits = ContainerUtil.newArrayList();
        GitHistoryUtils.readCommits(this.myProject, root, filterParameters, (Consumer<VcsUser>)EmptyConsumer.getInstance(), (Consumer<VcsRef>)EmptyConsumer.getInstance(), (Consumer<TimedVcsCommit>)new CollectConsumer((Collection)commits));
        return commits;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        return this.myUserRegistry.getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        return GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            return null;
        }
        String currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null && repository.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }

    @NotNull
    private static <T> Set<T> newHashSet() {
        return new THashSet();
    }

    @NotNull
    private static <T> Set<T> newHashSet(@NotNull Collection<T> initialCollection) {
        return new THashSet(initialCollection);
    }
}

