/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.util.BekUtil;
import git4idea.log.GitLogProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBekParentFixer {
    @NotNull
    private static final String MAGIC_TEXT = "Merge remote";
    @NotNull
    private static final VcsLogFilterCollection MAGIC_FILTER = GitBekParentFixer.createVcsLogFilterCollection();
    @NotNull
    private final Set<Hash> myWrongCommits;

    private GitBekParentFixer(@NotNull Set<Hash> wrongCommits) {
        this.myWrongCommits = wrongCommits;
    }

    @NotNull
    static GitBekParentFixer prepare(@NotNull VirtualFile root, @NotNull GitLogProvider provider) throws VcsException {
        if (!BekUtil.isBekEnabled()) {
            return new GitBekParentFixer(Collections.emptySet());
        }
        return new GitBekParentFixer(GitBekParentFixer.getWrongCommits(provider, root));
    }

    @NotNull
    TimedVcsCommit fixCommit(@NotNull TimedVcsCommit commit) {
        if (!this.myWrongCommits.contains(commit.getId())) {
            return commit;
        }
        return GitBekParentFixer.reverseParents(commit);
    }

    @NotNull
    private static Set<Hash> getWrongCommits(@NotNull GitLogProvider provider, @NotNull VirtualFile root) throws VcsException {
        List<TimedVcsCommit> commitsMatchingFilter = provider.getCommitsMatchingFilter(root, MAGIC_FILTER, -1);
        return ContainerUtil.map2Set(commitsMatchingFilter, (Function)new Function<TimedVcsCommit, Hash>(){

            public Hash fun(TimedVcsCommit timedVcsCommit) {
                return (Hash)timedVcsCommit.getId();
            }
        });
    }

    @NotNull
    private static TimedVcsCommit reverseParents(final @NotNull TimedVcsCommit commit) {
        return new TimedVcsCommit(){

            public long getTimestamp() {
                return commit.getTimestamp();
            }

            @NotNull
            public Hash getId() {
                return (Hash)commit.getId();
            }

            @NotNull
            public List<Hash> getParents() {
                return ContainerUtil.reverse((List)commit.getParents());
            }
        };
    }

    private static VcsLogFilterCollection createVcsLogFilterCollection() {
        final VcsLogTextFilter textFilter = new VcsLogTextFilter(){

            @NotNull
            public String getText() {
                return GitBekParentFixer.MAGIC_TEXT;
            }

            public boolean matches(@NotNull VcsCommitMetadata details) {
                return details.getFullMessage().contains(GitBekParentFixer.MAGIC_TEXT);
            }
        };
        return new VcsLogFilterCollection(){

            @Nullable
            public VcsLogBranchFilter getBranchFilter() {
                return null;
            }

            @Nullable
            public VcsLogUserFilter getUserFilter() {
                return null;
            }

            @Nullable
            public VcsLogDateFilter getDateFilter() {
                return null;
            }

            @Nullable
            public VcsLogTextFilter getTextFilter() {
                return textFilter;
            }

            @Nullable
            public VcsLogHashFilter getHashFilter() {
                return null;
            }

            @Nullable
            public VcsLogStructureFilter getStructureFilter() {
                return null;
            }

            @Nullable
            public VcsLogRootFilter getRootFilter() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }

            @NotNull
            public List<VcsLogDetailsFilter> getDetailsFilters() {
                return Collections.singletonList(textFilter);
            }
        };
    }
}

