/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import git4idea.history.browser.SHAHash;
import git4idea.history.wholeTree.AbstractHash;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class GitHeavyCommit {
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final AbstractHash myShortHash;
    @NotNull
    private final SHAHash myHash;
    private final String myAuthor;
    private final String myCommitter;
    private final String mySubject;
    private final String myDescription;
    private final Date myDate;
    private final String myAuthorEmail;
    private final String myComitterEmail;
    private final List<String> myTags;
    private final List<String> myLocalBranches;
    private final List<String> myRemoteBranches;
    private final Set<String> myParentsHashes;
    private final Set<GitHeavyCommit> myParentsLinks;
    private final List<FilePath> myPathsList;
    private final List<Change> myChanges;
    private String myCurrentBranch;
    private final long myAuthorTime;
    private boolean myOnLocal;
    private boolean myOnTracked;

    public GitHeavyCommit(@NotNull VirtualFile root, @NotNull AbstractHash shortHash, @NotNull SHAHash hash, String author, String committer, Date date, String subject, String description, Set<String> parentsHashes, List<FilePath> pathsList, String authorEmail, String comitterEmail, List<String> tags, List<String> localBranches, List<String> remoteBranches, List<Change> changes, long authorTime) {
        this.myRoot = root;
        this.myShortHash = shortHash;
        this.myAuthor = author;
        this.myCommitter = committer;
        this.myDate = date;
        this.mySubject = subject;
        this.myDescription = description;
        this.myHash = hash;
        this.myParentsHashes = parentsHashes;
        this.myPathsList = pathsList;
        this.myAuthorEmail = authorEmail;
        this.myComitterEmail = comitterEmail;
        this.myTags = tags;
        this.myChanges = changes;
        this.myLocalBranches = localBranches;
        this.myRemoteBranches = remoteBranches;
        this.myAuthorTime = authorTime;
        this.myParentsLinks = new HashSet<GitHeavyCommit>();
    }

    public void addParentLink(GitHeavyCommit commit) {
        this.myParentsLinks.add(commit);
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitter() {
        return this.myCommitter;
    }

    public Date getDate() {
        return this.myDate;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public SHAHash getHash() {
        return this.myHash;
    }

    public Set<String> getParentsHashes() {
        return this.myParentsHashes;
    }

    public Set<GitHeavyCommit> getParentsLinks() {
        return this.myParentsLinks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHeavyCommit gitCommit = (GitHeavyCommit)o;
        return this.myHash.equals(gitCommit.myHash);
    }

    public int hashCode() {
        return this.myHash.hashCode();
    }

    public List<String> getTags() {
        return this.myTags;
    }

    public void orderTags(Comparator<String> comparator) {
        Collections.sort(this.myTags, comparator);
    }

    public List<String> getLocalBranches() {
        return this.myLocalBranches;
    }

    public List<String> getRemoteBranches() {
        return this.myRemoteBranches;
    }

    public String getAuthorEmail() {
        return this.myAuthorEmail;
    }

    public String getCommitterEmail() {
        return this.myComitterEmail;
    }

    public List<FilePath> getPathsList() {
        return this.myPathsList;
    }

    public String toString() {
        return this.myHash.getValue();
    }

    @NotNull
    public AbstractHash getShortHash() {
        return this.myShortHash;
    }

    public List<Change> getChanges() {
        return this.myChanges;
    }

    public void setCurrentBranch(String s) {
        this.myCurrentBranch = s;
    }

    public String getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public long getAuthorTime() {
        return this.myAuthorTime;
    }

    public String getComitterEmail() {
        return this.myComitterEmail;
    }

    public boolean isOnLocal() {
        return this.myOnLocal;
    }

    public void setOnLocal(boolean onLocal) {
        this.myOnLocal = onLocal;
    }

    public boolean isOnTracked() {
        return this.myOnTracked;
    }

    public void setOnTracked(boolean onTracked) {
        this.myOnTracked = onTracked;
    }

    public List<AbstractHash> getConvertedParents() {
        return ObjectsConvertor.convert(this.getParentsHashes(), (Convertor)new Convertor<String, AbstractHash>(){

            public AbstractHash convert(String o) {
                return AbstractHash.create(o);
            }
        });
    }

    public String getSubject() {
        return this.mySubject;
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }
}

