/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
implements Git {
    private static final Logger LOG = Logger.getInstance(Git.class);
    public static final String[] ERROR_INDICATORS = new String[]{"error:", "remote: error", "fatal:", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable"};

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<VirtualFile> files) throws VcsException {
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        return untrackedFiles;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        String output;
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        if (StringUtil.isEmptyOrSpaces((String)(output = h.run()))) {
            return untrackedFiles;
        }
        for (String relPath : output.split("\u0000")) {
            VirtualFile f = root.findFileByRelativePath(relPath);
            if (f == null) {
                LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            untrackedFiles.add(f);
        }
        return untrackedFiles;
    }

    @Override
    @NotNull
    public GitCommandResult clone(final @NotNull Project project, final @NotNull File parentDirectory, final @NotNull String url, final @NotNull String clonedDirectoryName, final GitLineHandlerListener ... listeners) {
        return GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
                handler.setStdoutSuppressed(false);
                handler.setUrl(url);
                handler.addParameters("--progress");
                handler.addParameters(url);
                handler.endOptions();
                handler.addParameters(clonedDirectoryName);
                GitImpl.addListeners(handler, listeners);
                return handler;
            }
        });
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        return GitImpl.run(diff);
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(final @NotNull GitRepository repository, final @NotNull Collection<String> attributes, @NotNull Collection<VirtualFile> files) {
        List listOfPaths = VcsFileUtil.chunkFiles((VirtualFile)repository.getRoot(), files);
        return GitImpl.runAll(ContainerUtil.map((Collection)listOfPaths, (Function)new Function<List<String>, Computable<GitCommandResult>>(){

            public Computable<GitCommandResult> fun(final List<String> relativePaths) {
                return new Computable<GitCommandResult>(){

                    public GitCommandResult compute() {
                        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
                        h.addParameters(new ArrayList<String>(attributes));
                        h.endOptions();
                        h.addParameters(relativePaths);
                        return GitImpl.run(h);
                    }
                };
            }
        }));
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        return GitImpl.run(handler);
    }

    @Override
    @NotNull
    public List<GitCommit> history(@NotNull GitRepository repository, @NotNull String range) {
        try {
            return GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git log " + range + "] on repository [" + repository.getRoot() + "]", e);
        }
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        return GitImpl.run(mergeHandler);
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(detach ? reference + "^0" : reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        h.endOptions();
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT.readLockingCommand());
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository repository, @NotNull String commit) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters("-m", currentName, newName);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        return GitImpl.reset(repository, mode.getArgument(), target, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        return GitImpl.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
    }

    @NotNull
    private static GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        return GitImpl.run(handler);
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        return this.doPush(repository, remote, Collections.singleton(url), spec, false, updateTracking, null, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String spec, boolean force, boolean updateTracking, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        return this.doPush(repository, remote.getName(), remote.getPushUrls(), spec, force, updateTracking, tagMode, listeners);
    }

    @NotNull
    private GitCommandResult doPush(final @NotNull GitRepository repository, final @NotNull String remoteName, final @NotNull Collection<String> remoteUrls, final @NotNull String spec, final boolean force, final boolean updateTracking, final @Nullable String tagMode, final GitLineHandlerListener ... listeners) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
                h.setUrls(remoteUrls);
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                GitImpl.addListeners(h, listeners);
                h.addProgressParameter();
                h.addParameters("--porcelain");
                h.addParameters(remoteName);
                h.addParameters(spec);
                if (updateTracking) {
                    h.addParameters("--set-upstream");
                }
                if (force) {
                    h.addParameters("--force");
                }
                if (tagMode != null) {
                    h.addParameters(tagMode);
                }
                return h;
            }
        });
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        return GitImpl.run(handler);
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        handler.addParameters("-x");
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        return GitImpl.run(handler);
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult fetch(final @NotNull GitRepository repository, final @NotNull GitRemote remote, final @NotNull List<GitLineHandlerListener> listeners, final String ... params) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                h.setUrls(remote.getUrls());
                h.addParameters(remote.getName());
                h.addParameters(params);
                h.addProgressParameter();
                GitVcs vcs = GitVcs.getInstance(repository.getProject());
                if (vcs != null && GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(vcs.getVersion())) {
                    h.addParameters("--prune");
                }
                GitImpl.addListeners(h, listeners);
                return h;
            }
        });
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        return GitImpl.run(h);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        return GitImpl.doLsRemote(project, workingDir, url, Collections.singleton(url), new String[0]);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        return GitImpl.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), additionalParameters);
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(final @NotNull GitRepository repository, final @NotNull GitRemote remote) {
        return GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE.writeLockingCommand());
                h.setStdoutSuppressed(false);
                h.addParameters("prune");
                h.addParameters(remote.getName());
                h.setUrls(remote.getUrls());
                return h;
            }
        });
    }

    @Override
    @NotNull
    public GitCommandResult rebase(@NotNull GitRepository repository, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        return parameters.isInteractive() ? this.runWithEditor(project, root, handler, true) : GitImpl.run(handler);
    }

    @Override
    @NotNull
    public GitCommandResult rebaseAbort(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        return GitImpl.run(handler);
    }

    @Override
    @NotNull
    public GitCommandResult rebaseContinue(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        return this.rebaseResume(repository, GitRebaseResumeMode.CONTINUE, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult rebaseSkip(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        return this.rebaseResume(repository, GitRebaseResumeMode.SKIP, listeners);
    }

    @NotNull
    private GitCommandResult rebaseResume(@NotNull GitRepository repository, @NotNull GitRebaseResumeMode rebaseMode, @NotNull GitLineHandlerListener[] listeners) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        return this.runWithEditor(project, root, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GitCommandResult runWithEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        try (GitInteractiveRebaseEditorHandler editor = this.configureEditor(project, root, handler, commitListAware);){
            GitCommandResult result = GitImpl.run(handler);
            GitCommandResult gitCommandResult = editor.wasEditorCancelled() ? GitImpl.toCancelledResult(result) : result;
            return gitCommandResult;
        }
    }

    @NotNull
    private static GitCommandResult toCancelledResult(@NotNull GitCommandResult result) {
        int exitCode = result.getExitCode() == 0 ? 1 : result.getExitCode();
        return new GitCommandResult(false, exitCode, (List)result.getErrorOutput(), (List)result.getOutput(), result.getException()){

            @Override
            public boolean cancelled() {
                return true;
            }
        };
    }

    @VisibleForTesting
    @NotNull
    protected GitInteractiveRebaseEditorHandler configureEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(service, project, root, handler);
        if (!commitListAware) {
            editor.setRebaseEditorShown();
        }
        service.configureHandler(handler, editor.getHandlerNo());
        return editor;
    }

    @NotNull
    private static GitCommandResult doLsRemote(final @NotNull Project project, final @NotNull File workingDir, final @NotNull String remoteId, final @NotNull Collection<String> authenticationUrls, final String ... additionalParameters) {
        return GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
                h.addParameters(additionalParameters);
                h.addParameters(remoteId);
                h.setUrls(authenticationUrls);
                return h;
            }
        });
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<GitLineHandlerListener> listeners) {
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<GitLineHandler> handlerConstructor) {
        boolean success;
        boolean authFailed;
        final ArrayList<String> errorOutput = new ArrayList<String>();
        final ArrayList<String> output = new ArrayList<String>();
        final AtomicInteger exitCode = new AtomicInteger();
        final AtomicBoolean startFailed = new AtomicBoolean();
        final AtomicReference<Object> exception = new AtomicReference<Object>();
        int authAttempt = 0;
        do {
            errorOutput.clear();
            output.clear();
            exitCode.set(0);
            startFailed.set(false);
            exception.set(null);
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            handler.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (GitImpl.looksLikeError(line)) {
                        errorOutput.add(line);
                    } else {
                        output.add(line);
                    }
                }

                public void processTerminated(int code) {
                    exitCode.set(code);
                }

                public void startFailed(Throwable t) {
                    startFailed.set(true);
                    errorOutput.add("Failed to start Git process");
                    exception.set(t);
                }
            });
            handler.runInCurrentThread(null);
            authFailed = handler.hasHttpAuthFailed();
            boolean bl = success = !startFailed.get() && (handler.isIgnoredErrorCode(exitCode.get()) || exitCode.get() == 0);
        } while (authFailed && authAttempt++ < 2);
        return new GitCommandResult(success, exitCode.get(), errorOutput, output, null);
    }

    @NotNull
    private static GitCommandResult run(@NotNull GitLineHandler handler) {
        return GitImpl.run((Computable<GitLineHandler>)new Computable.PredefinedValueComputable((Object)handler));
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> handlerConstructor) {
        return GitImpl.run(handlerConstructor);
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(final @NotNull GitLineHandler handler) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return handler;
            }
        });
    }

    @NotNull
    private static GitCommandResult runAll(@NotNull List<Computable<GitCommandResult>> commands) {
        if (commands.isEmpty()) {
            LOG.error("List of commands should not be empty", (Throwable)new Exception());
            return GitCommandResult.error("Internal error");
        }
        GitCommandResult compoundResult = null;
        for (Computable<GitCommandResult> command : commands) {
            compoundResult = GitCommandResult.merge(compoundResult, (GitCommandResult)command.compute());
        }
        return (GitCommandResult)ObjectUtils.assertNotNull(compoundResult);
    }

    private static boolean looksLikeError(final @NotNull String text) {
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, (Condition)new Condition<String>(){

            public boolean value(@NotNull String indicator) {
                return StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator);
            }
        });
    }
}

