/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.GitUntrackedFilesHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final ChangeListManager myChangeListManager;

    public GitCherryPicker(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade platformFacade) {
        this.myProject = project;
        this.myGit = git;
        this.myPlatformFacade = platformFacade;
        this.myChangeListManager = this.myPlatformFacade.getChangeListManager(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cherryPick(@NotNull List<VcsFullCommitDetails> commits) {
        Map commitsInRoots = DvcsUtil.groupCommitsByRoots(this.myPlatformFacade.getRepositoryManager(this.myProject), commits);
        LOG.info("Cherry-picking commits: " + GitCherryPicker.toString(commitsInRoots));
        ArrayList successfulCommits = ContainerUtil.newArrayList();
        ArrayList alreadyPicked = ContainerUtil.newArrayList();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            for (Map.Entry entry : commitsInRoots.entrySet()) {
                GitRepository repository = (GitRepository)entry.getKey();
                boolean result = this.cherryPick(repository, (List)entry.getValue(), successfulCommits, alreadyPicked);
                repository.update();
                if (result) continue;
                return;
            }
            this.notifyResult(successfulCommits, alreadyPicked);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }

    @NotNull
    private static String toString(final @NotNull Map<GitRepository, List<VcsFullCommitDetails>> commitsInRoots) {
        return StringUtil.join(commitsInRoots.keySet(), (Function)new Function<GitRepository, String>(){

            public String fun(@NotNull GitRepository repository) {
                String commits = StringUtil.join((Collection)((Collection)commitsInRoots.get(repository)), (Function)new Function<VcsFullCommitDetails, String>(){

                    public String fun(VcsFullCommitDetails details) {
                        return ((Hash)details.getId()).asString();
                    }
                }, (String)", ");
                return DvcsUtil.getShortRepositoryName((Repository)repository) + ": [" + commits + "]";
            }
        }, (String)"; ");
    }

    private boolean cherryPick(@NotNull GitRepository repository, @NotNull List<VcsFullCommitDetails> commits, @NotNull List<GitCommitWrapper> successfulCommits, @NotNull List<GitCommitWrapper> alreadyPicked) {
        for (VcsFullCommitDetails commit : commits) {
            GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
            GitSimpleEventDetector localChangesOverwrittenDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository.getRoot());
            boolean autoCommit = this.isAutoCommit();
            GitCommandResult result = this.myGit.cherryPick(repository, ((Hash)commit.getId()).asString(), autoCommit, conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector);
            GitCommitWrapper commitWrapper = new GitCommitWrapper(commit);
            if (result.success()) {
                if (autoCommit) {
                    successfulCommits.add(commitWrapper);
                    continue;
                }
                boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits, alreadyPicked);
                if (committed) continue;
                this.notifyCommitCancelled(commitWrapper, successfulCommits);
                return false;
            }
            if (conflictDetector.hasHappened()) {
                boolean mergeCompleted = new CherryPickConflictResolver(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getId()).asString(), commit.getAuthor().getName(), commit.getSubject()).merge();
                if (mergeCompleted) {
                    boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits, alreadyPicked);
                    if (committed) continue;
                    this.notifyCommitCancelled(commitWrapper, successfulCommits);
                    return false;
                }
                this.updateChangeListManager(commit);
                this.notifyConflictWarning(repository, commitWrapper, successfulCommits);
                return false;
            }
            if (untrackedFilesDetector.wasMessageDetected()) {
                String description = GitCherryPicker.commitDetails(commitWrapper) + "<br/>Some untracked working tree files would be overwritten by cherry-pick.<br/>" + "Please move, remove or add them before you can cherry-pick. <a href='view'>View them</a>";
                description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
                GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, repository.getRoot(), untrackedFilesDetector.getRelativeFilePaths(), "cherry-pick", description);
                return false;
            }
            if (localChangesOverwrittenDetector.hasHappened()) {
                this.notifyError("Your local changes would be overwritten by cherry-pick.<br/>Commit your changes or stash them to proceed.", commitWrapper, successfulCommits);
                return false;
            }
            if (GitCherryPicker.isNothingToCommitMessage(result)) {
                alreadyPicked.add(commitWrapper);
                return true;
            }
            this.notifyError(result.getErrorOutputAsHtmlString(), commitWrapper, successfulCommits);
            return false;
        }
        return true;
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result) {
        if (!result.getErrorOutputAsJoinedString().isEmpty()) {
            return false;
        }
        String stdout = result.getOutputAsJoinedString();
        return stdout.contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    private boolean updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(@NotNull GitRepository repository, @NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits, @NotNull List<GitCommitWrapper> alreadyPicked) {
        CherryPickData data = this.updateChangeListManager(commit.getCommit());
        if (data == null) {
            alreadyPicked.add(commit);
            return true;
        }
        boolean committed = this.showCommitDialogAndWaitForCommit(repository, commit, data.myChangeList, data.myCommitMessage);
        if (committed) {
            this.myChangeListManager.removeChangeList(data.myChangeList);
            successfulCommits.add(commit);
            return true;
        }
        return false;
    }

    private void notifyConflictWarning(@NotNull GitRepository repository, @NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits) {
        ResolveLinkListener resolveLinkListener = new ResolveLinkListener(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getCommit().getId()).toShortString(), commit.getCommit().getAuthor().getName(), commit.getSubject());
        String description = GitCherryPicker.commitDetails(commit) + "<br/>Unresolved conflicts remain in the working tree. <a href='resolve'>Resolve them.<a/>";
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Cherry-picked with conflicts", description, (NotificationListener)resolveLinkListener);
    }

    private void notifyCommitCancelled(@NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (successfulCommits.isEmpty()) {
            return;
        }
        String description = GitCherryPicker.commitDetails(commit);
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Cherry-pick cancelled", description, null);
    }

    @Nullable
    private CherryPickData updateChangeListManager(@NotNull VcsFullCommitDetails commit) {
        Collection changes = commit.getChanges();
        RefreshVFsSynchronously.updateChanges((Collection)changes);
        String commitMessage = GitCherryPicker.createCommitMessage(commit);
        List paths = ChangesUtil.getPaths((Collection)changes);
        LocalChangeList changeList = this.createChangeListAfterUpdate(commit, paths, commitMessage);
        return changeList == null ? null : new CherryPickData(changeList, commitMessage);
    }

    @Nullable
    private LocalChangeList createChangeListAfterUpdate(final @NotNull VcsFullCommitDetails commit, final @NotNull Collection<FilePath> paths, final @NotNull String commitMessage) {
        final CountDownLatch waiter = new CountDownLatch(1);
        final AtomicReference changeList = new AtomicReference();
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GitCherryPicker.this.myChangeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        changeList.set(GitCherryPicker.this.createChangeListIfThereAreChanges(commit, commitMessage));
                        waiter.countDown();
                    }
                }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "Cherry-pick", (Consumer)new Consumer<VcsDirtyScopeManager>(){

                    public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                        vcsDirtyScopeManager.filePathsDirty(paths, null);
                    }
                }, ModalityState.NON_MODAL);
            }
        }, ModalityState.NON_MODAL);
        try {
            boolean success = waiter.await(100L, TimeUnit.SECONDS);
            if (!success) {
                LOG.error("Couldn't await for changelist manager refresh");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return (LocalChangeList)changeList.get();
    }

    @NotNull
    private static String createCommitMessage(@NotNull VcsFullCommitDetails commit) {
        return commit.getFullMessage() + "\n(cherry picked from commit " + ((Hash)commit.getId()).toShortString() + ")";
    }

    private boolean showCommitDialogAndWaitForCommit(final @NotNull GitRepository repository, final @NotNull GitCommitWrapper commit, final @NotNull LocalChangeList changeList, final @NotNull String commitMessage) {
        final AtomicBoolean commitSucceeded = new AtomicBoolean();
        final Semaphore sem = new Semaphore(0);
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    GitCherryPicker.this.cancelCherryPick(repository);
                    Collection changes = commit.getCommit().getChanges();
                    boolean commitNotCancelled = GitCherryPicker.this.myPlatformFacade.getVcsHelper(GitCherryPicker.this.myProject).commitChanges(changes, changeList, commitMessage, new CommitResultHandler(){

                        public void onSuccess(@NotNull String commitMessage) {
                            commit.setActualSubject(commitMessage);
                            commitSucceeded.set(true);
                            sem.release();
                        }

                        public void onFailure() {
                            commitSucceeded.set(false);
                            sem.release();
                        }
                    });
                    if (!commitNotCancelled) {
                        commitSucceeded.set(false);
                        sem.release();
                    }
                }
                catch (Throwable t) {
                    LOG.error(t);
                    commitSucceeded.set(false);
                    sem.release();
                }
            }
        }, ModalityState.NON_MODAL);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private void cancelCherryPick(@NotNull GitRepository repository) {
        if (this.isAutoCommit()) {
            this.removeCherryPickHead(repository);
        }
    }

    private void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead();
        final VirtualFile cherryPickHead = this.myPlatformFacade.getLocalFileSystem().refreshAndFindFileByIoFile(cherryPickHeadFile);
        if (cherryPickHead != null && cherryPickHead.exists()) {
            this.myPlatformFacade.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        cherryPickHead.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    private void notifyError(@NotNull String content, @NotNull GitCommitWrapper failedCommit, @NotNull List<GitCommitWrapper> successfulCommits) {
        String description = GitCherryPicker.commitDetails(failedCommit) + "<br/>" + content;
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("Cherry-pick failed", description);
    }

    @NotNull
    private static String getSuccessfulCommitDetailsIfAny(@NotNull List<GitCommitWrapper> successfulCommits) {
        String description = "";
        if (!successfulCommits.isEmpty()) {
            description = description + "<hr/>However cherry-pick succeeded for the following " + StringUtil.pluralize((String)"commit", (int)successfulCommits.size()) + ":<br/>";
            description = description + GitCherryPicker.getCommitsDetails(successfulCommits);
        }
        return description;
    }

    private void notifyResult(@NotNull List<GitCommitWrapper> successfulCommits, @NotNull List<GitCommitWrapper> alreadyPicked) {
        if (alreadyPicked.isEmpty()) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Cherry-pick successful", GitCherryPicker.getCommitsDetails(successfulCommits));
        } else if (!successfulCommits.isEmpty()) {
            String title = String.format("Cherry-picked %d commits from %d", successfulCommits.size(), successfulCommits.size() + alreadyPicked.size());
            String description = GitCherryPicker.getCommitsDetails(successfulCommits) + "<hr/>" + GitCherryPicker.formAlreadyPickedDescription(alreadyPicked, true);
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess(title, description);
        } else {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Nothing to cherry-pick", GitCherryPicker.formAlreadyPickedDescription(alreadyPicked, false));
        }
    }

    @NotNull
    private static String formAlreadyPickedDescription(@NotNull List<GitCommitWrapper> alreadyPicked, boolean but) {
        String hashes = StringUtil.join(alreadyPicked, (Function)new Function<GitCommitWrapper, String>(){

            public String fun(GitCommitWrapper commit) {
                return ((Hash)commit.getCommit().getId()).toShortString();
            }
        }, (String)", ");
        if (but) {
            String wasnt = alreadyPicked.size() == 1 ? "wasn't" : "weren't";
            String it = alreadyPicked.size() == 1 ? "it" : "them";
            return String.format("%s %s picked, because all changes from %s have already been applied.", hashes, wasnt, it);
        }
        return String.format("All changes from %s have already been applied", hashes);
    }

    @NotNull
    private static String getCommitsDetails(@NotNull List<GitCommitWrapper> successfulCommits) {
        String description = "";
        for (GitCommitWrapper commit : successfulCommits) {
            description = description + GitCherryPicker.commitDetails(commit) + "<br/>";
        }
        return description.substring(0, description.length() - "<br/>".length());
    }

    @NotNull
    private static String commitDetails(@NotNull GitCommitWrapper commit) {
        return ((Hash)commit.getCommit().getId()).toShortString() + " " + commit.getOriginalSubject();
    }

    @Nullable
    private LocalChangeList createChangeListIfThereAreChanges(@NotNull VcsFullCommitDetails commit, @NotNull String commitMessage) {
        Collection originalChanges = commit.getChanges();
        if (originalChanges.isEmpty()) {
            LOG.info("Empty commit " + commit.getId());
            return null;
        }
        if (this.noChangesAfterCherryPick(originalChanges)) {
            LOG.info("No changes after cherry-picking " + commit.getId());
            return null;
        }
        String changeListName = this.createNameForChangeList(commitMessage, 0).replace('\n', ' ');
        LocalChangeList createdChangeList = ((ChangeListManagerEx)this.myChangeListManager).addChangeList(changeListName, commitMessage, (Object)commit);
        LocalChangeList actualChangeList = this.moveChanges(originalChanges, createdChangeList);
        if (actualChangeList != null && !actualChangeList.getChanges().isEmpty()) {
            return createdChangeList;
        }
        LOG.warn("No changes were moved to the changelist. Changes from commit: " + originalChanges + "\nAll changes: " + this.myChangeListManager.getAllChanges());
        this.myChangeListManager.removeChangeList(createdChangeList);
        return null;
    }

    private boolean noChangesAfterCherryPick(@NotNull Collection<Change> originalChanges) {
        final Collection allChanges = this.myChangeListManager.getAllChanges();
        return !ContainerUtil.exists(originalChanges, (Condition)new Condition<Change>(){

            public boolean value(Change change) {
                return allChanges.contains(change);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LocalChangeList moveChanges(@NotNull Collection<Change> originalChanges, final @NotNull LocalChangeList targetChangeList) {
        final CountDownLatch moveChangesWaiter = new CountDownLatch(1);
        final AtomicReference resultingChangeList = new AtomicReference();
        ChangeListAdapter listener = new ChangeListAdapter(){

            public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
                if (toList instanceof LocalChangeList && targetChangeList.getId().equals(((LocalChangeList)toList).getId())) {
                    resultingChangeList.set((LocalChangeList)toList);
                    moveChangesWaiter.countDown();
                }
            }
        };
        try {
            this.myChangeListManager.addChangeListListener((ChangeListListener)listener);
            this.myChangeListManager.moveChangesTo(targetChangeList, originalChanges.toArray(new Change[originalChanges.size()]));
            boolean success = moveChangesWaiter.await(100L, TimeUnit.SECONDS);
            if (!success) {
                LOG.error("Couldn't await for changes move.");
            }
            LocalChangeList localChangeList = (LocalChangeList)resultingChangeList.get();
            return localChangeList;
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            LocalChangeList localChangeList = null;
            return localChangeList;
        }
        finally {
            this.myChangeListManager.removeChangeListListener((ChangeListListener)listener);
        }
    }

    @NotNull
    private String createNameForChangeList(@NotNull String proposedName, int step) {
        for (LocalChangeList list : this.myChangeListManager.getChangeLists()) {
            if (!list.getName().equals(GitCherryPicker.nameWithStep(proposedName, step))) continue;
            return this.createNameForChangeList(proposedName, step + 1);
        }
        return GitCherryPicker.nameWithStep(proposedName, step);
    }

    private static String nameWithStep(String name, int step) {
        return step == 0 ? name : name + "-" + step;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    public String getActionTitle() {
        return "Cherry-Pick";
    }

    private boolean isAutoCommit() {
        return GitVcsSettings.getInstance(this.myProject).isAutoCommitOnCherryPick();
    }

    public boolean isEnabled(@NotNull VcsLog log, @NotNull Map<VirtualFile, List<Hash>> commits) {
        if (commits.isEmpty()) {
            return false;
        }
        for (VirtualFile root : commits.keySet()) {
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            if (repository == null) {
                return false;
            }
            for (Hash commit : commits.get(root)) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                Collection containingBranches = log.getContainingBranches(commit, root);
                if (currentBranch == null || containingBranches == null || !containingBranches.contains(currentBranch.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private static class GitCommitWrapper {
        @NotNull
        private final VcsFullCommitDetails myOriginalCommit;
        @NotNull
        private String myActualSubject;

        private GitCommitWrapper(@NotNull VcsFullCommitDetails commit) {
            this.myOriginalCommit = commit;
            this.myActualSubject = commit.getSubject();
        }

        @NotNull
        public String getSubject() {
            return this.myActualSubject;
        }

        public void setActualSubject(@NotNull String actualSubject) {
            this.myActualSubject = actualSubject;
        }

        @NotNull
        public VcsFullCommitDetails getCommit() {
            return this.myOriginalCommit;
        }

        public String getOriginalSubject() {
            return this.myOriginalCommit.getSubject();
        }
    }

    private static class CherryPickMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private String myCommitHash;
        private String myCommitAuthor;
        private String myCommitMessage;

        public CherryPickMergeDialogCustomizer(String commitHash, String commitAuthor, String commitMessage) {
            this.myCommitHash = commitHash;
            this.myCommitAuthor = commitAuthor;
            this.myCommitMessage = commitMessage;
        }

        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            return "<html>Conflicts during cherry-picking commit <code>" + this.myCommitHash + "</code> made by " + this.myCommitAuthor + "<br/>" + "<code>\"" + this.myCommitMessage + "\"</code></html>";
        }

        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            return "Local changes";
        }

        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            return "<html>Changes from cherry-pick <code>" + this.myCommitHash + "</code>";
        }
    }

    private static class ResolveLinkListener
    implements NotificationListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GitPlatformFacade myFacade;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myHash;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final String myMessage;

        public ResolveLinkListener(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage) {
            this.myProject = project;
            this.myGit = git;
            this.myFacade = facade;
            this.myRoot = root;
            this.myHash = commitHash;
            this.myAuthor = commitAuthor;
            this.myMessage = commitMessage;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                new CherryPickConflictResolver(this.myProject, this.myGit, this.myFacade, this.myRoot, this.myHash, this.myAuthor, this.myMessage).mergeNoProceed();
            }
        }
    }

    private static class CherryPickConflictResolver
    extends GitConflictResolver {
        public CherryPickConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage) {
            super(project, git, facade, Collections.singleton(root), CherryPickConflictResolver.makeParams(commitHash, commitAuthor, commitMessage));
        }

        private static GitConflictResolver.Params makeParams(String commitHash, String commitAuthor, String commitMessage) {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Cherry-picked with conflicts");
            params.setMergeDialogCustomizer(new CherryPickMergeDialogCustomizer(commitHash, commitAuthor, commitMessage));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }
    }

    private static class CherryPickData {
        @NotNull
        private final LocalChangeList myChangeList;
        @NotNull
        private final String myCommitMessage;

        private CherryPickData(@NotNull LocalChangeList list, @NotNull String message) {
            this.myChangeList = list;
            this.myCommitMessage = message;
        }
    }
}

