/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteRemoteBranchOperation
extends GitBranchOperation {
    private final String myBranchName;

    public GitDeleteRemoteBranchOperation(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull List<GitRepository> repositories, @NotNull String name) {
        super(project, facade, git, handler, repositories);
        this.myBranchName = name;
    }

    @Override
    protected void execute() {
        boolean deletedSuccessfully;
        final Collection<GitRepository> repositories = this.getRepositories();
        final Collection<String> trackingBranches = GitDeleteRemoteBranchOperation.findTrackingBranches(this.myBranchName, repositories);
        String currentBranch = GitBranchUtil.getCurrentBranchOrRev(repositories);
        boolean currentBranchTracksBranchToDelete = false;
        if (trackingBranches.contains(currentBranch)) {
            currentBranchTracksBranchToDelete = true;
            trackingBranches.remove(currentBranch);
        }
        final AtomicReference decision = new AtomicReference();
        final boolean finalCurrentBranchTracksBranchToDelete = currentBranchTracksBranchToDelete;
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                decision.set(GitDeleteRemoteBranchOperation.this.confirmBranchDeletion(GitDeleteRemoteBranchOperation.this.myBranchName, trackingBranches, finalCurrentBranchTracksBranchToDelete, repositories));
            }
        });
        if (((DeleteRemoteBranchDecision)decision.get()).delete() && (deletedSuccessfully = this.doDeleteRemote(this.myBranchName, repositories))) {
            final ArrayList<String> successfullyDeletedLocalBranches = new ArrayList<String>(1);
            if (((DeleteRemoteBranchDecision)decision.get()).deleteTracking()) {
                for (final String branch : trackingBranches) {
                    this.getIndicator().setText("Deleting " + branch);
                    new GitDeleteBranchOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, branch){

                        @Override
                        protected void notifySuccess(@NotNull String message) {
                            successfullyDeletedLocalBranches.add(branch);
                        }
                    }.execute();
                }
            }
            this.notifySuccessfulDeletion(this.myBranchName, successfullyDeletedLocalBranches);
        }
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Collection<String> findTrackingBranches(@NotNull String remoteBranch, @NotNull Collection<GitRepository> repositories) {
        return new GitMultiRootBranchConfig(repositories).getTrackingBranches(remoteBranch);
    }

    private boolean doDeleteRemote(@NotNull String branchName, @NotNull Collection<GitRepository> repositories) {
        Couple<String> pair = GitDeleteRemoteBranchOperation.splitNameOfRemoteBranch(branchName);
        String remoteName = (String)pair.getFirst();
        String branch = (String)pair.getSecond();
        GitCompoundResult result = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            GitCommandResult res;
            GitRemote remote = GitDeleteRemoteBranchOperation.getRemoteByName(repository, remoteName);
            if (remote == null) {
                String error = "Couldn't find remote by name: " + remoteName;
                LOG.error(error);
                res = GitCommandResult.error(error);
            } else {
                res = this.pushDeletion(repository, remote, branch);
                if (!res.success() && GitDeleteRemoteBranchOperation.isAlreadyDeletedError(res.getErrorOutputAsJoinedString())) {
                    res = this.myGit.remotePrune(repository, remote);
                }
            }
            result.append(repository, res);
            repository.update();
        }
        if (!result.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Failed to delete remote branch " + branchName, result.getErrorOutputWithReposIndication());
        }
        return result.totalSuccess();
    }

    private static boolean isAlreadyDeletedError(@NotNull String errorOutput) {
        return errorOutput.contains("remote ref does not exist");
    }

    private static Couple<String> splitNameOfRemoteBranch(String branchName) {
        int firstSlash = branchName.indexOf(47);
        String remoteName = firstSlash > -1 ? branchName.substring(0, firstSlash) : branchName;
        String remoteBranchName = branchName.substring(firstSlash + 1);
        return Couple.of((Object)remoteName, (Object)remoteBranchName);
    }

    @NotNull
    private GitCommandResult pushDeletion(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        return this.myGit.push(repository, remote, ":" + branchName, false, false, null, new GitLineHandlerListener[0]);
    }

    @Nullable
    private static GitRemote getRemoteByName(@NotNull GitRepository repository, @NotNull String remoteName) {
        for (GitRemote remote : repository.getRemotes()) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    private void notifySuccessfulDeletion(@NotNull String remoteBranchName, @NotNull Collection<String> localBranches) {
        String message = "";
        if (!localBranches.isEmpty()) {
            message = "Also deleted local " + StringUtil.pluralize((String)"branch", (int)localBranches.size()) + ": " + StringUtil.join(localBranches, (String)", ");
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Deleted remote branch " + remoteBranchName, message);
    }

    private DeleteRemoteBranchDecision confirmBranchDeletion(@NotNull String branchName, @NotNull Collection<String> trackingBranches, boolean currentBranchTracksBranchToDelete, @NotNull Collection<GitRepository> repositories) {
        boolean deleteTracking;
        boolean delete;
        String title = "Delete Remote Branch";
        String message = "Delete remote branch " + branchName;
        if (trackingBranches.isEmpty()) {
            delete = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title, (String)"Delete", (String)"Cancel", (Icon)Messages.getQuestionIcon()) == 0;
            deleteTracking = false;
        } else {
            if (currentBranchTracksBranchToDelete) {
                message = message + "\n\nCurrent branch " + GitBranchUtil.getCurrentBranchOrRev(repositories) + " tracks " + branchName + " but won't be deleted.";
            }
            final String checkboxMessage = trackingBranches.size() == 1 ? "Delete tracking local branch " + trackingBranches.iterator().next() + " as well" : "Delete tracking local branches " + StringUtil.join(trackingBranches, (String)", ");
            final AtomicBoolean deleteChoice = new AtomicBoolean();
            delete = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).project(this.myProject)).yesText("Delete")).noText("Cancel")).doNotAsk(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    return true;
                }

                public void setToBeShown(boolean value, int exitCode) {
                    deleteChoice.set(!value);
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return checkboxMessage;
                }
            })).show() == 0;
            deleteTracking = deleteChoice.get();
        }
        return new DeleteRemoteBranchDecision(delete, deleteTracking);
    }

    private static class DeleteRemoteBranchDecision {
        private final boolean delete;
        private final boolean deleteTracking;

        private DeleteRemoteBranchDecision(boolean delete, boolean deleteTracking) {
            this.delete = delete;
            this.deleteTracking = deleteTracking;
        }

        public boolean delete() {
            return this.delete;
        }

        public boolean deleteTracking() {
            return this.deleteTracking;
        }
    }
}

