/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitPlatformFacade;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class GitCheckoutNewBranchOperation
extends GitBranchOperation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNewBranchName;

    GitCheckoutNewBranchOperation(@NotNull Project project, GitPlatformFacade facade, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String newBranchName) {
        super(project, facade, git, uiHandler, repositories);
        this.myNewBranchName = newBranchName;
        this.myProject = project;
    }

    @Override
    protected void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitSimpleEventDetector unmergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result = this.myGit.checkoutNewBranch(repository, this.myNewBranchName, unmergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT));
            if (result.success()) {
                GitCheckoutNewBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (unmergedDetector.hasHappened()) {
                this.fatalUnmergedFilesError();
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError("Couldn't create new branch " + this.myNewBranchName, result.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.updateRecentBranch();
        }
    }

    private static void refresh(@NotNull GitRepository repository) {
        repository.update();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return String.format("Branch <b><code>%s</code></b> was created", this.myNewBranchName);
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return "However checkout has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (checkout previous branch back, and delete " + this.myNewBranchName + ") not to let branches diverge.";
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "checkout";
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            GitCommandResult result = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result);
            if (result.success()) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranchName, false, new GitLineHandlerListener[0]));
            }
            GitCheckoutNewBranchOperation.refresh(repository);
        }
        if (checkoutResult.totalSuccess() && deleteResult.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Rollback successful", String.format("Checked out %s and deleted %s on %s %s", GitCheckoutNewBranchOperation.stringifyBranchesByRepos(this.myCurrentHeads), GitUIUtil.code(this.myNewBranchName), StringUtil.pluralize((String)"root", (int)repositories.size()), this.successfulRepositoriesJoined()));
        } else {
            StringBuilder message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append("Errors during checkout: ");
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append("Errors during deleting ").append(GitUIUtil.code(this.myNewBranchName));
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", message.toString());
        }
    }
}

