/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final Function<GitBranch, String> BRANCH_TO_NAME = new Function<GitBranch, String>(){

        public String apply(@Nullable GitBranch input) {
            assert (input != null);
            return input.getName();
        }
    };
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!trackInfo.getLocalBranch().equals(branch)) continue;
            return trackInfo;
        }
        return null;
    }

    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<GitRepository> repositories) {
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + (Object)((Object)multiRootBranchConfig)));
            return currentBranch;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        return GitBranchUtil.getBranchNameOrRev(repository);
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches) {
        return Collections2.transform(branches, BRANCH_TO_NAME);
    }

    @Deprecated
    @Nullable
    public static GitLocalBranch getCurrentBranch(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository != null) {
            return repository.getCurrentBranch();
        }
        LOG.info("getCurrentBranch: Repository is null for root " + root);
        return GitBranchUtil.getCurrentBranchFromGit(project, root);
    }

    @Nullable
    private static GitLocalBranch getCurrentBranchFromGit(@NotNull Project project, @NotNull VirtualFile root) {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.REV_PARSE);
        handler.addParameters("--abbrev-ref", "HEAD");
        handler.setSilent(true);
        try {
            String name = handler.run();
            if (!name.equals("HEAD")) {
                return new GitLocalBranch(name);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.info("git rev-parse --abbrev-ref HEAD", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getTrackedRemoteName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedRemoteKey(branchName));
    }

    @Nullable
    public static String getTrackedBranchName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedBranchKey(branchName));
    }

    @NotNull
    private static String trackedBranchKey(String branchName) {
        return "branch." + branchName + ".merge";
    }

    @NotNull
    private static String trackedRemoteKey(String branchName) {
        return "branch." + branchName + ".remote";
    }

    @Deprecated
    @Nullable
    public static GitRemoteBranch tracked(@NotNull Project project, @NotNull VirtualFile root, @NotNull String branchName) throws VcsException {
        HashMap<String, String> result = new HashMap<String, String>();
        GitConfigUtil.getValues(project, root, null, result);
        String remoteName = result.get(GitBranchUtil.trackedRemoteKey(branchName));
        if (remoteName == null) {
            return null;
        }
        String branch = result.get(GitBranchUtil.trackedBranchKey(branchName));
        if (branch == null) {
            return null;
        }
        if (".".equals(remoteName)) {
            return new GitSvnRemoteBranch(branch);
        }
        GitRemote remote = GitBranchUtil.findRemoteByNameOrLogError(project, root, remoteName);
        if (remote == null) {
            return null;
        }
        return new GitStandardRemoteBranch(remote, branch);
    }

    @Deprecated
    @Nullable
    public static GitRemote findRemoteByNameOrLogError(@NotNull Project project, @NotNull VirtualFile root, @NotNull String remoteName) {
        GitRepository repository = GitUtil.getRepositoryForRootOrLogError(project, root);
        if (repository == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote with name " + remoteName);
            return null;
        }
        return remote;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<GitRemoteBranch> remoteBranches) {
        return Collections2.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                assert (input != null);
                return !input.equals("HEAD");
            }
        });
    }

    @NotNull
    public static String stripRefsPrefix(@NotNull String branchName) {
        if (branchName.startsWith("refs/heads/")) {
            return branchName.substring("refs/heads/".length());
        }
        if (branchName.startsWith("refs/remotes/")) {
            return branchName.substring("refs/remotes/".length());
        }
        if (branchName.startsWith("refs/tags/")) {
            return branchName.substring("refs/tags/".length());
        }
        return branchName;
    }

    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            return currentBranch.getName();
        }
        String currentRevision = repository.getCurrentRevision();
        return currentRevision != null ? currentRevision.substring(0, 7) : "";
    }

    @Nullable
    public static String getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<GitRepository> repositories, @NotNull String dialogTitle) {
        return Messages.showInputDialog((Project)project, (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(repositories));
    }

    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        GitLocalBranch branch;
        Repository.State state = repository.getState();
        if (state == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            return DvcsUtil.getShortHash((String)currentRevision);
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        }
        String branchName = (branch = repository.getCurrentBranch()) == null ? "" : branch.getName();
        return prefix + branchName;
    }

    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<GitRepository> repositories, boolean local) {
        Collection<Object> commonBranches = null;
        for (GitRepository repository : repositories) {
            Collection<Object> names;
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<Object> collection = names = local ? GitBranchUtil.convertBranchesToNames(branchesCollection.getLocalBranches()) : GitBranchUtil.getBranchNamesWithoutRemoteHead(branchesCollection.getRemoteBranches());
            if (commonBranches == null) {
                commonBranches = names;
                continue;
            }
            commonBranches = ContainerUtil.intersection(commonBranches, names);
        }
        if (commonBranches != null) {
            ArrayList<String> common = new ArrayList<String>(commonBranches);
            Collections.sort(common);
            return common;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = handler.run()).trim().length() == 0) {
            try {
                File headFile = ((GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root))).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim();
                String prefix = "ref: refs/heads/";
                return head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return Collections.emptyList();
            }
        }
        ArrayList branches = ContainerUtil.newArrayList();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches.add(b);
        }
        return branches;
    }
}

