/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitAbstractRebaseAction
extends DumbAwareAction {
    GitAbstractRebaseAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        if (project == null || !GitUtil.hasGitRepositories(project)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(GitAbstractRebaseAction.hasRebaseInProgress(project));
        }
    }

    public final void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ProgressManager progressManager = ProgressManager.getInstance();
        String progressTitle = this.getProgressTitle();
        if (GitUtil.getRepositoryManager(project).hasOngoingRebase()) {
            progressManager.run((Task)new Task.Backgroundable(project, progressTitle){

                public void run(@NotNull ProgressIndicator indicator) {
                    GitAbstractRebaseAction.this.performActionForProject(project, indicator);
                }
            });
        } else {
            final GitRepository repositoryToOperate = this.chooseRepository(project, GitRebaseUtils.getRebasingRepositories(project));
            if (repositoryToOperate != null) {
                progressManager.run((Task)new Task.Backgroundable(project, progressTitle){

                    public void run(@NotNull ProgressIndicator indicator) {
                        GitAbstractRebaseAction.this.performActionForRepository(project, repositoryToOperate, indicator);
                    }
                });
            }
        }
    }

    @NotNull
    protected abstract String getProgressTitle();

    protected abstract void performActionForProject(@NotNull Project var1, @NotNull ProgressIndicator var2);

    protected abstract void performActionForRepository(@NotNull Project var1, @NotNull GitRepository var2, @NotNull ProgressIndicator var3);

    private static boolean hasRebaseInProgress(@NotNull Project project) {
        return !GitRebaseUtils.getRebasingRepositories(project).isEmpty();
    }

    @Nullable
    private GitRepository chooseRepository(@NotNull Project project, @NotNull Collection<GitRepository> repositories) {
        GitRepository firstRepo = (GitRepository)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(repositories));
        if (repositories.size() == 1) {
            return firstRepo;
        }
        ArrayList roots = ContainerUtil.newArrayList(GitUtil.getRootsFromRepositories(repositories));
        GitRebaseActionDialog dialog = new GitRebaseActionDialog(project, this.getTemplatePresentation().getText(), roots, firstRepo.getRoot());
        dialog.show();
        VirtualFile root = dialog.selectRoot();
        if (root == null) {
            return null;
        }
        return (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRootQuick(root);
    }
}

