/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    @NotNull
    private final GitBrancher myBrancher;
    @NotNull
    private final GitRefNameValidator myNameValidator;

    public GitTaskHandler(@NotNull GitBrancher brancher, @NotNull GitRepositoryManager repositoryManager, @NotNull Project project) {
        super((AbstractRepositoryManager)repositoryManager, project, "branch");
        this.myBrancher = brancher;
        this.myNameValidator = GitRefNameValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<GitRepository> repos, @Nullable Runnable callInAwtLater) {
        this.myBrancher.checkout(taskName, false, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository) {
        return repository.getCurrentBranchName();
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<GitRepository> repositories) {
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(@NotNull GitRepository repository, @NotNull String name) {
        return repository.getBranches().findLocalBranch(name) != null;
    }

    @NotNull
    protected Collection<String> getAllBranches(@NotNull GitRepository repository) {
        return ContainerUtil.map(repository.getBranches().getLocalBranches(), (Function)new Function<GitLocalBranch, String>(){

            public String fun(GitLocalBranch branch) {
                return branch.getName();
            }
        });
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        return this.myNameValidator.cleanUpBranchName(suggestedName);
    }
}

