/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRevisionNumber
implements ShortVcsRevisionNumber {
    public static final String NOT_COMMITTED_HASH = StringUtil.repeat((String)"0", (int)40);
    public static final GitRevisionNumber HEAD = new GitRevisionNumber("HEAD");
    @NotNull
    private final String myRevisionHash;
    @NotNull
    private final Date myTimestamp;
    private static final Logger LOG = Logger.getInstance(GitRevisionNumber.class);

    public GitRevisionNumber(@NonNls @NotNull String version) {
        this.myRevisionHash = version;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NotNull String version, @NotNull Date timeStamp) {
        this.myTimestamp = timeStamp;
        this.myRevisionHash = version;
    }

    @NotNull
    public String asString() {
        return this.myRevisionHash;
    }

    public String toShortString() {
        return this.asString().substring(0, 7);
    }

    @NotNull
    public Date getTimestamp() {
        return this.myTimestamp;
    }

    @NotNull
    public String getRev() {
        return this.myRevisionHash;
    }

    @NotNull
    public String getShortRev() {
        return DvcsUtil.getShortHash((String)this.myRevisionHash);
    }

    public int compareTo(VcsRevisionNumber crev) {
        if (this == crev) {
            return 0;
        }
        if (crev instanceof GitRevisionNumber) {
            int tildeIndex;
            GitRevisionNumber other = (GitRevisionNumber)crev;
            if (other.myRevisionHash != null && this.myRevisionHash.equals(other.myRevisionHash)) {
                return 0;
            }
            if (other.myRevisionHash.indexOf("[") > 0 && other.myTimestamp != null) {
                return this.myTimestamp.compareTo(other.myTimestamp);
            }
            String otherName = null;
            String thisName = null;
            int otherParents = -1;
            int thisParent = -1;
            if (other.myRevisionHash.contains("~")) {
                tildeIndex = other.myRevisionHash.indexOf(126);
                otherName = other.myRevisionHash.substring(0, tildeIndex);
                otherParents = Integer.parseInt(other.myRevisionHash.substring(tildeIndex));
            }
            if (this.myRevisionHash.contains("~")) {
                tildeIndex = this.myRevisionHash.indexOf(126);
                thisName = this.myRevisionHash.substring(0, tildeIndex);
                thisParent = Integer.parseInt(this.myRevisionHash.substring(tildeIndex));
            }
            if (otherName == null && thisName == null) {
                int result = this.myTimestamp.compareTo(other.myTimestamp);
                if (result == 0) {
                    return this.myRevisionHash.compareTo(other.myRevisionHash);
                }
                return result;
            }
            if (otherName == null) {
                return 1;
            }
            if (thisName == null) {
                return -1;
            }
            return thisParent - otherParents;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitRevisionNumber test = (GitRevisionNumber)obj;
        return this.myRevisionHash.equals(test.myRevisionHash);
    }

    public int hashCode() {
        return this.myRevisionHash.hashCode();
    }

    public String getParentRevisionStr() {
        int tildeIndex;
        String rev = this.myRevisionHash;
        int bracketIdx = rev.indexOf("[");
        if (bracketIdx > 0) {
            rev = this.myRevisionHash.substring(bracketIdx + 1, this.myRevisionHash.indexOf("]"));
        }
        if ((tildeIndex = rev.indexOf("~")) > 0) {
            int n = Integer.parseInt(rev.substring(tildeIndex)) + 1;
            return rev.substring(0, tildeIndex) + "~" + n;
        }
        return rev + "~1";
    }

    public static GitRevisionNumber resolve(Project project, VirtualFile vcsRoot, @NonNls String rev) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, vcsRoot, GitCommand.REV_LIST);
        h.setSilent(true);
        h.addParameters("--timestamp", "--max-count=1", rev);
        h.endOptions();
        String output = h.run();
        return GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h, output);
    }

    @NotNull
    public static GitRevisionNumber parseRevlistOutputAsRevisionNumber(@NotNull GitSimpleHandler h, @NotNull String output) throws VcsException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(output, "\n\r \t", false);
            LOG.assertTrue(tokenizer.hasMoreTokens(), (Object)("No required tokens in the output: \n" + output));
            Date timestamp = GitUtil.parseTimestampWithNFEReport(tokenizer.nextToken(), h, output);
            return new GitRevisionNumber(tokenizer.nextToken(), timestamp);
        }
        catch (Exception e) {
            throw new VcsException("Couldn't parse the output: [" + output + "]", (Throwable)e);
        }
    }

    public String toString() {
        return this.myRevisionHash;
    }
}

