/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.Hash;
import git4idea.GitReference;
import git4idea.branch.GitBranchUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitBranch
extends GitReference {
    @NonNls
    public static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    public static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    private static final Logger LOG = Logger.getInstance(GitBranch.class);
    @Deprecated
    @Nullable
    public static final Hash DUMMY_HASH = null;

    protected GitBranch(@NotNull String name) {
        super(GitBranchUtil.stripRefsPrefix(name));
    }

    public abstract boolean isRemote();

    @Override
    @NotNull
    public String getFullName() {
        return (this.isRemote() ? REFS_REMOTES_PREFIX : REFS_HEADS_PREFIX) + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @NotNull
    public String toLogString() {
        return String.format("%s:%s", this.getFullName(), this.isRemote() ? "remote" : "local");
    }
}

