/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.DistributionPointName;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.ReasonFlags;

public class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.IssuingDistributionPoint";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String POINT = "point";
    public static final String REASONS = "reasons";
    public static final String ONLY_USER_CERTS = "only_user_certs";
    public static final String ONLY_CA_CERTS = "only_ca_certs";
    public static final String ONLY_ATTRIBUTE_CERTS = "only_attribute_certs";
    public static final String INDIRECT_CRL = "indirect_crl";
    private DistributionPointName distributionPoint = null;
    private ReasonFlags revocationReasons = null;
    private boolean hasOnlyUserCerts = false;
    private boolean hasOnlyCACerts = false;
    private boolean hasOnlyAttributeCerts = false;
    private boolean isIndirectCRL = false;
    private static final byte TAG_DISTRIBUTION_POINT = 0;
    private static final byte TAG_ONLY_USER_CERTS = 1;
    private static final byte TAG_ONLY_CA_CERTS = 2;
    private static final byte TAG_ONLY_SOME_REASONS = 3;
    private static final byte TAG_INDIRECT_CRL = 4;
    private static final byte TAG_ONLY_ATTRIBUTE_CERTS = 5;

    public IssuingDistributionPointExtension(DistributionPointName distributionPointName, ReasonFlags reasonFlags, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (bl && (bl2 || bl3) || bl2 && (bl || bl3) || bl3 && (bl || bl2)) {
            throw new IllegalArgumentException("Only one of hasOnlyUserCerts, hasOnlyCACerts, hasOnlyAttributeCerts may be set to true");
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.distributionPoint = distributionPointName;
        this.revocationReasons = reasonFlags;
        this.hasOnlyUserCerts = bl;
        this.hasOnlyCACerts = bl2;
        this.hasOnlyAttributeCerts = bl3;
        this.isIndirectCRL = bl4;
        this.encodeThis();
    }

    public IssuingDistributionPointExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
        }
        if (derValue.data == null || derValue.data.available() == 0) {
            return;
        }
        DerInputStream derInputStream = derValue.data;
        while (derInputStream != null && derInputStream.available() != 0) {
            DerValue derValue2 = derInputStream.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                this.distributionPoint = new DistributionPointName(derValue2.data.getDerValue());
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.hasOnlyUserCerts = derValue2.getBoolean();
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.hasOnlyCACerts = derValue2.getBoolean();
                continue;
            }
            if (derValue2.isContextSpecific((byte)3) && !derValue2.isConstructed()) {
                this.revocationReasons = new ReasonFlags(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)4) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.isIndirectCRL = derValue2.getBoolean();
                continue;
            }
            if (derValue2.isContextSpecific((byte)5) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.hasOnlyAttributeCerts = derValue2.getBoolean();
                continue;
            }
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(POINT)) {
            if (!(object instanceof DistributionPointName)) {
                throw new IOException("Attribute value should be of type DistributionPointName.");
            }
            this.distributionPoint = (DistributionPointName)object;
        } else if (string.equalsIgnoreCase(REASONS)) {
            if (!(object instanceof ReasonFlags)) {
                throw new IOException("Attribute value should be of type ReasonFlags.");
            }
            this.revocationReasons = (ReasonFlags)object;
        } else if (string.equalsIgnoreCase(INDIRECT_CRL)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.isIndirectCRL = (Boolean)object;
        } else if (string.equalsIgnoreCase(ONLY_USER_CERTS)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyUserCerts = (Boolean)object;
        } else if (string.equalsIgnoreCase(ONLY_CA_CERTS)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyCACerts = (Boolean)object;
        } else if (string.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyAttributeCerts = (Boolean)object;
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:IssuingDistributionPointExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(POINT)) {
            return this.distributionPoint;
        }
        if (string.equalsIgnoreCase(INDIRECT_CRL)) {
            return this.isIndirectCRL;
        }
        if (string.equalsIgnoreCase(REASONS)) {
            return this.revocationReasons;
        }
        if (string.equalsIgnoreCase(ONLY_USER_CERTS)) {
            return this.hasOnlyUserCerts;
        }
        if (string.equalsIgnoreCase(ONLY_CA_CERTS)) {
            return this.hasOnlyCACerts;
        }
        if (string.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            return this.hasOnlyAttributeCerts;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:IssuingDistributionPointExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(POINT)) {
            this.distributionPoint = null;
        } else if (string.equalsIgnoreCase(INDIRECT_CRL)) {
            this.isIndirectCRL = false;
        } else if (string.equalsIgnoreCase(REASONS)) {
            this.revocationReasons = null;
        } else if (string.equalsIgnoreCase(ONLY_USER_CERTS)) {
            this.hasOnlyUserCerts = false;
        } else if (string.equalsIgnoreCase(ONLY_CA_CERTS)) {
            this.hasOnlyCACerts = false;
        } else if (string.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            this.hasOnlyAttributeCerts = false;
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:IssuingDistributionPointExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(POINT);
        attributeNameEnumeration.addElement(REASONS);
        attributeNameEnumeration.addElement(ONLY_USER_CERTS);
        attributeNameEnumeration.addElement(ONLY_CA_CERTS);
        attributeNameEnumeration.addElement(ONLY_ATTRIBUTE_CERTS);
        attributeNameEnumeration.addElement(INDIRECT_CRL);
        return attributeNameEnumeration.elements();
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (!(this.distributionPoint != null || this.revocationReasons != null || this.hasOnlyUserCerts || this.hasOnlyCACerts || this.hasOnlyAttributeCerts || this.isIndirectCRL)) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.distributionPoint != null) {
            derOutputStream = new DerOutputStream();
            this.distributionPoint.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.hasOnlyUserCerts) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.hasOnlyUserCerts);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        if (this.hasOnlyCACerts) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.hasOnlyCACerts);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        if (this.revocationReasons != null) {
            derOutputStream = new DerOutputStream();
            this.revocationReasons.encode(derOutputStream);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)3), derOutputStream);
        }
        if (this.isIndirectCRL) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.isIndirectCRL);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)4), derOutputStream);
        }
        if (this.hasOnlyAttributeCerts) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.hasOnlyAttributeCerts);
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)5), derOutputStream);
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("IssuingDistributionPoint [\n  ");
        if (this.distributionPoint != null) {
            stringBuilder.append(this.distributionPoint);
        }
        if (this.revocationReasons != null) {
            stringBuilder.append(this.revocationReasons);
        }
        stringBuilder.append(this.hasOnlyUserCerts ? "  Only contains user certs: true" : "  Only contains user certs: false").append("\n");
        stringBuilder.append(this.hasOnlyCACerts ? "  Only contains CA certs: true" : "  Only contains CA certs: false").append("\n");
        stringBuilder.append(this.hasOnlyAttributeCerts ? "  Only contains attribute certs: true" : "  Only contains attribute certs: false").append("\n");
        stringBuilder.append(this.isIndirectCRL ? "  Indirect CRL: true" : "  Indirect CRL: false").append("\n");
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

