/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.GoogleAnalyticsPublisher;
import com.android.tools.analytics.NullAnalyticsPublisher;
import com.android.utils.ILogger;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AnalyticsPublisher
implements AutoCloseable {
    private static final Object sGate = new Object();
    private static AnalyticsPublisher sInstance;
    private long mPublishIntervalNanos = TimeUnit.MINUTES.toNanos(10L);
    private final AnalyticsSettings mAnalyticsSettings;
    private final ScheduledExecutorService mScheduler;

    protected AnalyticsPublisher(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        this.mAnalyticsSettings = analyticsSettings;
        this.mScheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsPublisher initialize(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        Object object = sGate;
        synchronized (object) {
            sInstance = analyticsSettings.hasOptedIn() && !analyticsSettings.hasDebugDisablePublishing() ? new GoogleAnalyticsPublisher(analyticsSettings, scheduler, Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0])) : new NullAnalyticsPublisher(analyticsSettings, scheduler);
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsPublisher getInstance() {
        Object object = sGate;
        synchronized (object) {
            return sInstance;
        }
    }

    public void setPublishInterval(long interval, TimeUnit unit) {
        this.mPublishIntervalNanos = unit.toNanos(interval);
    }

    public AnalyticsSettings getAnalyticsSettings() {
        return this.mAnalyticsSettings;
    }

    public long getPublishInterval() {
        return this.mPublishIntervalNanos;
    }

    public ScheduledExecutorService getScheduler() {
        return this.mScheduler;
    }

    public static void updatePublisher(ILogger logger, AnalyticsSettings settings, ScheduledExecutorService scheduler) {
        AnalyticsPublisher current = AnalyticsPublisher.getInstance();
        if (current != null) {
            try {
                current.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e, "Unable to close existing analytics publisher", new Object[0]);
            }
        }
        AnalyticsPublisher.initialize(settings, scheduler);
    }
}

