/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.util.Properties;
import java.util.regex.Pattern;

public final class AndroidVersion
implements Comparable<AndroidVersion> {
    private final int mApiLevel;
    private final String mCodename;
    public static final AndroidVersion DEFAULT = new AndroidVersion(1, null);

    public AndroidVersion(int apiLevel, @Nullable String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = AndroidVersion.sanitizeCodename(codename);
    }

    public AndroidVersion(@Nullable Properties properties, int defaultApiLevel, @Nullable String defaultCodeName) {
        if (properties == null) {
            this.mApiLevel = defaultApiLevel;
            this.mCodename = AndroidVersion.sanitizeCodename(defaultCodeName);
        } else {
            this.mApiLevel = Integer.parseInt(properties.getProperty("AndroidVersion.ApiLevel", Integer.toString(defaultApiLevel)));
            this.mCodename = AndroidVersion.sanitizeCodename(properties.getProperty("AndroidVersion.CodeName", defaultCodeName));
        }
    }

    public AndroidVersion(@NonNull Properties properties) throws AndroidVersionException {
        NumberFormatException error = null;
        String apiLevel = properties.getProperty("AndroidVersion.ApiLevel", null);
        if (apiLevel != null) {
            try {
                this.mApiLevel = Integer.parseInt(apiLevel);
                this.mCodename = AndroidVersion.sanitizeCodename(properties.getProperty("AndroidVersion.CodeName", null));
                return;
            }
            catch (NumberFormatException e) {
                error = e;
            }
        }
        throw new AndroidVersionException("AndroidVersion.ApiLevel not found!", error);
    }

    public AndroidVersion(@NonNull String apiOrCodename) throws AndroidVersionException {
        String codename;
        int apiLevel;
        block3: {
            apiLevel = 0;
            codename = null;
            try {
                apiLevel = Integer.parseInt(apiOrCodename);
            }
            catch (NumberFormatException ignore) {
                if ("REL".equals(apiOrCodename) || !Pattern.matches("[A-Z_]+", apiOrCodename)) break block3;
                codename = apiOrCodename;
            }
        }
        this.mApiLevel = apiLevel;
        this.mCodename = AndroidVersion.sanitizeCodename(codename);
        if (this.mApiLevel <= 0 && codename == null) {
            throw new AndroidVersionException("Invalid android API or codename " + apiOrCodename, null);
        }
    }

    public void saveProperties(@NonNull Properties props) {
        props.setProperty("AndroidVersion.ApiLevel", Integer.toString(this.mApiLevel));
        if (this.mCodename != null) {
            props.setProperty("AndroidVersion.CodeName", this.mCodename);
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public int getFeatureLevel() {
        return this.mCodename != null ? this.mApiLevel + 1 : this.mApiLevel;
    }

    @Nullable
    public String getCodename() {
        return this.mCodename;
    }

    @NonNull
    public String getApiString() {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        return Integer.toString(this.mApiLevel);
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean canRun(@NonNull AndroidVersion appVersion) {
        if (appVersion.mCodename != null) {
            return appVersion.mCodename.equals(this.mCodename);
        }
        return this.mApiLevel >= appVersion.mApiLevel;
    }

    public boolean equals(int apiLevel) {
        return this.mCodename == null && apiLevel == this.mApiLevel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidVersion) {
            AndroidVersion version = (AndroidVersion)obj;
            if (this.mCodename == null) {
                return version.mCodename == null && this.mApiLevel == version.mApiLevel;
            }
            return this.mCodename.equals(version.mCodename) && this.mApiLevel == version.mApiLevel;
        }
        if (obj instanceof String) {
            if (this.mCodename != null) {
                return this.mCodename.equals(obj);
            }
            try {
                int value = Integer.parseInt((String)obj);
                return value == this.mApiLevel;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.mCodename != null) {
            return this.mCodename.hashCode();
        }
        return this.mApiLevel;
    }

    public String toString() {
        String s = String.format("API %1$d", this.mApiLevel);
        if (this.isPreview()) {
            s = s + String.format(", %1$s preview", this.mCodename);
        }
        return s;
    }

    @Override
    public int compareTo(@NonNull AndroidVersion o) {
        return this.compareTo(o.mApiLevel, o.mCodename);
    }

    public int compareTo(int apiLevel, @Nullable String codename) {
        if (this.mCodename == null) {
            if (codename == null) {
                return this.mApiLevel - apiLevel;
            }
            if (this.mApiLevel == apiLevel) {
                return -1;
            }
            return this.mApiLevel - apiLevel;
        }
        if (this.mApiLevel == apiLevel) {
            if (codename == null) {
                return 1;
            }
            return this.mCodename.compareTo(codename);
        }
        return this.mApiLevel - apiLevel;
    }

    public boolean isGreaterOrEqualThan(int api) {
        return this.compareTo(api, null) >= 0;
    }

    @Nullable
    private static String sanitizeCodename(@Nullable String codename) {
        if (codename != null && ((codename = codename.trim()).isEmpty() || "REL".equals(codename))) {
            codename = null;
        }
        return codename;
    }

    public static final class AndroidVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AndroidVersionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

