/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.Debugger;
import com.google.api.services.debugger.model.Breakpoint;
import com.google.api.services.debugger.model.GetBreakpointResponse;
import com.google.api.services.debugger.model.ListBreakpointsResponse;
import com.google.api.services.debugger.model.SetBreakpointResponse;
import com.google.api.services.debugger.model.SourceLocation;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gct.idea.debugger.BreakpointComparer;
import com.google.gct.idea.debugger.BreakpointUtil;
import com.google.gct.idea.debugger.CloudBreakpointListener;
import com.google.gct.idea.debugger.CloudDebugConfigType;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebuggerClient;
import com.google.gct.idea.util.GctBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.ImmutableList;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebugProcessStateController {
    private static final int INITIAL_DELAY_MS = 2000;
    private static final Logger LOG = Logger.getInstance(CloudDebugProcessStateController.class);
    private static final int PERIOD_MS = 500;
    private final List<CloudBreakpointListener> myBreakpointListChangedListeners = new ArrayList<CloudBreakpointListener>();
    private final ConcurrentHashMap<String, Breakpoint> myFullFinalBreakpoints = new ConcurrentHashMap();
    private Timer myListBreakpointsJob;
    private CloudDebugProcessState myState;

    protected CloudDebugProcessStateController() {
    }

    public void addListener(@NotNull CloudBreakpointListener listener) {
        this.myBreakpointListChangedListeners.add(listener);
    }

    void deleteBreakpoint(@NotNull String breakpointId) {
        if (this.myState == null) {
            throw new IllegalStateException();
        }
        Debugger client = CloudDebuggerClient.getCloudDebuggerClient(this.myState);
        if (client == null) {
            LOG.warn("no client available attempting to setBreakpoint");
            Messages.showErrorDialog((Project)this.myState.getProject(), (String)GctBundle.getString("clouddebug.bad_login_message", new Object[0]), (String)GctBundle.getString("clouddebug.errortitle", new Object[0]));
            return;
        }
        try {
            client.debuggees().breakpoints().delete(this.myState.getDebuggeeId(), breakpointId).execute();
        }
        catch (IOException ex) {
            LOG.warn("exception deleting breakpoint " + breakpointId, (Throwable)ex);
        }
    }

    public void fireBreakpointsChanged() {
        for (CloudBreakpointListener listener : this.myBreakpointListChangedListeners) {
            listener.onBreakpointListChanged(this.myState);
        }
    }

    public void initialize(@NotNull CloudDebugProcessState state) {
        this.myState = state;
        this.myState.setWaitToken(null);
        this.waitForChanges();
    }

    public void removeListener(@NotNull CloudBreakpointListener listener) {
        this.myBreakpointListChangedListeners.remove(listener);
    }

    @Nullable
    public ListenableFuture<Breakpoint> resolveBreakpoint(final @NotNull String id) {
        if (this.myState == null) {
            return null;
        }
        final Debugger client = CloudDebuggerClient.getCloudDebuggerClient(this.myState);
        if (client == null) {
            LOG.warn("no client available attempting to resolveBreakpointAsync");
            Messages.showErrorDialog((Project)this.myState.getProject(), (String)GctBundle.getString("clouddebug.bad_login_message", new Object[0]), (String)GctBundle.getString("clouddebug.errortitle", new Object[0]));
            return null;
        }
        ImmutableList<Breakpoint> currentList = this.myState.getCurrentServerBreakpointList();
        final SettableFuture future = SettableFuture.create();
        final Ref resultingBreakpointRef = new Ref();
        for (Breakpoint serverBreakpointCandidate : currentList) {
            if (!serverBreakpointCandidate.getId().equals(id)) continue;
            resultingBreakpointRef.set((Object)serverBreakpointCandidate);
            break;
        }
        if (!resultingBreakpointRef.isNull()) {
            if (((Breakpoint)resultingBreakpointRef.get()).getIsFinalState() != Boolean.TRUE) {
                future.set(resultingBreakpointRef.get());
                return future;
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GetBreakpointResponse response = (GetBreakpointResponse)client.debuggees().breakpoints().get(CloudDebugProcessStateController.this.myState.getDebuggeeId(), id).execute();
                        Breakpoint result = response.getBreakpoint();
                        if (result != null) {
                            resultingBreakpointRef.set((Object)result);
                            CloudDebugProcessStateController.this.myFullFinalBreakpoints.put(id, result);
                            future.set(resultingBreakpointRef.get());
                        }
                    }
                    catch (IOException e) {
                        LOG.error("IOException hydrating a final snapshot ", (Throwable)e);
                        future.setException((Throwable)e);
                    }
                }
            });
            return future;
        }
        LOG.warn("could not resolve breakpoint " + id);
        return null;
    }

    String setBreakpoint(@NotNull Breakpoint serverBreakpoint, @Nullable BreakpointErrorHandler errorHandler) {
        if (this.myState == null) {
            return null;
        }
        Debugger client = CloudDebuggerClient.getCloudDebuggerClient(this.myState);
        if (client == null) {
            LOG.warn("no client available attempting to setBreakpoint");
            Messages.showErrorDialog((Project)this.myState.getProject(), (String)GctBundle.getString("clouddebug.bad_login_message", new Object[0]), (String)GctBundle.getString("clouddebug.errortitle", new Object[0]));
            return null;
        }
        try {
            ImmutableList<Breakpoint> currentList = this.myState.getCurrentServerBreakpointList();
            SourceLocation location = serverBreakpoint.getLocation();
            for (Breakpoint serverBp : currentList) {
                if (serverBp.getIsFinalState() == Boolean.TRUE || serverBp.getLocation().getLine() == null || !serverBp.getLocation().getLine().equals(location.getLine()) || Strings.isNullOrEmpty((String)serverBp.getLocation().getPath()) || !serverBp.getLocation().getPath().equals(location.getPath())) continue;
                this.deleteBreakpoint(serverBp.getId());
            }
            SetBreakpointResponse addResponse = (SetBreakpointResponse)client.debuggees().breakpoints().set(this.myState.getDebuggeeId(), serverBreakpoint).execute();
            if (addResponse != null && addResponse.getBreakpoint() != null) {
                Breakpoint result = addResponse.getBreakpoint();
                if (result.getStatus() != null && result.getStatus().getIsError() == Boolean.TRUE && errorHandler != null && result.getStatus().getDescription() != null) {
                    errorHandler.handleError(BreakpointUtil.getUserErrorMessage(result.getStatus()));
                }
                return addResponse.getBreakpoint().getId();
            }
        }
        catch (IOException ex) {
            LOG.error("exception setting a breakpoint", (Throwable)ex);
        }
        return null;
    }

    public void startBackgroundListening() {
        assert (this.myState != null);
        if (this.myListBreakpointsJob == null) {
            this.myListBreakpointsJob = new Timer("list breakpoints");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CloudDebugProcessStateController.this.waitForChanges();
                    Timer timer = CloudDebugProcessStateController.this.myListBreakpointsJob;
                    if (timer != null) {
                        try {
                            timer.schedule((TimerTask)new RunnableTimerTask(this), 500L);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.myListBreakpointsJob.schedule((TimerTask)new RunnableTimerTask(runnable), 2000L);
        }
    }

    public void stopBackgroundListening() {
        if (this.myListBreakpointsJob != null) {
            this.myListBreakpointsJob.cancel();
        }
        this.myListBreakpointsJob = null;
    }

    void waitForChanges() {
        List<Breakpoint> currentList;
        if (this.myState == null) {
            LOG.error("no state available attempting to checkForChanges");
            return;
        }
        Debugger client = CloudDebuggerClient.getCloudDebuggerClient(this.myState);
        if (client == null) {
            LOG.info("no client available attempting to checkForChanges");
            return;
        }
        String tokenToSend = this.myState.getWaitToken();
        try {
            currentList = CloudDebugProcessStateController.queryServerForBreakpoints(this.myState, client, tokenToSend);
        }
        catch (SocketTimeoutException ex) {
            return;
        }
        catch (GoogleJsonResponseException ex) {
            if (ex.getDetails().getCode() == 409) {
                try {
                    currentList = CloudDebugProcessStateController.queryServerForBreakpoints(this.myState, client, tokenToSend);
                }
                catch (IOException ioException) {
                    LOG.warn("exception listing breakpoints", (Throwable)ioException);
                    return;
                }
            }
            LOG.warn("exception listing breakpoints", (Throwable)ex);
            return;
        }
        catch (IOException ex) {
            LOG.warn("exception listing breakpoints", (Throwable)ex);
            return;
        }
        if (!Strings.isNullOrEmpty((String)tokenToSend)) {
            this.pruneBreakpointCache(currentList);
            this.fireBreakpointsChanged();
        }
    }

    private static List<Breakpoint> queryServerForBreakpoints(CloudDebugProcessState state, Debugger client, String tokenToSend) throws IOException {
        List currentList = null;
        String responseWaitToken = tokenToSend;
        while (tokenToSend == null || tokenToSend.equals(responseWaitToken)) {
            ListBreakpointsResponse response = (ListBreakpointsResponse)client.debuggees().breakpoints().list(state.getDebuggeeId()).setIncludeInactive(Boolean.TRUE).setAction("CAPTURE").setStripResults(Boolean.TRUE).setWaitToken(CloudDebugConfigType.useWaitToken() ? tokenToSend : null).execute();
            currentList = response.getBreakpoints();
            responseWaitToken = response.getWaitToken();
            if (tokenToSend == null) break;
            if (CloudDebugConfigType.useWaitToken() || !tokenToSend.equals(responseWaitToken)) continue;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return null;
            }
        }
        state.setWaitToken(responseWaitToken);
        if (currentList != null) {
            Collections.sort(currentList, BreakpointComparer.getDefaultInstance());
        }
        state.setCurrentServerBreakpointList((ImmutableList<Breakpoint>)(currentList != null ? ContainerUtil.immutableList(currentList) : ContainerUtil.immutableList(new ArrayList())));
        return currentList;
    }

    private void pruneBreakpointCache(List<Breakpoint> currentList) {
        HashSet toRemoveSet = new HashSet();
        toRemoveSet.addAll((Collection)this.myFullFinalBreakpoints.keySet());
        if (!toRemoveSet.isEmpty() && currentList != null) {
            for (Breakpoint bp : currentList) {
                toRemoveSet.remove((Object)bp.getId());
            }
        }
        for (String idToRemove : toRemoveSet) {
            this.myFullFinalBreakpoints.remove(idToRemove);
        }
    }

    static class RunnableTimerTask
    extends TimerTask {
        private final Runnable myRunnable;

        public RunnableTimerTask(@NotNull Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            this.myRunnable.run();
        }
    }

    public static interface BreakpointErrorHandler {
        public void handleError(String var1);
    }
}

