/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.util.GctBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import icons.GoogleCloudToolsIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CloudDebugConfigType
implements ConfigurationType {
    public static final String GCT_DEBUGGER_ENABLE = "enable.gct.debugger";
    public static final String GCT_DEBUGGER_USETOKEN = "enable.gct.debugger.token";
    private final ConfigurationFactory myFactory = new MyConfigurationFactory(this);

    public static boolean isFeatureEnabled() {
        return Boolean.getBoolean(GCT_DEBUGGER_ENABLE);
    }

    public static boolean useWaitToken() {
        return !Boolean.getBoolean(GCT_DEBUGGER_USETOKEN);
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public String getConfigurationTypeDescription() {
        return GctBundle.getString("clouddebug.googleclouddebugger", new Object[0]);
    }

    public String getDisplayName() {
        return GctBundle.getString("clouddebug.text", new Object[0]);
    }

    public Icon getIcon() {
        return GoogleCloudToolsIcons.CLOUD;
    }

    @NotNull
    public String getId() {
        return "GCPDebug";
    }

    private static class MyConfigurationFactory
    extends ConfigurationFactory {
        MyConfigurationFactory(@NotNull CloudDebugConfigType type) {
            super((ConfigurationType)type);
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            task.setEnabled(false);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new CloudDebugRunConfiguration(project, this);
        }
    }
}

