/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.process.ArgWriter;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.streams.EncodedStream;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.GradleWorkerMain;
import org.gradle.process.internal.worker.child.ActionExecutionWorker;
import org.gradle.process.internal.worker.child.BootstrapSecurityManager;
import org.gradle.process.internal.worker.child.WorkerFactory;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInSystemClassLoaderWorkerFactory
implements WorkerFactory {
    private final ClassPathRegistry classPathRegistry;
    private final TemporaryFileProvider temporaryFileProvider;

    public ApplicationClassesInSystemClassLoaderWorkerFactory(ClassPathRegistry classPathRegistry, TemporaryFileProvider temporaryFileProvider) {
        this.classPathRegistry = classPathRegistry;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    @Override
    public void prepareJavaCommand(Object workerId, String displayName, DefaultWorkerProcessBuilder processBuilder, List<URL> implementationClassPath, Address serverAddress, JavaExecHandleBuilder execSpec) {
        boolean useOptionsFile;
        Set<File> applicationClasspath = processBuilder.getApplicationClasspath();
        LogLevel logLevel = processBuilder.getLogLevel();
        Set<String> sharedPackages = processBuilder.getSharedPackages();
        Object requestedSecurityManager = execSpec.getSystemProperties().get("java.security.manager");
        ClassPath workerMainClassPath = this.classPathRegistry.getClassPath("WORKER_MAIN");
        execSpec.setMain("worker." + GradleWorkerMain.class.getName());
        boolean bl = useOptionsFile = Jvm.current().getJavaVersion().isJava9Compatible() && execSpec.getExecutable().equals(Jvm.current().getJavaExecutable().getPath());
        if (useOptionsFile) {
            File optionsFile = this.temporaryFileProvider.createTemporaryFile("gradle-worker-classpath", "txt", new String[0]);
            List<String> jvmArgs = this.writeOptionsFile(workerMainClassPath.getAsFiles(), applicationClasspath, optionsFile);
            execSpec.jvmArgs(jvmArgs);
        } else {
            execSpec.classpath(workerMainClassPath.getAsFiles());
            execSpec.systemProperty("java.security.manager", "worker." + BootstrapSecurityManager.class.getName());
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            DataOutputStream outstr = new DataOutputStream(new EncodedStream.EncodedOutput(bytes));
            if (!useOptionsFile) {
                outstr.writeInt(applicationClasspath.size());
                for (File file : applicationClasspath) {
                    outstr.writeUTF(file.getAbsolutePath());
                }
                outstr.writeUTF(requestedSecurityManager == null ? "" : requestedSecurityManager.toString());
            }
            outstr.writeInt(sharedPackages.size());
            for (String str : sharedPackages) {
                outstr.writeUTF(str);
            }
            outstr.writeInt(implementationClassPath.size());
            for (URL entry : implementationClassPath) {
                outstr.writeUTF(entry.toString());
            }
            OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)outstr);
            encoder.writeSmallInt(logLevel.ordinal());
            new MultiChoiceAddressSerializer().write((Encoder)encoder, (MultiChoiceAddress)serverAddress);
            ActionExecutionWorker worker = new ActionExecutionWorker(processBuilder.getWorker(), workerId, displayName, processBuilder.getGradleUserHomeDir());
            byte[] serializedWorker = GUtil.serialize((Object)worker);
            encoder.writeBinary(serializedWorker);
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        byte[] encodedConfig = bytes.toByteArray();
        execSpec.setStandardInput(new ByteArrayInputStream(encodedConfig));
    }

    private List<String> writeOptionsFile(Collection<File> workerMainClassPath, Collection<File> applicationClasspath, File optionsFile) {
        ArrayList<File> classpath = new ArrayList<File>(workerMainClassPath.size() + applicationClasspath.size());
        classpath.addAll(workerMainClassPath);
        classpath.addAll(applicationClasspath);
        return (List)ArgWriter.argsFileGenerator((File)optionsFile, (Transformer)ArgWriter.unixStyleFactory()).transform(Arrays.asList("-cp", Joiner.on((String)File.pathSeparator).join(classpath)));
    }
}

