/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancedTypeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancementResult;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.MutabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.Result;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    @NotNull
    public static final KotlinType enhance(KotlinType $receiver, @NotNull Function1<? super Integer, JavaTypeQualifiers> qualifiers) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(qualifiers, "qualifiers");
        return TypeEnhancementKt.enhancePossiblyFlexible($receiver, qualifiers, 0).getType();
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhancePossiblyFlexible(KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index) {
        Result result;
        if ($receiver.isError()) {
            return new Result($receiver, 1);
        }
        if (FlexibleTypesKt.isFlexible($receiver)) {
            Unit unit;
            Flexibility receiver$iv = FlexibleTypesKt.flexibility($receiver);
            Flexibility $receiver2 = receiver$iv;
            Result lowerResult = TypeEnhancementKt.enhanceInflexible($receiver2.getLowerBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_LOWER);
            Result upperResult = TypeEnhancementKt.enhanceInflexible($receiver2.getUpperBound(), qualifiers, index, TypeComponentPosition.FLEXIBLE_UPPER);
            boolean bl = lowerResult.getSubtreeSize() == upperResult.getSubtreeSize();
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Different tree sizes of bounds: " + ("lower = (" + $receiver2.getLowerBound() + ", " + lowerResult.getSubtreeSize() + "), ") + ("upper = (" + $receiver2.getUpperBound() + ", " + upperResult.getSubtreeSize() + ")");
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            result = new Result(DelegatingFlexibleType.Companion.create(lowerResult.getType(), upperResult.getType(), $receiver2.getExtraCapabilities()), lowerResult.getSubtreeSize());
        } else {
            result = TypeEnhancementKt.enhanceInflexible($receiver, qualifiers, index, TypeComponentPosition.INFLEXIBLE);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final Result enhanceInflexible(KotlinType $receiver, Function1<? super Integer, JavaTypeQualifiers> qualifiers, int index, TypeComponentPosition position) {
        void enhancedNullability;
        void enhancedNullabilityAnnotations;
        void enhancedMutabilityAnnotations;
        void globalArgIndex;
        EnhancementResult<Boolean> destination$iv$iv;
        Annotations $receiver$iv$iv;
        void $receiver$iv22;
        void enhancedClassifier;
        boolean shouldEnhance = TypeEnhancementKt.shouldEnhance(position);
        if (!shouldEnhance && $receiver.getArguments().isEmpty()) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return new Result($receiver, 1);
        }
        ClassifierDescriptor originalClass = classifierDescriptor;
        JavaTypeQualifiers effectiveQualifiers = qualifiers.invoke((Integer)index);
        EnhancementResult<ClassifierDescriptor> enhancementResult = TypeEnhancementKt.enhanceMutability(originalClass, effectiveQualifiers, position);
        ClassifierDescriptor classifierDescriptor2 = enhancementResult.component1();
        Annotations annotations2 = enhancementResult.component2();
        enhancementResult = null;
        TypeConstructor typeConstructor2 = enhancedClassifier.getTypeConstructor();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = index + 1;
        Iterable iterable = $receiver.getArguments();
        void var12_13 = $receiver$iv22;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv22, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void localArgIndex;
            void arg;
            int n = index$iv$iv++;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            void var19_21 = destination$iv$iv;
            if (arg.isStarProjection()) {
                int n3 = globalArgIndex.element++;
                typeProjection = TypeUtils.makeStarProjection(enhancedClassifier.getTypeConstructor().getParameters().get((int)localArgIndex));
            } else {
                void enhancedType;
                void subtreeSize;
                Result result = TypeEnhancementKt.enhancePossiblyFlexible(arg.getType(), qualifiers, globalArgIndex.element);
                KotlinType kotlinType = result.component1();
                int n4 = result.component2();
                result = null;
                globalArgIndex.element += subtreeSize;
                Variance variance = arg.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "arg.projectionKind");
                typeProjection = TypeUtilsKt.createProjection((KotlinType)enhancedType, variance, typeConstructor2.getParameters().get((int)localArgIndex));
            }
            TypeProjection typeProjection3 = typeProjection;
            var19_21.add(typeProjection3);
        }
        List enhancedArguments = (List)((Object)destination$iv$iv);
        destination$iv$iv = TypeEnhancementKt.getEnhancedNullability($receiver, effectiveQualifiers, position);
        boolean $receiver$iv22 = destination$iv$iv.component1();
        $receiver$iv$iv = destination$iv$iv.component2();
        destination$iv$iv = null;
        Annotations newAnnotations = TypeEnhancementKt.compositeAnnotationsOrSingle(CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf($receiver.getAnnotations(), enhancedMutabilityAnnotations, enhancedNullabilityAnnotations)));
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
        TypeSubstitution newSubstitution = TypeSubstitutionKt.computeNewSubstitution($receiver, typeConstructor3, enhancedArguments);
        TypeConstructor typeConstructor4 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "typeConstructor");
        MemberScope memberScope2 = enhancedClassifier instanceof ClassDescriptor ? ((ClassDescriptor)enhancedClassifier).getMemberScope(newSubstitution) : enhancedClassifier.getDefaultType().getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "if (enhancedClassifier i\u2026ltType().getMemberScope()");
        TypeCapabilities typeCapabilities2 = $receiver.getCapabilities();
        Intrinsics.checkExpressionValueIsNotNull(typeCapabilities2, "capabilities");
        KotlinTypeImpl enhancedType = KotlinTypeImpl.Companion.create(newAnnotations, typeConstructor4, (boolean)enhancedNullability, enhancedArguments, newSubstitution, memberScope2, typeCapabilities2);
        return new Result(enhancedType, globalArgIndex.element - index);
    }

    private static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> $receiver) {
        Annotations annotations2;
        switch ($receiver.size()) {
            case 0: {
                String message$iv = "At least one Annotations object expected";
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
            case 1: {
                annotations2 = CollectionsKt.single($receiver);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList((Collection)$receiver));
            }
        }
        return annotations2;
    }

    private static final boolean shouldEnhance(TypeComponentPosition $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)TypeComponentPosition.INFLEXIBLE) ^ true;
    }

    private static final <T> EnhancementResult<T> noChange(T $receiver) {
        return new EnhancementResult<T>($receiver, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $receiver) {
        return new EnhancementResult<T>($receiver, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(ClassifierDescriptor $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        if (!($receiver instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($receiver);
        }
        JavaToKotlinClassMap mapping = JavaToKotlinClassMap.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.READ_ONLY)) {
            if (Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_LOWER) && mapping.isMutable((ClassDescriptor)$receiver)) {
                return TypeEnhancementKt.enhancedMutability(mapping.convertMutableToReadOnly((ClassDescriptor)$receiver));
            }
        } else if (Intrinsics.areEqual((Object)mutabilityQualifier, (Object)MutabilityQualifier.MUTABLE) && Intrinsics.areEqual((Object)position, (Object)TypeComponentPosition.FLEXIBLE_UPPER) && mapping.isReadOnly((ClassDescriptor)$receiver)) {
            return TypeEnhancementKt.enhancedMutability(mapping.convertReadOnlyToMutable((ClassDescriptor)$receiver));
        }
        return TypeEnhancementKt.noChange($receiver);
    }

    private static final EnhancementResult<Boolean> getEnhancedNullability(KotlinType $receiver, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($receiver.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        return Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NULLABLE) ? TypeEnhancementKt.enhancedNullability(true) : (Intrinsics.areEqual((Object)nullabilityQualifier, (Object)NullabilityQualifier.NOT_NULL) ? TypeEnhancementKt.enhancedNullability(false) : TypeEnhancementKt.noChange($receiver.isMarkedNullable()));
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }
}

