/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorDescriptorImpl
extends FunctionDescriptorImpl
implements ConstructorDescriptor {
    protected final boolean isPrimary;
    private static final Name NAME = Name.special("<init>");

    protected ConstructorDescriptorImpl(@NotNull ClassDescriptor containingDeclaration, @Nullable ConstructorDescriptor original, @NotNull Annotations annotations2, boolean isPrimary, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, original, annotations2, NAME, kind, source);
        this.isPrimary = isPrimary;
    }

    @NotNull
    public static ConstructorDescriptorImpl create(@NotNull ClassDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean isPrimary, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "create"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "create"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "create"));
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = new ConstructorDescriptorImpl(containingDeclaration, null, annotations2, isPrimary, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "create"));
        }
        return constructorDescriptorImpl;
    }

    public ConstructorDescriptorImpl initialize(@NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull Visibility visibility) {
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "initialize"));
        }
        super.initialize(null, this.calculateDispatchReceiverParameter(), this.getContainingDeclaration().getDeclaredTypeParameters(), unsubstitutedValueParameters, null, Modality.FINAL, visibility);
        return this;
    }

    @Nullable
    private ReceiverParameterDescriptor calculateDispatchReceiverParameter() {
        DeclarationDescriptor classContainer;
        ClassDescriptor classDescriptor = this.getContainingDeclaration();
        if (classDescriptor.isInner() && (classContainer = classDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
            return ((ClassDescriptor)classContainer).getThisAsReceiverParameter();
        }
        return null;
    }

    @Override
    @NotNull
    public ClassDescriptor getContainingDeclaration() {
        ClassDescriptor classDescriptor = (ClassDescriptor)super.getContainingDeclaration();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "getContainingDeclaration"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public ConstructorDescriptor getOriginal() {
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)super.getOriginal();
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "getOriginal"));
        }
        return constructorDescriptor;
    }

    @Override
    @NotNull
    public ConstructorDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "substitute"));
        }
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)super.substitute(originalSubstitutor);
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "substitute"));
        }
        return constructorDescriptor;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitConstructorDescriptor(this, data);
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    @NotNull
    public Collection<? extends FunctionDescriptor> getOverriddenDescriptors() {
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overriddenFunction) {
        if (overriddenFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenFunction", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "addOverriddenDescriptor"));
        }
        throw new UnsupportedOperationException("Constructors cannot override anything");
    }

    @Override
    @NotNull
    protected ConstructorDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName, boolean preserveSource) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        if (kind != CallableMemberDescriptor.Kind.DECLARATION && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            throw new IllegalStateException("Attempt at creating a constructor that is not a declaration: \ncopy from: " + this + "\n" + "newOwner: " + newOwner + "\n" + "kind: " + (Object)((Object)kind));
        }
        assert (newName == null) : "Attempt to rename constructor: " + this;
        ConstructorDescriptorImpl constructorDescriptorImpl = new ConstructorDescriptorImpl((ClassDescriptor)newOwner, this, this.getAnnotations(), this.isPrimary, CallableMemberDescriptor.Kind.DECLARATION, this.getSourceToUseForCopy(preserveSource, original));
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "createSubstitutedCopy"));
        }
        return constructorDescriptorImpl;
    }

    @Override
    @NotNull
    public ConstructorDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)this.doSubstitute(this.newCopyBuilder().setOwner(newOwner).setModality(modality).setVisibility(visibility).setKind(kind).setCopyOverrides(copyOverrides));
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/descriptors/impl/ConstructorDescriptorImpl", "copy"));
        }
        return constructorDescriptor;
    }
}

