/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.mantis.MantisRepository;
import com.intellij.tasks.mantis.model.IssueData;
import com.intellij.tasks.mantis.model.IssueHeaderData;
import com.intellij.tasks.mantis.model.IssueNoteData;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MantisTask
extends Task {
    private final String myId;
    private final String mySummary;
    private final String myDescription;
    private final Date myUpdated;
    private final Date myCreated;
    private final boolean myClosed;
    private String myProjectName;
    private MantisRepository myRepository;
    private final Comment[] myComments;

    public MantisTask(@NotNull IssueData data, @NotNull MantisRepository repository) {
        this.myRepository = repository;
        this.myId = String.valueOf(data.getId());
        this.mySummary = data.getSummary();
        this.myDescription = data.getDescription();
        this.myProjectName = data.getProject() == null ? null : data.getProject().getName();
        this.myClosed = data.getStatus().getId().intValue() >= 90;
        this.myCreated = data.getDate_submitted().getTime();
        this.myUpdated = data.getLast_updated().getTime();
        this.myComments = data.getNotes() == null ? Comment.EMPTY_ARRAY : (Comment[])ContainerUtil.map2Array((Object[])data.getNotes(), Comment.class, (Function)new Function<IssueNoteData, Comment>(){

            public Comment fun(final IssueNoteData data) {
                return new Comment(){

                    public String getText() {
                        return data.getText();
                    }

                    @Nullable
                    public String getAuthor() {
                        return data.getReporter().getName();
                    }

                    @Nullable
                    public Date getDate() {
                        return data.getDate_submitted().getTime();
                    }
                };
            }
        });
    }

    public MantisTask(@NotNull IssueHeaderData header, @NotNull MantisRepository repository) {
        this.myRepository = repository;
        this.myId = String.valueOf(header.getId());
        this.mySummary = header.getSummary();
        this.myProjectName = null;
        this.myClosed = header.getStatus().intValue() >= 90;
        this.myDescription = null;
        this.myCreated = null;
        this.myUpdated = header.getLast_updated().getTime();
        this.myComments = Comment.EMPTY_ARRAY;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getSummary() {
        return this.mySummary;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Comment[] getComments() {
        return this.myComments;
    }

    @NotNull
    public Icon getIcon() {
        return TasksIcons.Mantis;
    }

    @NotNull
    public TaskType getType() {
        return TaskType.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Nullable
    public Date getCreated() {
        return this.myCreated;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        return this.myRepository.getUrl() + "/view.php?id=" + this.getId();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @Nullable
    public String getProject() {
        return this.myProjectName;
    }

    @NotNull
    public String getNumber() {
        return this.getId();
    }
}

