/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl.httpclient;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NewBaseRepositoryImpl
extends BaseRepository {
    private static final AuthScope BASIC_AUTH_SCOPE = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic");
    private static final HttpRequestInterceptor PREEMPTIVE_BASIC_AUTH = new PreemptiveBasicAuthInterceptor();

    protected NewBaseRepositoryImpl() {
    }

    protected NewBaseRepositoryImpl(TaskRepositoryType type) {
        super(type);
    }

    protected NewBaseRepositoryImpl(BaseRepository other) {
        super(other);
    }

    @NotNull
    protected HttpClient getHttpClient() {
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(this.createRequestConfig()).setSslcontext(CertificateManager.getInstance().getSslContext()).setHostnameVerifier((X509HostnameVerifier)CertificateManager.HOSTNAME_VERIFIER).setDefaultCredentialsProvider(this.createCredentialsProvider()).addInterceptorFirst(PREEMPTIVE_BASIC_AUTH).addInterceptorLast(this.createRequestInterceptor());
        return builder.build();
    }

    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return null;
    }

    @NotNull
    private CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (this.isUseHttpAuthentication()) {
            provider.setCredentials(BASIC_AUTH_SCOPE, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        }
        if (this.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsForUrlIfEnabled((CredentialsProvider)provider, (String)this.getUrl());
        }
        return provider;
    }

    @NotNull
    protected RequestConfig createRequestConfig() {
        TaskSettings tasksSettings = TaskSettings.getInstance();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(tasksSettings.CONNECTION_TIMEOUT);
        if (this.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)builder, (String)this.getUrl());
        }
        return builder.build();
    }

    @NotNull
    public String getRestApiPathPrefix() {
        return "";
    }

    @NotNull
    public String getRestApiUrl(Object ... parts) {
        StringBuilder builder = new StringBuilder(this.getUrl());
        builder.append(this.getRestApiPathPrefix());
        if (builder.charAt(builder.length() - 1) == '/') {
            builder.deleteCharAt(builder.length() - 1);
        }
        for (Object part : parts) {
            if (part == null || part.equals("")) continue;
            builder.append('/').append(TaskUtil.encodeUrl(String.valueOf(part)));
        }
        return builder.toString();
    }

    public class HttpTestConnection
    extends TaskRepository.CancellableConnection {
        protected volatile HttpRequestBase myCurrentRequest;

        public HttpTestConnection(HttpRequestBase request) {
            this.myCurrentRequest = request;
        }

        protected void doTest() throws Exception {
            block2: {
                try {
                    this.test();
                }
                catch (IOException e) {
                    if (this.myCurrentRequest.isAborted()) break block2;
                    throw e;
                }
            }
        }

        protected void test() throws Exception {
            HttpResponse response = NewBaseRepositoryImpl.this.getHttpClient().execute((HttpUriRequest)this.myCurrentRequest);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() != 200) {
                throw RequestFailedException.forStatusCode(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        }

        public void cancel() {
            this.myCurrentRequest.abort();
        }
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveBasicAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            Credentials proxyCredentials;
            HttpHost proxyHost;
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(BASIC_AUTH_SCOPE);
            if (credentials != null) {
                request.addHeader(new BasicScheme(CharsetToolkit.UTF8_CHARSET).authenticate(credentials, request, context));
            }
            if ((proxyHost = ((HttpRoute)context.getAttribute("http.route")).getProxyHost()) != null && (proxyCredentials = provider.getCredentials(new AuthScope(proxyHost))) != null) {
                request.addHeader(BasicScheme.authenticate((Credentials)proxyCredentials, (String)"UTF-8", (boolean)true));
            }
        }
    }
}

