/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.bugzilla.BugzillaRepository;
import icons.TasksIcons;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugzillaTask
extends Task {
    private final Hashtable<String, Object> myResponse;
    private final BugzillaRepository myRepository;

    public BugzillaTask(@NotNull Hashtable<String, Object> xmlRpcResponse, @NotNull BugzillaRepository repository) {
        this.myResponse = xmlRpcResponse;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        return String.valueOf(this.myResponse.get("id"));
    }

    @NotNull
    public String getSummary() {
        return (String)this.myResponse.get("summary");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Comment[] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        return TasksIcons.Bugzilla;
    }

    @NotNull
    public TaskType getType() {
        String severity = (String)this.myResponse.get("severity");
        return severity.equalsIgnoreCase("enhancement") ? TaskType.FEATURE : TaskType.BUG;
    }

    @Nullable
    public TaskState getState() {
        String status = (String)this.myResponse.get("status");
        if (status.equals("IN_PROGRESS")) {
            return TaskState.IN_PROGRESS;
        }
        if (status.equals("CONFIRMED")) {
            return TaskState.OPEN;
        }
        if (status.equals("UNCONFIRMED")) {
            return TaskState.SUBMITTED;
        }
        if (status.equals("RESOLVED")) {
            return TaskState.RESOLVED;
        }
        return TaskState.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return (Date)this.myResponse.get("last_change_time");
    }

    @Nullable
    public Date getCreated() {
        return (Date)this.myResponse.get("creation_time");
    }

    public boolean isClosed() {
        return (Boolean)this.myResponse.get("is_open") == false;
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        String repositoryUrl = this.myRepository.getUrl();
        repositoryUrl = StringUtil.trimEnd((String)repositoryUrl, (String)"xmlrpc.cgi");
        return repositoryUrl + "/show_bug.cgi?id=" + this.getId();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

