/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskStateCombo;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseTaskDialog
extends DialogWrapper {
    private static final String UPDATE_STATE_ENABLED = "tasks.close.task.update.state.enabled";
    private final Project myProject;
    private final LocalTask myTask;
    private JCheckBox myCommitChanges;
    private JPanel myPanel;
    private JLabel myTaskLabel;
    private JBCheckBox myMergeBranches;
    private JPanel myVcsPanel;
    private TaskStateCombo myStateCombo;
    private JBCheckBox myUpdateState;
    private final TaskManagerImpl myTaskManager;

    public CloseTaskDialog(Project project, LocalTask task) {
        super(project, false);
        this.myProject = project;
        this.myTask = task;
        this.$$$setupUI$$$();
        this.setTitle("Close Task");
        this.myTaskLabel.setText(TaskUtil.getTrimmedSummary((Task)task));
        this.myTaskLabel.setIcon(task.getIcon());
        if (!TaskStateCombo.stateUpdatesSupportedFor((Task)task)) {
            this.myUpdateState.setVisible(false);
            this.myStateCombo.setVisible(false);
        }
        boolean stateUpdatesEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(UPDATE_STATE_ENABLED);
        this.myUpdateState.setSelected(stateUpdatesEnabled);
        this.myStateCombo.setEnabled(stateUpdatesEnabled);
        this.myUpdateState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = CloseTaskDialog.this.myUpdateState.isSelected();
                CloseTaskDialog.this.myStateCombo.setEnabled(selected);
                PropertiesComponent.getInstance((Project)CloseTaskDialog.this.myProject).setValue(CloseTaskDialog.UPDATE_STATE_ENABLED, String.valueOf(selected));
                if (selected) {
                    CloseTaskDialog.this.myStateCombo.scheduleUpdateOnce();
                }
            }
        });
        this.myTaskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        if (this.myTaskManager.isVcsEnabled()) {
            boolean hasChanges = !task.getChangeLists().isEmpty();
            this.myCommitChanges.setEnabled(hasChanges);
            this.myCommitChanges.setSelected(hasChanges && this.myTaskManager.getState().commitChanges);
            if (this.myTaskManager.getActiveVcs().getType() == VcsType.distributed) {
                boolean enabled = !task.getBranches(true).isEmpty() && !task.getBranches(false).isEmpty();
                this.myMergeBranches.setEnabled(enabled);
                this.myMergeBranches.setSelected(enabled && this.myTaskManager.getState().mergeBranch);
            } else {
                this.myMergeBranches.setVisible(false);
            }
        } else {
            this.myVcsPanel.setVisible(false);
        }
        this.myStateCombo.showHintLabel(false);
        if (this.myUpdateState.isSelected()) {
            this.myStateCombo.scheduleUpdateOnce();
        }
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myStateCombo.isVisible() && this.myUpdateState.isSelected() ? this.myStateCombo.getComboBox() : null;
    }

    @Nullable
    CustomTaskState getCloseIssueState() {
        return this.myUpdateState.isSelected() ? this.myStateCombo.getSelectedState() : null;
    }

    boolean isCommitChanges() {
        return this.myCommitChanges.isSelected();
    }

    boolean isMergeBranch() {
        return this.myMergeBranches.isSelected();
    }

    protected void doOKAction() {
        if (this.myCommitChanges.isEnabled()) {
            this.myTaskManager.getState().commitChanges = this.isCommitChanges();
        }
        if (this.myMergeBranches.isEnabled()) {
            this.myTaskManager.getState().mergeBranch = this.isMergeBranch();
        }
        super.doOKAction();
    }

    private void createUIComponents() {
        this.myStateCombo = new TaskStateCombo(this.myProject, (Task)this.myTask){

            @Override
            @Nullable
            protected CustomTaskState getPreferredState(@NotNull TaskRepository repository, @NotNull Collection<CustomTaskState> available) {
                return repository.getPreferredCloseTaskState();
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Close task:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(35, 14), null));
        this.myVcsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"VCS operations", (int)0, (int)0, null, null));
        this.myCommitChanges = jCheckBox = new JCheckBox();
        jCheckBox.setText("Commit changes");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMergeBranches = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Merge branche(s)");
        jBCheckBox2.setMnemonic('M');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTaskLabel = jLabel = new JLabel();
        jLabel.setText("Task description");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TaskStateCombo taskStateCombo = this.myStateCombo;
        jPanel3.add((Component)taskStateCombo, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myUpdateState = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Update issue state");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

