/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.structure;

import android.support.constraint.solver.widgets.Animator;
import android.support.constraint.solver.widgets.ConnectionCandidate;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintTableLayout;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class WidgetsScene {
    private HashMap<Object, ConstraintWidget> mWidgets = new HashMap();
    private WidgetContainer mRoot;
    private Selection mSelection;

    public void clear() {
        this.mRoot = null;
        if (this.mSelection != null) {
            this.mSelection.clear();
        }
        this.mWidgets.clear();
    }

    public void clearAllConstraints() {
        for (ConstraintWidget widget : this.getWidgets()) {
            widget.resetAllConstraints();
        }
        this.mSelection.clear();
        this.mSelection.setSelectedAnchor(null);
    }

    public Collection<ConstraintWidget> getWidgets() {
        return this.mWidgets.values();
    }

    public void setWidgets(HashMap<Object, ConstraintWidget> widgets) {
        this.mWidgets = widgets;
        for (ConstraintWidget widget : this.mWidgets.values()) {
            if (!widget.isRoot()) continue;
            this.mRoot = (WidgetContainer)widget;
        }
    }

    public void createGroupFromWidgets(ArrayList<ConstraintWidget> widgets) {
        ConstraintWidgetContainer container = new ConstraintWidgetContainer();
        container.setCompanionWidget(WidgetCompanion.create(container));
        this.createContainerFromWidgets(widgets, container, this.createContainerName("group"));
    }

    public void transformTableToContainer(ConstraintTableLayout table) {
        ConstraintWidgetContainer container = new ConstraintWidgetContainer();
        container.setDebugName(this.createContainerName("container"));
        this.transformContainerToContainer(table, container);
    }

    public void removeContainer(ConstraintWidgetContainer container) {
        ConstraintWidgetContainer parent = (ConstraintWidgetContainer)container.getParent();
        if (parent == null) {
            return;
        }
        for (ConstraintWidget widget : this.mWidgets.values()) {
            widget.disconnectWidget(container);
        }
        ArrayList<ConstraintWidget> children = new ArrayList<ConstraintWidget>(container.getChildren());
        for (ConstraintWidget child : children) {
            parent.add(child);
            child.resetAnchors();
            child.setX(child.getX() + container.getX());
            child.setY(child.getY() + container.getY());
        }
        parent.remove(container);
        this.mWidgets.remove(WidgetsScene.getTag(container));
    }

    private static Object getTag(ConstraintWidget widget) {
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        Object tag = companion.getWidgetTag();
        if (tag != null) {
            return tag;
        }
        return widget.getDebugName();
    }

    public void removeWidget(ConstraintWidget widget) {
        if (widget == null) {
            return;
        }
        if (widget instanceof ConstraintWidgetContainer) {
            ConstraintWidgetContainer container = (ConstraintWidgetContainer)widget;
            ArrayList<ConstraintWidget> children = new ArrayList<ConstraintWidget>(container.getChildren());
            for (ConstraintWidget w : children) {
                this.removeWidget(w);
            }
        }
        for (ConstraintWidget w : this.mWidgets.values()) {
            w.disconnectWidget(widget);
        }
        WidgetContainer parent = (WidgetContainer)widget.getParent();
        if (parent != null) {
            parent.remove(widget);
        }
        this.mWidgets.remove(WidgetsScene.getTag(widget));
        if (this.mRoot == widget) {
            this.mRoot = null;
        }
    }

    public void flattenHierarchy(ConstraintWidgetContainer root) {
        ArrayList<ConstraintWidgetContainer> containers = WidgetsScene.gatherContainers(root);
        while (containers.size() > 0) {
            for (ConstraintWidgetContainer container : containers) {
                this.removeContainer(container);
            }
            containers = WidgetsScene.gatherContainers(root);
        }
    }

    public ConstraintWidget findWidgetInSelection(float x, float y) {
        ConstraintWidget found = null;
        ArrayList<ConstraintWidget> selection = this.mSelection.getWidgets();
        for (ConstraintWidget widget : selection) {
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(0);
            if (!decorator.isVisible()) continue;
            if (widget instanceof ConstraintWidgetContainer) {
                ConstraintWidget f = this.findWidget((ConstraintWidgetContainer)widget, x, y);
                if (f == null) continue;
                found = f;
                continue;
            }
            int l = widget.getDrawX();
            int t = widget.getDrawY();
            int r = l + widget.getWidth();
            int b = t + widget.getHeight();
            if (!(x >= (float)l) || !(x <= (float)r) || !(y >= (float)t) || !(y <= (float)b)) continue;
            found = widget;
        }
        return found;
    }

    public ConstraintWidget findWidget(ConstraintWidgetContainer container, float x, float y) {
        WidgetCompanion companion = (WidgetCompanion)container.getCompanionWidget();
        WidgetDecorator containerDecorator = companion.getWidgetDecorator(0);
        if (!containerDecorator.isVisible()) {
            return null;
        }
        ConstraintWidget found = null;
        if (container == this.getRoot() && (found = this.findWidgetInSelection(x, y)) != null) {
            return found;
        }
        int l = container.getDrawX();
        int t = container.getDrawY();
        int r = l + container.getWidth();
        int b = t + container.getHeight();
        if (x >= (float)l && x <= (float)r && y >= (float)t && y <= (float)b) {
            found = container;
        }
        for (ConstraintWidget widget : container.getChildren()) {
            WidgetCompanion widgetCompanion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator widgetDecorator = widgetCompanion.getWidgetDecorator(0);
            if (!widgetDecorator.isVisible()) continue;
            if (widget instanceof ConstraintWidgetContainer) {
                ConstraintWidget f = this.findWidget((ConstraintWidgetContainer)widget, x, y);
                if (f == null) continue;
                found = f;
                continue;
            }
            l = widget.getDrawX();
            t = widget.getDrawY();
            r = l + widget.getWidth();
            b = t + widget.getHeight();
            if (!(x >= (float)l) || !(x <= (float)r) || !(y >= (float)t) || !(y <= (float)b)) continue;
            found = widget;
        }
        return found;
    }

    public ArrayList<ConstraintWidget> findWidgets(WidgetContainer container, int x, int y, int width, int height) {
        ArrayList<ConstraintWidget> found = new ArrayList<ConstraintWidget>();
        Rectangle area = new Rectangle(x, y, width, height);
        for (ConstraintWidget widget : container.getChildren()) {
            Rectangle bounds;
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(0);
            if (!decorator.isVisible() || !area.intersects(bounds = new Rectangle(widget.getDrawX(), widget.getDrawY(), widget.getWidth(), widget.getHeight()))) continue;
            found.add(widget);
        }
        return found;
    }

    private static ResizeHandle findResizeHandleInWidget(ConstraintWidget widget, float x, float y, ViewTransform transform) {
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetDecorator decorator = companion.getWidgetDecorator(0);
        if (!decorator.isVisible()) {
            return null;
        }
        WidgetInteractionTargets widgetInteraction = companion.getWidgetInteractionTargets();
        widgetInteraction.updatePosition(transform);
        ResizeHandle handle = widgetInteraction.findResizeHandle(x, y);
        if (handle != null) {
            return handle;
        }
        return null;
    }

    public ResizeHandle findResizeHandle(float x, float y, ViewTransform transform) {
        for (Selection.Element element : this.mSelection.getElements()) {
            ConstraintWidget widget = element.widget;
            ResizeHandle handle = WidgetsScene.findResizeHandleInWidget(widget, x, y, transform);
            if (handle == null) continue;
            return handle;
        }
        for (ConstraintWidget widget : this.mWidgets.values()) {
            ResizeHandle handle;
            if (widget.isRootContainer() || (handle = WidgetsScene.findResizeHandleInWidget(widget, x, y, transform)) == null) continue;
            return handle;
        }
        return null;
    }

    public ConstraintAnchor findAnchorInSelection(float x, float y, boolean checkGuidelines, boolean mousePress, ViewTransform viewTransform) {
        ConnectionCandidate candidate = new ConnectionCandidate();
        float dist = (float)(ConnectionDraw.CONNECTION_ANCHOR_SIZE + ConnectionDraw.CONNECTION_ANCHOR_SIZE) / viewTransform.getScale();
        candidate.distance = viewTransform.getSwingDimensionF(30.0f);
        for (Selection.Element element : this.mSelection.getElements()) {
            ConstraintWidget widget = element.widget;
            if (!checkGuidelines && widget instanceof Guideline) continue;
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets widgetInteraction = companion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(viewTransform);
            widgetInteraction.findClosestConnection(viewTransform, x, y, candidate, mousePress);
        }
        float slope = dist * dist;
        if (candidate.anchorTarget != null && candidate.distance < slope) {
            candidate.distance = 0.0f;
        } else {
            candidate.anchorTarget = null;
        }
        return candidate.anchorTarget;
    }

    public ConstraintAnchor findAnchor(float x, float y, boolean checkGuidelines, boolean mousePress, ViewTransform viewTransform) {
        WidgetCompanion companion;
        ConnectionCandidate candidate = new ConnectionCandidate();
        float dist = (float)(ConnectionDraw.CONNECTION_ANCHOR_SIZE + ConnectionDraw.CONNECTION_ANCHOR_SIZE) / viewTransform.getScale();
        candidate.distance = ConnectionDraw.CONNECTION_ANCHOR_SIZE * ConnectionDraw.CONNECTION_ANCHOR_SIZE;
        for (Selection.Element element : this.mSelection.getElements()) {
            ConstraintWidget widget = element.widget;
            if (!checkGuidelines && widget instanceof Guideline) continue;
            companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets widgetInteraction = companion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(viewTransform);
            widgetInteraction.findClosestConnection(viewTransform, x, y, candidate, mousePress);
        }
        float slope = dist * dist;
        if (candidate.anchorTarget != null && candidate.distance < slope) {
            candidate.distance = 0.0f;
        } else {
            candidate.anchorTarget = null;
        }
        for (ConstraintWidget widget : this.mWidgets.values()) {
            WidgetDecorator decorator;
            if (!checkGuidelines && widget instanceof Guideline || !(decorator = (companion = (WidgetCompanion)widget.getCompanionWidget()).getWidgetDecorator(0)).isVisible()) continue;
            WidgetInteractionTargets widgetInteraction = companion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(viewTransform);
            widgetInteraction.findClosestConnection(viewTransform, x, y, candidate, mousePress);
        }
        return candidate.anchorTarget;
    }

    public String createContainerName(String name) {
        boolean valid = false;
        int counter = 1;
        while (!valid) {
            String candidate = name + counter;
            boolean exists = false;
            for (ConstraintWidget widget : this.mWidgets.values()) {
                if (!widget.getDebugName().equalsIgnoreCase(candidate)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                valid = true;
                name = candidate;
                continue;
            }
            ++counter;
        }
        return name;
    }

    private static ArrayList<ConstraintWidgetContainer> gatherContainers(ConstraintWidgetContainer container) {
        ArrayList<ConstraintWidgetContainer> containers = new ArrayList<ConstraintWidgetContainer>();
        for (ConstraintWidget widget : container.getChildren()) {
            if (!(widget instanceof ConstraintWidgetContainer)) continue;
            containers.add((ConstraintWidgetContainer)widget);
        }
        return containers;
    }

    public void transformContainerToContainer(WidgetContainer oldContainer, ConstraintWidgetContainer newContainer) {
        WidgetContainer parent = (WidgetContainer)oldContainer.getParent();
        if (newContainer.getCompanionWidget() == null) {
            newContainer.setCompanionWidget(oldContainer.getCompanionWidget());
        }
        newContainer.setOrigin(oldContainer.getX(), oldContainer.getY());
        newContainer.setDimension(oldContainer.getWidth(), oldContainer.getHeight());
        newContainer.setHorizontalDimensionBehaviour(oldContainer.getHorizontalDimensionBehaviour());
        newContainer.setVerticalDimensionBehaviour(oldContainer.getVerticalDimensionBehaviour());
        ArrayList<ConstraintWidget> children = new ArrayList<ConstraintWidget>(oldContainer.getChildren());
        for (ConstraintWidget child : children) {
            newContainer.add(child);
        }
        for (ConstraintAnchor anchor : oldContainer.getAnchors()) {
            if (!anchor.isConnected()) continue;
            newContainer.getAnchor(anchor.getType()).connect(anchor.getTarget(), anchor.getMargin(), anchor.getStrength(), anchor.getConnectionCreator());
        }
        for (ConstraintWidget child : newContainer.getChildren()) {
            child.resetAnchors();
        }
        if (parent != null) {
            parent.remove(oldContainer);
            parent.add(newContainer);
        } else {
            this.removeWidget(oldContainer);
        }
        this.mWidgets.remove(WidgetsScene.getTag(oldContainer));
        this.setWidget(newContainer);
        if (this.mRoot != null) {
            boolean previousAnimationState = Animator.doAnimation();
            Animator.setAnimationEnabled(false);
            this.mRoot.layout();
            Animator.setAnimationEnabled(previousAnimationState);
        }
    }

    public void createContainerFromWidgets(ArrayList<ConstraintWidget> widgets, ConstraintWidgetContainer containerInstance, String name) {
        ConstraintWidgetContainer container;
        Collections.sort(widgets, (o1, o2) -> {
            if (o1.getY() + o1.getHeight() < o2.getY()) {
                return -1;
            }
            if (o2.getY() + o2.getHeight() < o1.getY()) {
                return 1;
            }
            return Integer.compare(o1.getX(), o2.getX());
        });
        if (widgets.size() == 0) {
            return;
        }
        for (ConstraintWidget w : this.mWidgets.values()) {
            for (ConstraintWidget widget : widgets) {
                w.disconnectWidget(widget);
                widget.resetAnchors();
                widget.setHorizontalBiasPercent(0.5f);
                widget.setVerticalBiasPercent(0.5f);
            }
        }
        WidgetContainer parent = (WidgetContainer)widgets.get(0).getParent();
        if (parent == null) {
            parent = this.mRoot;
        }
        if ((container = ConstraintWidgetContainer.createContainer(containerInstance, name, widgets, 8)) != null) {
            if (container.getCompanionWidget() == null) {
                container.setCompanionWidget(WidgetCompanion.create(container));
            }
            parent.add(container);
            this.setWidget(container);
            boolean previousAnimationState = Animator.doAnimation();
            Animator.setAnimationEnabled(false);
            this.mRoot.layout();
            Animator.setAnimationEnabled(previousAnimationState);
        }
    }

    public static void adaptTable(ConstraintTableLayout table) {
        int width = table.getWidth();
        int height = table.getHeight();
        ConstraintWidget.DimensionBehaviour horizontalBehaviour = table.getHorizontalDimensionBehaviour();
        ConstraintWidget.DimensionBehaviour verticalBehaviour = table.getVerticalDimensionBehaviour();
        table.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        table.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        table.layout();
        table.layout();
        table.setMinWidth(table.getWidth());
        table.setMinHeight(table.getHeight());
        table.computeGuidelinesPercentPositions();
        table.setHorizontalDimensionBehaviour(horizontalBehaviour);
        table.setVerticalDimensionBehaviour(verticalBehaviour);
        table.setWidth(width < table.getMinWidth() ? table.getMinWidth() : width);
        table.setHeight(height < table.getMinHeight() ? table.getMinHeight() : height);
        table.layout();
    }

    public ConstraintWidget getWidget(Object key) {
        return this.mWidgets.get(key);
    }

    public void setRoot(ConstraintWidgetContainer root) {
        this.mRoot = root;
    }

    public WidgetContainer getRoot() {
        if (this.mRoot == null) {
            for (ConstraintWidget widget : this.mWidgets.values()) {
                WidgetContainer lastRoot;
                if (!(widget instanceof WidgetContainer)) continue;
                WidgetContainer root = lastRoot = (WidgetContainer)widget;
                while (root.getParent() != null) {
                    if (!((root = (WidgetContainer)root.getParent()) instanceof WidgetContainer)) continue;
                    lastRoot = root;
                }
                this.mRoot = lastRoot;
                break;
            }
        }
        return this.mRoot;
    }

    public void setWidget(ConstraintWidget widget) {
        this.mWidgets.put(WidgetsScene.getTag(widget), widget);
    }

    public void addWidget(ConstraintWidget widget) {
        if (widget instanceof ConstraintWidgetContainer && widget.getParent() == null) {
            this.mRoot = (WidgetContainer)widget;
        }
        this.setWidget(widget);
    }

    public void setSelection(Selection selection) {
        this.mSelection = selection;
    }

    public int size() {
        return this.mWidgets.size();
    }

    public ConstraintAnchor getClosestHorizontalWidgetAnchor(ConstraintWidget widget, boolean searchLeft) {
        ConstraintWidgetContainer parent = (ConstraintWidgetContainer)widget.getParent();
        ArrayList<ConstraintWidget> children = parent.getChildren();
        int pos = widget.getDrawX();
        if (!searchLeft) {
            pos = widget.getDrawRight();
        }
        int min = Integer.MAX_VALUE;
        ConstraintWidget found = null;
        for (ConstraintWidget child : children) {
            int minBottom;
            int maxTop = Math.max(child.getDrawY(), widget.getDrawY());
            if (maxTop > (minBottom = Math.min(child.getDrawBottom(), widget.getDrawBottom()))) continue;
            int delta = pos - child.getDrawRight();
            if (!searchLeft) {
                delta = child.getDrawX() - pos;
            }
            if (delta < 0 || delta >= min) continue;
            found = child;
            min = delta;
        }
        if (found == null) {
            if (searchLeft) {
                return parent.getAnchor(ConstraintAnchor.Type.LEFT);
            }
            return parent.getAnchor(ConstraintAnchor.Type.RIGHT);
        }
        if (searchLeft) {
            return found.getAnchor(ConstraintAnchor.Type.RIGHT);
        }
        return found.getAnchor(ConstraintAnchor.Type.LEFT);
    }

    public ConstraintAnchor getClosestVerticalWidgetAnchor(ConstraintWidget widget, boolean searchTop) {
        ConstraintWidgetContainer parent = (ConstraintWidgetContainer)widget.getParent();
        ArrayList<ConstraintWidget> children = parent.getChildren();
        int pos = widget.getDrawY();
        if (!searchTop) {
            pos = widget.getDrawBottom();
        }
        int min = Integer.MAX_VALUE;
        ConstraintWidget found = null;
        for (int i = 0; i < children.size(); ++i) {
            int minRight;
            ConstraintWidget child = children.get(i);
            int maxLeft = Math.max(child.getDrawX(), widget.getDrawX());
            if (maxLeft > (minRight = Math.min(child.getDrawRight(), widget.getDrawRight()))) continue;
            int delta = pos - child.getDrawBottom();
            if (!searchTop) {
                delta = child.getDrawY() - pos;
            }
            if (delta < 0 || delta >= min) continue;
            found = child;
            min = delta;
        }
        if (found == null) {
            if (searchTop) {
                return parent.getAnchor(ConstraintAnchor.Type.TOP);
            }
            return parent.getAnchor(ConstraintAnchor.Type.BOTTOM);
        }
        if (searchTop) {
            return found.getAnchor(ConstraintAnchor.Type.BOTTOM);
        }
        return found.getAnchor(ConstraintAnchor.Type.TOP);
    }

    public void centerHorizontally(ConstraintWidget widget) {
        ConstraintAnchor left = this.getClosestHorizontalWidgetAnchor(widget, true);
        ConstraintAnchor right = this.getClosestHorizontalWidgetAnchor(widget, false);
        widget.connect(widget.getAnchor(ConstraintAnchor.Type.LEFT), left, 0);
        widget.connect(widget.getAnchor(ConstraintAnchor.Type.RIGHT), right, 0);
    }

    public void centerVertically(ConstraintWidget widget) {
        ConstraintAnchor top = this.getClosestVerticalWidgetAnchor(widget, true);
        ConstraintAnchor bottom = this.getClosestVerticalWidgetAnchor(widget, false);
        widget.connect(widget.getAnchor(ConstraintAnchor.Type.TOP), top, 0);
        widget.connect(widget.getAnchor(ConstraintAnchor.Type.BOTTOM), bottom, 0);
    }

    public void updatePositions(ViewTransform viewTransform) {
        for (ConstraintWidget widget : this.mWidgets.values()) {
            widget.updateDrawPosition();
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets widgetInteraction = companion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(viewTransform);
        }
    }

    public int getMainConstraintsCreator(ConstraintWidget widget) {
        int numAuto = 0;
        int numUser = 0;
        for (ConstraintAnchor anchor : widget.getAnchors()) {
            if (!anchor.isConnected()) continue;
            if (anchor.getConnectionCreator() == 0) {
                ++numUser;
                continue;
            }
            ++numAuto;
        }
        if (numAuto == 0 && numUser == 0) {
            return -1;
        }
        if (numUser > numAuto) {
            return 0;
        }
        return 2;
    }

    public void setConstraintsCreator(ConstraintWidget widget, int creator) {
        for (ConstraintAnchor anchor : widget.getAnchors()) {
            if (!anchor.isConnected()) continue;
            anchor.setConnectionCreator(creator);
        }
    }

    public void toggleLockConstraints(ConstraintWidget widget) {
        int constraintsCreator = this.getMainConstraintsCreator(widget);
        if (constraintsCreator == 0) {
            this.setConstraintsCreator(widget, 2);
        } else if (constraintsCreator == 2) {
            this.setConstraintsCreator(widget, 0);
        }
        this.mSelection.selectionHasChanged();
    }
}

