/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.scout.ScoutCandidateGroup;
import com.android.tools.sherpa.scout.ScoutWidget;
import com.android.tools.sherpa.scout.Utils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ScoutGroupInference {
    private static final boolean DEBUG = false;
    private static Rectangle[] debugDraw;
    private static Rectangle[] debugGap;
    private static Rectangle debugBestRect;

    private static void allPositions(ScoutWidget[] list, int[] north, int[] south, int[] west, int[] east) {
        for (int i = 1; i < list.length; ++i) {
            int k = i - 1;
            north[k] = list[i].mConstraintWidget.getY();
            west[k] = list[i].mConstraintWidget.getX();
            south[k] = list[i].mConstraintWidget.getHeight() + north[k];
            east[k] = list[i].mConstraintWidget.getWidth() + west[k];
        }
    }

    public static ConstraintWidget[] computeGroups(ScoutWidget[] list) {
        list = ScoutGroupInference.removeGuidelines(list);
        Rectangle[] rectangles = ScoutGroupInference.widgetsToRectangles(list);
        int[] north = new int[list.length - 1];
        int[] south = new int[list.length - 1];
        int[] west = new int[list.length - 1];
        int[] east = new int[list.length - 1];
        boolean count = false;
        ScoutGroupInference.allPositions(list, north, south, west, east);
        north = Utils.sortUnique(north);
        south = Utils.sortUnique(south);
        east = Utils.sortUnique(east);
        west = Utils.sortUnique(west);
        ArrayList<ScoutCandidateGroup> candidatesList = new ArrayList<ScoutCandidateGroup>();
        Rectangle groupRectangle = new Rectangle();
        for (int n : north) {
            groupRectangle.y = --n;
            for (int s : south) {
                if (n >= ++s) continue;
                groupRectangle.height = s - n;
                for (int w : west) {
                    groupRectangle.x = --w;
                    for (int e : east) {
                        if (w >= ++e) continue;
                        groupRectangle.width = e - w;
                        ScoutCandidateGroup candidateGroup = ScoutCandidateGroup.create(groupRectangle, list, rectangles);
                        if (candidateGroup == null) continue;
                        candidatesList.add(candidateGroup);
                    }
                }
            }
        }
        ScoutCandidateGroup[] candidates = candidatesList.toArray(new ScoutCandidateGroup[0]);
        for (int i = 0; i < candidates.length; ++i) {
            ScoutCandidateGroup candidate = candidates[i];
            if (candidate == null) continue;
            for (int j = i + 1; j < candidates.length; ++j) {
                float innerFraction;
                float outerFraction;
                if (candidates[j] == null) continue;
                if (candidate.mContainSet.equals(candidates[j].mContainSet)) {
                    if (candidate.mGroupArea > candidates[j].mGroupArea) {
                        candidatesList.remove(candidate);
                        candidates[i] = null;
                        continue;
                    }
                    candidatesList.remove(candidates[j]);
                    candidates[j] = null;
                    continue;
                }
                if (candidate.contains(candidates[j]) && (outerFraction = candidate.fractionFilled()) > (innerFraction = candidates[j].fractionFilled())) {
                    candidatesList.remove(candidates[j]);
                    candidates[j] = null;
                    continue;
                }
                if (!candidates[j].contains(candidate) || !((outerFraction = candidates[j].fractionFilled()) > (innerFraction = candidate.fractionFilled()))) continue;
                candidatesList.remove(candidate);
                candidates[i] = null;
            }
        }
        for (ScoutCandidateGroup candidate : candidatesList) {
            candidate.computeGapAreas();
        }
        int i = 0;
        while (i < candidatesList.size()) {
            ScoutCandidateGroup candidate = (ScoutCandidateGroup)candidatesList.get(i);
            if (!candidate.viable()) {
                candidatesList.remove(candidate);
                continue;
            }
            ++i;
        }
        debugDraw = new Rectangle[candidatesList.size()];
        count = false;
        if (candidatesList.isEmpty()) {
            debugDraw = null;
            debugGap = null;
            debugBestRect = null;
            return null;
        }
        ScoutCandidateGroup bestCandidate = (ScoutCandidateGroup)candidatesList.get(0);
        float bestRatio = bestCandidate.calcProb();
        for (ScoutCandidateGroup candidate : candidatesList) {
            float ratio = candidate.calcProb();
            if (!(bestRatio < ratio)) continue;
            bestCandidate = candidate;
            bestRatio = ratio;
        }
        if (bestCandidate.mValidTable) {
            return bestCandidate.buildList(list).toArray(new ConstraintWidget[0]);
        }
        return null;
    }

    private static Rectangle[] widgetsToRectangles(ScoutWidget[] list) {
        Rectangle[] ret = new Rectangle[list.length];
        for (int i = 0; i < ret.length; ++i) {
            int x = list[i].mConstraintWidget.getX();
            int y = list[i].mConstraintWidget.getY();
            int w = list[i].mConstraintWidget.getWidth();
            int h = list[i].mConstraintWidget.getHeight();
            ret[i] = new Rectangle(x, y, w, h);
        }
        return ret;
    }

    private static ScoutWidget[] removeGuidelines(ScoutWidget[] list) {
        ArrayList<ScoutWidget> al = new ArrayList<ScoutWidget>();
        for (ScoutWidget aList : list) {
            if (aList.mConstraintWidget instanceof Guideline) continue;
            al.add(aList);
        }
        return al.toArray(new ScoutWidget[al.size()]);
    }

    public static void paintDebug(Graphics g, int viewMargin, ViewTransform viewTransform) {
    }
}

