/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.scout.Direction;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.scout.ScoutWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class ScoutArrange {
    static Comparator<ConstraintWidget> sSortY = (w1, w2) -> w1.getY() - w2.getY();
    static Comparator<ConstraintWidget> sSortX = (w1, w2) -> w1.getX() - w2.getX();

    /*
     * WARNING - void declaration
     */
    public static void align(Scout.Arrange type, ArrayList<ConstraintWidget> widgetList, boolean applyConstraints) {
        int margin = Scout.getMargin();
        ConstraintWidget[] widgets = new ConstraintWidget[widgetList.size()];
        widgets = widgetList.toArray(widgets);
        switch (type) {
            case AlignHorizontallyCenter: 
            case AlignHorizontallyLeft: 
            case AlignHorizontallyRight: {
                Arrays.sort(widgets, sSortY);
                if (ScoutArrange.rootDistance(widgets[0]) <= ScoutArrange.rootDistance(widgets[widgets.length - 1])) break;
                ScoutArrange.reverse(widgets);
                break;
            }
            case DistributeVertically: {
                Arrays.sort(widgets, sSortY);
                break;
            }
            case AlignVerticallyTop: 
            case AlignVerticallyMiddle: 
            case AlignBaseline: 
            case AlignVerticallyBottom: {
                Arrays.sort(widgets, sSortX);
                if (ScoutArrange.rootDistance(widgets[0]) <= ScoutArrange.rootDistance(widgets[widgets.length - 1])) break;
                ScoutArrange.reverse(widgets);
                break;
            }
            case DistributeHorizontally: {
                Arrays.sort(widgets, sSortX);
            }
        }
        switch (type) {
            case CenterHorizontally: {
                Rectangle rectangle = new Rectangle();
                WidgetContainer widgetContainer = (WidgetContainer)widgets[0].getParent();
                ConstraintWidget[] constraintWidgetArray2 = new ConstraintWidget[widgetContainer.getChildren().size()];
                constraintWidgetArray2 = widgetContainer.getChildren().toArray(constraintWidgetArray2);
                for (ConstraintWidget widget : widgets) {
                    rectangle.x = widget.getX();
                    rectangle.y = widget.getY();
                    rectangle.width = widget.getWidth();
                    rectangle.height = widget.getHeight();
                    int n = ScoutArrange.gap(Direction.WEST, rectangle, constraintWidgetArray2);
                    int eastDistance = ScoutArrange.gap(Direction.EAST, rectangle, constraintWidgetArray2);
                    int x = widget.getX();
                    if (applyConstraints) {
                        ConstraintWidget westConnect = ScoutArrange.gapWidget(Direction.WEST, rectangle, constraintWidgetArray2);
                        ConstraintWidget eastConnect = ScoutArrange.gapWidget(Direction.EAST, rectangle, constraintWidgetArray2);
                        ConstraintAnchor.Type dir = ConstraintAnchor.Type.RIGHT;
                        if (westConnect == widgetContainer) {
                            dir = ConstraintAnchor.Type.LEFT;
                        }
                        widget.connect(ConstraintAnchor.Type.LEFT, westConnect, dir, 0);
                        dir = ConstraintAnchor.Type.LEFT;
                        if (eastConnect == widgetContainer) {
                            dir = ConstraintAnchor.Type.RIGHT;
                        }
                        widget.connect(ConstraintAnchor.Type.RIGHT, eastConnect, dir, 0);
                        widget.setHorizontalBiasPercent(0.5f);
                        continue;
                    }
                    widget.setX(x + (eastDistance - n) / 2);
                }
                break;
            }
            case CenterVertically: {
                Rectangle rectangle = new Rectangle();
                WidgetContainer widgetContainer = (WidgetContainer)widgets[0].getParent();
                ConstraintWidget[] constraintWidgetArray3 = new ConstraintWidget[widgetContainer.getChildren().size()];
                constraintWidgetArray3 = widgetContainer.getChildren().toArray(constraintWidgetArray3);
                for (ConstraintWidget widget : widgets) {
                    rectangle.x = widget.getX();
                    rectangle.y = widget.getY();
                    rectangle.width = widget.getWidth();
                    rectangle.height = widget.getHeight();
                    int n = ScoutArrange.gap(Direction.NORTH, rectangle, constraintWidgetArray3);
                    int southDistance = ScoutArrange.gap(Direction.SOUTH, rectangle, constraintWidgetArray3);
                    int Y = widget.getY();
                    if (applyConstraints) {
                        ConstraintWidget northConnect = ScoutArrange.gapWidget(Direction.NORTH, rectangle, constraintWidgetArray3);
                        ConstraintWidget southConnect = ScoutArrange.gapWidget(Direction.SOUTH, rectangle, constraintWidgetArray3);
                        ConstraintAnchor.Type dir = ConstraintAnchor.Type.BOTTOM;
                        if (northConnect == widgetContainer) {
                            dir = ConstraintAnchor.Type.TOP;
                        }
                        widget.connect(ConstraintAnchor.Type.TOP, northConnect, dir, 0);
                        dir = ConstraintAnchor.Type.TOP;
                        if (southConnect == widgetContainer) {
                            dir = ConstraintAnchor.Type.BOTTOM;
                        }
                        widget.connect(ConstraintAnchor.Type.BOTTOM, southConnect, dir, 0);
                        widget.setVerticalBiasPercent(0.5f);
                        continue;
                    }
                    widget.setY(Y + (southDistance - n) / 2);
                }
                break;
            }
            case CenterHorizontallyInParent: {
                void var7_56;
                ConstraintWidget[] rectangle = widgets;
                int n = rectangle.length;
                boolean bl = false;
                while (var7_56 < n) {
                    ConstraintWidget widget = rectangle[var7_56];
                    int parentWidth = widget.getParent().getWidth();
                    int width = widget.getWidth();
                    widget.setX((parentWidth - width) / 2);
                    if (applyConstraints) {
                        widget.connect(ConstraintAnchor.Type.CENTER_X, widget.getParent(), ConstraintAnchor.Type.CENTER_X, 0);
                        widget.setHorizontalBiasPercent(0.5f);
                    }
                    ++var7_56;
                }
                break;
            }
            case CenterVerticallyInParent: {
                void var7_58;
                ConstraintWidget[] rectangle = widgets;
                int n = rectangle.length;
                boolean bl = false;
                while (var7_58 < n) {
                    ConstraintWidget widget = rectangle[var7_58];
                    int parentHeight = widget.getParent().getHeight();
                    int height = widget.getHeight();
                    widget.setY((parentHeight - height) / 2);
                    if (applyConstraints) {
                        widget.connect(ConstraintAnchor.Type.CENTER_Y, widget.getParent(), ConstraintAnchor.Type.CENTER_Y, 0);
                        widget.setVerticalBiasPercent(0.5f);
                    }
                    ++var7_58;
                }
                break;
            }
            case AlignHorizontallyCenter: {
                int count = 0;
                float f = 0.0f;
                for (ConstraintWidget widget : widgets) {
                    f += (float)widget.getX() + (float)widget.getWidth() / 2.0f;
                    ++count;
                }
                f /= (float)count;
                Object var7_60 = null;
                for (ConstraintWidget widget : widgets) {
                    void var7_61;
                    float f2 = (float)widget.getWidth() / 2.0f;
                    widget.setX((int)(f - f2));
                    if (applyConstraints && var7_61 != null) {
                        widget.connect(ConstraintAnchor.Type.CENTER_X, (ConstraintWidget)var7_61, ConstraintAnchor.Type.CENTER_X, 0);
                    }
                    ConstraintWidget constraintWidget = widget;
                }
                break;
            }
            case AlignHorizontallyLeft: {
                int min = Integer.MAX_VALUE;
                for (ConstraintWidget widget : widgets) {
                    min = Math.min(min, widget.getX());
                }
                Object var6_26 = null;
                for (ConstraintWidget widget : widgets) {
                    void var6_27;
                    widget.setX(min);
                    if (applyConstraints && var6_27 != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.RIGHT));
                        widget.connect(ConstraintAnchor.Type.LEFT, (ConstraintWidget)var6_27, ConstraintAnchor.Type.LEFT, 0);
                    }
                    ConstraintWidget constraintWidget = widget;
                }
                break;
            }
            case AlignHorizontallyRight: {
                int max = Integer.MIN_VALUE;
                for (ConstraintWidget widget : widgets) {
                    max = Math.max(max, widget.getX() + widget.getWidth());
                }
                Object var6_30 = null;
                for (ConstraintWidget widget : widgets) {
                    void var6_31;
                    float current = widget.getWidth();
                    widget.setX((int)((float)max - current));
                    if (applyConstraints && var6_31 != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.LEFT));
                        widget.connect(ConstraintAnchor.Type.RIGHT, (ConstraintWidget)var6_31, ConstraintAnchor.Type.RIGHT, 0);
                    }
                    ConstraintWidget constraintWidget = widget;
                }
                break;
            }
            case AlignVerticallyTop: {
                int min = Integer.MAX_VALUE;
                for (ConstraintWidget widget : widgets) {
                    min = Math.min(min, widget.getY());
                }
                Object var6_34 = null;
                for (ConstraintWidget widget : widgets) {
                    void var6_35;
                    widget.setY(min);
                    if (applyConstraints && var6_35 != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.BOTTOM));
                        widget.connect(ConstraintAnchor.Type.TOP, (ConstraintWidget)var6_35, ConstraintAnchor.Type.TOP, 0);
                    }
                    ConstraintWidget constraintWidget = widget;
                }
                break;
            }
            case AlignVerticallyMiddle: {
                int count = 0;
                float f = 0.0f;
                for (ConstraintWidget widget : widgets) {
                    f += (float)widget.getY() + (float)widget.getHeight() / 2.0f;
                    ++count;
                }
                f /= (float)count;
                Object var7_70 = null;
                for (ConstraintWidget widget2 : widgets) {
                    void var7_71;
                    float f3 = (float)widget2.getHeight() / 2.0f;
                    widget2.setY((int)(f - f3));
                    if (applyConstraints && var7_71 != null) {
                        widget2.connect(ConstraintAnchor.Type.CENTER_Y, (ConstraintWidget)var7_71, ConstraintAnchor.Type.CENTER_Y, 0);
                    }
                    ConstraintWidget constraintWidget = widget2;
                }
                break;
            }
            case AlignBaseline: {
                void var7_74;
                int count = 0;
                float f = 0.0f;
                boolean bl = false;
                ConstraintWidget fixedWidget = null;
                for (ConstraintWidget constraintWidget : widgets) {
                    if (ScoutArrange.isVerticallyConstrained(constraintWidget)) {
                        ++var7_74;
                        fixedWidget = constraintWidget;
                    }
                    f += (float)(constraintWidget.getY() + constraintWidget.getBaselineDistance());
                    ++count;
                }
                f /= (float)count;
                if (var7_74 == true) {
                    f = fixedWidget.getY() + fixedWidget.getBaselineDistance();
                }
                ConstraintWidget previousWidget = null;
                if (!applyConstraints || var7_74 == false) {
                    void var12_160;
                    ConstraintWidget[] widget = widgets;
                    int widget2 = widget.length;
                    boolean bl2 = false;
                    while (var12_160 < widget2) {
                        ConstraintWidget widget3 = widget[var12_160];
                        float baseline = widget3.getBaselineDistance();
                        widget3.setY((int)(f - baseline));
                        if (applyConstraints && previousWidget != null) {
                            widget3.connect(ConstraintAnchor.Type.BASELINE, previousWidget, ConstraintAnchor.Type.BASELINE, 0);
                        }
                        previousWidget = widget3;
                        ++var12_160;
                    }
                } else {
                    ArrayList<ConstraintWidget> unconstrained = new ArrayList<ConstraintWidget>();
                    ArrayList<ConstraintWidget> constrained = new ArrayList<ConstraintWidget>();
                    for (ConstraintWidget widget : widgets) {
                        if (ScoutArrange.isVerticallyConstrained(widget)) {
                            constrained.add(widget);
                            continue;
                        }
                        unconstrained.add(widget);
                    }
                    while (!unconstrained.isEmpty()) {
                        void var12_164;
                        Object var12_163 = null;
                        ConstraintWidget from = null;
                        int min = Integer.MAX_VALUE;
                        for (ConstraintWidget fromCandidate : unconstrained) {
                            for (ConstraintWidget toCandidate : constrained) {
                                int fromLeft = fromCandidate.getX();
                                int fromRight = fromLeft + fromCandidate.getWidth();
                                int toLeft = toCandidate.getX();
                                int toRight = toLeft + toCandidate.getWidth();
                                int dist = Math.abs(toLeft - fromLeft);
                                dist = Math.min(dist, Math.abs(toLeft - fromRight));
                                dist = Math.min(dist, Math.abs(toRight - fromRight));
                                if ((dist = Math.min(dist, Math.abs(toRight - fromLeft))) >= min) continue;
                                min = dist;
                                ConstraintWidget constraintWidget = toCandidate;
                                from = fromCandidate;
                            }
                        }
                        from.connect(ConstraintAnchor.Type.BASELINE, (ConstraintWidget)var12_164, ConstraintAnchor.Type.BASELINE, 0);
                        constrained.add(from);
                        unconstrained.remove(from);
                    }
                }
                break;
            }
            case AlignVerticallyBottom: {
                int max = Integer.MIN_VALUE;
                for (ConstraintWidget widget : widgets) {
                    max = Math.max(max, widget.getY() + widget.getHeight());
                }
                Object var6_40 = null;
                for (ConstraintWidget widget : widgets) {
                    void var6_41;
                    float current = widget.getHeight();
                    widget.setY((int)((float)max - current));
                    if (applyConstraints && var6_41 != null) {
                        widget.resetAnchor(widget.getAnchor(ConstraintAnchor.Type.TOP));
                        widget.connect(ConstraintAnchor.Type.BOTTOM, (ConstraintWidget)var6_41, ConstraintAnchor.Type.BOTTOM, 0);
                    }
                    ConstraintWidget constraintWidget = widget;
                }
                break;
            }
            case DistributeVertically: {
                void var6_44;
                int n;
                int size;
                int count = 0;
                boolean bl = false;
                int n2 = widgetList.get(0).getY();
                int max = widgetList.get(0).getY() + widgetList.get(0).getHeight();
                for (ConstraintWidget constraintWidget : widgets) {
                    int start = constraintWidget.getY();
                    size = constraintWidget.getHeight();
                    int end = start + size;
                    var6_44 += size;
                    n = Math.min(n, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - n - var6_44;
                void lastY = n;
                boolean bl3 = ScoutArrange.rootDistanceY(widgets[0]) > ScoutArrange.rootDistanceY(widgets[widgets.length - 1]);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = widgets[i - 1].getHeight();
                    void pos = (var7_79 += size) + totalGap * i / gaps;
                    widgets[i].setY((int)pos);
                    if (!applyConstraints) continue;
                    if (bl3) {
                        widgets[i - 1].connect(ConstraintAnchor.Type.BOTTOM, widgets[i], ConstraintAnchor.Type.TOP, (int)(pos - lastY - size));
                    } else {
                        widgets[i].connect(ConstraintAnchor.Type.TOP, widgets[i - 1], ConstraintAnchor.Type.BOTTOM, (int)(pos - lastY - size));
                    }
                    lastY = pos;
                }
                break;
            }
            case DistributeHorizontally: {
                void var6_46;
                int n;
                int size;
                int count = 0;
                boolean bl = false;
                int n3 = widgetList.get(0).getX();
                int max = widgetList.get(0).getX() + widgetList.get(0).getHeight();
                for (ConstraintWidget constraintWidget : widgets) {
                    int start = constraintWidget.getX();
                    size = constraintWidget.getWidth();
                    int end = start + size;
                    var6_46 += size;
                    n = Math.min(n, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - n - var6_46;
                void lastX = n;
                boolean bl4 = ScoutArrange.rootDistanceX(widgets[0]) > ScoutArrange.rootDistanceX(widgets[widgets.length - 1]);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = widgets[i - 1].getWidth();
                    void pos = (var7_82 += size) + totalGap * i / gaps;
                    widgets[i].setX((int)pos);
                    if (!applyConstraints) continue;
                    if (bl4) {
                        widgets[i - 1].connect(ConstraintAnchor.Type.RIGHT, widgets[i], ConstraintAnchor.Type.LEFT, (int)(pos - lastX - size));
                    } else {
                        widgets[i].connect(ConstraintAnchor.Type.LEFT, widgets[i - 1], ConstraintAnchor.Type.RIGHT, (int)(pos - lastX - size));
                    }
                    lastX = pos;
                }
                break;
            }
            case VerticalPack: {
                Rectangle original = ScoutArrange.getBoundingBox(widgetList);
                ConstraintWidget[] constraintWidgetArray4 = new ConstraintWidget[widgetList.size()];
                constraintWidgetArray4 = widgetList.toArray(constraintWidgetArray4);
                Arrays.sort(constraintWidgetArray4, (w1, w2) -> Integer.compare(w1.getY(), w2.getY()));
                ScoutWidget[] scoutWidgetArray = ScoutWidget.getWidgetArray((WidgetContainer)widgetList.get(0).getParent());
                for (ConstraintWidget cw : constraintWidgetArray4) {
                    for (ScoutWidget scoutWidget : scoutWidgetArray) {
                        if (scoutWidget.mConstraintWidget != cw) continue;
                        int gapN = scoutWidget.gap(Direction.NORTH, scoutWidgetArray);
                        int newY = margin + scoutWidget.mConstraintWidget.getY() - gapN;
                        newY = Math.max(newY, original.y);
                        scoutWidget.setY(newY);
                    }
                }
                break;
            }
            case HorizontalPack: {
                Rectangle original = ScoutArrange.getBoundingBox(widgetList);
                ConstraintWidget[] constraintWidgetArray5 = new ConstraintWidget[widgetList.size()];
                constraintWidgetArray5 = widgetList.toArray(constraintWidgetArray5);
                Arrays.sort(constraintWidgetArray5, (w1, w2) -> Integer.compare(w1.getX(), w2.getX()));
                ScoutWidget[] scoutWidgetArray = ScoutWidget.getWidgetArray((WidgetContainer)widgetList.get(0).getParent());
                for (ConstraintWidget cw : constraintWidgetArray5) {
                    for (ScoutWidget scoutWidget : scoutWidgetArray) {
                        if (scoutWidget.mConstraintWidget != cw) continue;
                        int gapW = scoutWidget.gap(Direction.WEST, scoutWidgetArray);
                        int newX = margin + scoutWidget.mConstraintWidget.getX() - gapW;
                        newX = Math.max(newX, original.x);
                        scoutWidget.setX(newX);
                    }
                }
                break;
            }
            case ExpandVertically: {
                ScoutArrange.expandVertically(widgetList, margin);
                break;
            }
            case ExpandHorizontally: {
                ScoutArrange.expandHorizontally(widgetList, margin);
            }
        }
    }

    private static void expandVertically(ArrayList<ConstraintWidget> widgetList, int margin) {
        WidgetContainer base = (WidgetContainer)widgetList.get(0).getParent();
        ConstraintWidget[] pears = new ConstraintWidget[base.getChildren().size()];
        pears = base.getChildren().toArray(pears);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(widgetList);
        Rectangle clip = new Rectangle();
        int gapNorth = ScoutArrange.gap(Direction.NORTH, selectBounds, pears);
        int gapSouth = ScoutArrange.gap(Direction.SOUTH, selectBounds, pears);
        clip.y = selectBounds.y - gapNorth;
        clip.height = selectBounds.height + gapSouth + gapNorth;
        ArrayList<ConstraintWidget> selectedList = new ArrayList<ConstraintWidget>(widgetList);
        while (!selectedList.isEmpty()) {
            ConstraintWidget widget = selectedList.remove(0);
            ArrayList<ConstraintWidget> col = new ArrayList<ConstraintWidget>();
            col.add(widget);
            Iterator<ConstraintWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ConstraintWidget elem = iterator.next();
                if (!ScoutArrange.isSameColumn(widget, elem)) continue;
                if (!col.contains(elem)) {
                    col.add(elem);
                }
                iterator.remove();
            }
            ConstraintWidget[] colArray = new ConstraintWidget[col.size()];
            colArray = col.toArray(colArray);
            Arrays.sort(colArray, sSortY);
            int gaps = (colArray.length - 1) * margin;
            int totalHeight = clip.height - gaps - 2 * margin;
            for (int i = 0; i < colArray.length; ++i) {
                int y = margin * i + i * totalHeight / colArray.length;
                ConstraintWidget constraintWidget = colArray[i];
                constraintWidget.setY(y + clip.y + margin);
                int yend = margin * i + totalHeight * (i + 1) / colArray.length;
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setHeight(yend - y);
            }
        }
    }

    public static void expandHorizontally(ArrayList<ConstraintWidget> widgetList, int margin) {
        WidgetContainer base = (WidgetContainer)widgetList.get(0).getParent();
        ConstraintWidget[] pears = new ConstraintWidget[base.getChildren().size()];
        pears = base.getChildren().toArray(pears);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(widgetList);
        Rectangle clip = new Rectangle();
        int gapWest = ScoutArrange.gap(Direction.WEST, selectBounds, pears);
        int gapEast = ScoutArrange.gap(Direction.EAST, selectBounds, pears);
        clip.x = selectBounds.x - gapWest;
        clip.width = selectBounds.width + gapEast + gapWest;
        ArrayList<ConstraintWidget> selectedList = new ArrayList<ConstraintWidget>(widgetList);
        while (!selectedList.isEmpty()) {
            ConstraintWidget widget = selectedList.remove(0);
            ArrayList<ConstraintWidget> row = new ArrayList<ConstraintWidget>();
            row.add(widget);
            Iterator<ConstraintWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ConstraintWidget elem = iterator.next();
                if (!ScoutArrange.isSameRow(widget, elem)) continue;
                if (!row.contains(elem)) {
                    row.add(elem);
                }
                iterator.remove();
            }
            ConstraintWidget[] rowArray = new ConstraintWidget[row.size()];
            rowArray = row.toArray(rowArray);
            Arrays.sort(rowArray, sSortX);
            int gaps = (rowArray.length - 1) * margin;
            int totalWidth = clip.width - gaps - 2 * margin;
            for (int i = 0; i < rowArray.length; ++i) {
                int x = margin * i + i * totalWidth / rowArray.length;
                ConstraintWidget constraintWidget = rowArray[i];
                constraintWidget.setX(x + clip.x + margin);
                int xend = margin * i + totalWidth * (i + 1) / rowArray.length;
                constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setWidth(xend - x);
            }
        }
    }

    static boolean isSameRow(ConstraintWidget a, ConstraintWidget b) {
        return Math.max(a.getY(), b.getY()) < Math.min(a.getY() + a.getHeight(), b.getY() + b.getHeight());
    }

    static boolean isSameColumn(ConstraintWidget a, ConstraintWidget b) {
        return Math.max(a.getX(), b.getX()) < Math.min(a.getX() + a.getWidth(), b.getX() + b.getWidth());
    }

    static Rectangle getRectangle(ConstraintWidget widget) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = widget.getX();
        rectangle.y = widget.getY();
        rectangle.width = widget.getWidth();
        rectangle.height = widget.getHeight();
        return rectangle;
    }

    public static ConstraintWidget gapWidget(Direction direction, Rectangle region, ConstraintWidget[] list) {
        int rootWidth = list[0].getParent().getWidth();
        int rootHeight = list[0].getParent().getHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case NORTH: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case SOUTH: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case WEST: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case EAST: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
            }
        }
        int min = Integer.MAX_VALUE;
        ConstraintWidget minWidget = null;
        for (ConstraintWidget widget : list) {
            int dist;
            Rectangle r = ScoutArrange.getRectangle(widget);
            if (!r.intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            minWidget = widget;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            return list[0].getParent();
        }
        return minWidget;
    }

    public static int gap(Direction direction, Rectangle region, ConstraintWidget[] list) {
        int rootWidth = list[0].getParent().getWidth();
        int rootHeight = list[0].getParent().getHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case NORTH: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case SOUTH: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case WEST: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case EAST: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < list.length; ++i) {
            int dist;
            ConstraintWidget widget = list[i];
            Rectangle r = ScoutArrange.getRectangle(widget);
            if (!r.intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            switch (direction) {
                case NORTH: {
                    return region.y;
                }
                case SOUTH: {
                    return rootHeight - (region.y + region.height);
                }
                case WEST: {
                    return region.x;
                }
                case EAST: {
                    return rootWidth - (region.x + region.width);
                }
            }
        }
        return min;
    }

    static float distance(Rectangle a, Rectangle b) {
        float ax1 = a.x;
        float ax2 = a.x + a.width;
        float ay1 = a.y;
        float ay2 = a.y + a.height;
        float bx1 = b.x;
        float bx2 = b.x + b.width;
        float by1 = b.y;
        float by2 = b.y + b.height;
        float xdiff11 = Math.abs(ax1 - bx1);
        float xdiff12 = Math.abs(ax1 - bx2);
        float xdiff21 = Math.abs(ax2 - bx1);
        float xdiff22 = Math.abs(ax2 - bx2);
        float ydiff11 = Math.abs(ay1 - by1);
        float ydiff12 = Math.abs(ay1 - by2);
        float ydiff21 = Math.abs(ay2 - by1);
        float ydiff22 = Math.abs(ay2 - by2);
        float xmin = Math.min(Math.min(xdiff11, xdiff12), Math.min(xdiff21, xdiff22));
        float ymin = Math.min(Math.min(ydiff11, ydiff12), Math.min(ydiff21, ydiff22));
        boolean yOverlap = ay1 <= by2 && by1 <= ay2;
        boolean xOverlap = ax1 <= bx2 && bx1 <= ax2;
        float xReturn = yOverlap ? xmin : (float)Math.hypot(xmin, ymin);
        float yReturn = xOverlap ? ymin : (float)Math.hypot(xmin, ymin);
        return Math.min(xReturn, yReturn);
    }

    static int rootDistanceX(ConstraintWidget widget) {
        int rootWidth = widget.getParent().getWidth();
        int aX = widget.getX();
        int aWidth = widget.getWidth();
        return Math.min(aX, rootWidth - (aX + aWidth));
    }

    static int rootDistanceY(ConstraintWidget widget) {
        int rootHeight = widget.getParent().getHeight();
        int aY = widget.getY();
        int aHeight = widget.getHeight();
        return Math.min(aY, rootHeight - (aY + aHeight));
    }

    static Rectangle getBoundingBox(ArrayList<ConstraintWidget> widgets) {
        Rectangle all = null;
        Rectangle tmp = new Rectangle();
        for (ConstraintWidget widget : widgets) {
            if (widget instanceof Guideline) continue;
            tmp.x = widget.getX();
            tmp.y = widget.getY();
            tmp.width = widget.getWidth();
            tmp.height = widget.getHeight();
            if (all == null) {
                all = new Rectangle(tmp);
                continue;
            }
            all = all.union(tmp);
        }
        return all;
    }

    private static void reverse(ConstraintWidget[] widgets) {
        for (int i = 0; i < widgets.length / 2; ++i) {
            ConstraintWidget widget = widgets[i];
            widgets[i] = widgets[widgets.length - 1 - i];
            widgets[widgets.length - 1 - i] = widget;
        }
    }

    private static int rootDistance(ConstraintWidget widget) {
        int rootHeight = widget.getParent().getHeight();
        int rootWidth = widget.getParent().getWidth();
        int aX = widget.getX();
        int aY = widget.getY();
        int aWidth = widget.getWidth();
        int aHeight = widget.getHeight();
        int minx = Math.min(aX, rootWidth - (aX + aWidth));
        int miny = Math.min(aY, rootHeight - (aY + aHeight));
        return Math.min(minx, miny);
    }

    private static boolean isVerticallyConstrained(ConstraintWidget widget) {
        if (widget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
            return true;
        }
        if (widget.getAnchor(ConstraintAnchor.Type.TOP).isConnected()) {
            return true;
        }
        return widget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected();
    }

    private static ConstraintWidget nearestHorizontal(ConstraintWidget nextTo, ArrayList<ConstraintWidget> list) {
        int min = Integer.MAX_VALUE;
        ConstraintWidget ret = null;
        int nextToLeft = nextTo.getX();
        int nextToRight = nextToLeft + nextTo.getWidth();
        for (ConstraintWidget widget : list) {
            if (widget == nextTo) continue;
            int left = widget.getX();
            int right = left + widget.getWidth();
            int dist = Math.abs(left - nextToLeft);
            dist = Math.min(dist, Math.abs(left - nextToRight));
            dist = Math.min(dist, Math.abs(right - nextToRight));
            if ((dist = Math.min(dist, Math.abs(right - nextToLeft))) >= min) continue;
            min = dist;
            ret = widget;
        }
        return ret;
    }
}

