/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import javax.swing.Timer;

public class ConstraintHandle {
    private final WidgetInteractionTargets mOwner;
    private final ConstraintAnchor.Type mType;
    private ConstraintAnchor mAnchor;
    private int mX;
    private int mY;
    private int[] mCurve = new int[8];
    private boolean mHasCurve = false;
    static final Color sShadowColor = new Color(0, 0, 0, 50);
    static final Stroke sShadowStroke = new BasicStroke(3.0f);
    static final Stroke sLineShadowStroke = new BasicStroke(5.0f);
    static final Stroke sSimpleStroke = new BasicStroke(1.0f);
    static final int sCountDownRadius = 10;
    private static final int sConnectionOffset = 6;
    private static final int LOCK_CONNECTIONS_DURATION = 3000;
    private final Timer mLockTimer = new Timer(3000, e -> {
        if (this.mAnchor.isConnected()) {
            this.mAnchor.setConnectionCreator(0);
            WidgetCompanion companion = (WidgetCompanion)this.mAnchor.getOwner().getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(0);
            if (decorator.getStateModel() != null) {
                decorator.getStateModel().save(decorator);
            }
        }
        this.stopLock();
    });
    private boolean mLocking = false;
    private long mLockingStartTime = 0L;

    public ConstraintHandle(WidgetInteractionTargets owner, ConstraintAnchor.Type type) {
        this.mOwner = owner;
        this.mType = type;
        this.mLockTimer.setRepeats(false);
    }

    public ConstraintWidget getOwner() {
        return this.mOwner.getConstraintWidget();
    }

    public ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    public void updateAnchor() {
        ConstraintWidget widget;
        this.mAnchor = this.mOwner != null ? ((widget = this.mOwner.getConstraintWidget()) instanceof Guideline ? ((Guideline)widget).getAnchor() : widget.getAnchor(this.mType)) : null;
    }

    public void setCurveParameters(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.mCurve[0] = x1;
        this.mCurve[1] = y1;
        this.mCurve[2] = x2;
        this.mCurve[3] = y2;
        this.mCurve[4] = x3;
        this.mCurve[5] = y3;
        this.mCurve[6] = x4;
        this.mCurve[7] = y4;
        this.mHasCurve = true;
    }

    public void setCurve(boolean hasCurve) {
        this.mHasCurve = hasCurve;
    }

    public boolean hasCurve() {
        return this.mHasCurve;
    }

    public int[] getCurve() {
        return this.mCurve;
    }

    public int getDrawX() {
        return this.mX;
    }

    public int getDrawY() {
        return this.mY;
    }

    public void setDrawX(int x) {
        this.mX = x;
    }

    public void setDrawY(int y) {
        this.mY = y;
    }

    void updatePosition() {
        if (this.mOwner == null) {
            this.mX = 0;
            this.mY = 0;
            return;
        }
        ConstraintWidget widget = this.mOwner.getConstraintWidget();
        int x = widget.getDrawX();
        int y = widget.getDrawY();
        int w = widget.getDrawWidth();
        int h = widget.getDrawHeight();
        if (this.mAnchor == null) {
            return;
        }
        switch (this.mAnchor.getType()) {
            case LEFT: {
                this.mX = x;
                this.mY = y + h / 2;
                break;
            }
            case TOP: {
                this.mX = x + w / 2;
                this.mY = y;
                break;
            }
            case RIGHT: {
                this.mX = x + w;
                this.mY = y + h / 2;
                break;
            }
            case BOTTOM: {
                this.mX = x + w / 2;
                this.mY = y + h;
                break;
            }
            case CENTER: 
            case CENTER_X: 
            case CENTER_Y: {
                this.mX = x + w / 2;
                this.mY = y + h / 2;
                break;
            }
            case BASELINE: {
                this.mX = x + w / 2;
                this.mY = y + widget.getBaselineDistance();
            }
        }
    }

    public int getCreationMarginFrom(ConstraintHandle anchor) {
        int distance = 0;
        switch (this.mAnchor.getType()) {
            case LEFT: {
                distance = this.mX - anchor.mX;
                break;
            }
            case RIGHT: {
                distance = anchor.mX - this.mX;
                break;
            }
            case TOP: {
                distance = this.mY - anchor.mY;
                break;
            }
            case BOTTOM: {
                distance = anchor.mY - this.mY;
            }
        }
        if (distance < 0) {
            return 0;
        }
        return distance;
    }

    public int getStraightDistanceFrom(ConstraintHandle anchor) {
        if (anchor == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.mAnchor.getType()) {
            case CENTER: {
                if (anchor.getAnchor().isVerticalAnchor()) {
                    return Math.abs(anchor.mY - this.mY);
                }
                return Math.abs(anchor.mX - this.mX);
            }
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                return Math.abs(anchor.mX - this.mX);
            }
            case TOP: 
            case BOTTOM: 
            case CENTER_Y: 
            case BASELINE: {
                return Math.abs(anchor.mY - this.mY);
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getDistanceFrom(ConstraintWidget component) {
        int myComponentX = this.getOwner().getX();
        int myComponentY = this.getOwner().getY();
        int myComponentWidth = this.getOwner().getWidth();
        int myComponentHeight = this.getOwner().getHeight();
        switch (this.mAnchor.getType()) {
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                int ya1 = myComponentY;
                int ya2 = myComponentY + myComponentHeight;
                int yb1 = component.getDrawY();
                int yb2 = component.getDrawY() + component.getDrawHeight();
                int d1 = Math.abs(ya1 - yb1);
                int d2 = Math.abs(ya1 - yb2);
                int d3 = Math.abs(ya2 - yb1);
                int d4 = Math.abs(ya2 - yb2);
                return Math.min(Math.min(d1, d2), Math.min(d3, d4));
            }
            case TOP: 
            case BOTTOM: 
            case CENTER_Y: 
            case BASELINE: {
                int xa1 = myComponentX;
                int xa2 = myComponentX + myComponentWidth;
                int xb1 = component.getDrawX();
                int xb2 = component.getDrawX() + component.getDrawWidth();
                int d1 = Math.abs(xa1 - xb1);
                int d2 = Math.abs(xa1 - xb2);
                int d3 = Math.abs(xa2 - xb1);
                int d4 = Math.abs(xa2 - xb2);
                return Math.min(Math.min(d1, d2), Math.min(d3, d4));
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getBaselineHandleWidth(ViewTransform transform) {
        int padding;
        if (this.mType != ConstraintAnchor.Type.BASELINE) {
            return 0;
        }
        int w = transform.getSwingDimension(this.getOwner().getDrawWidth());
        if (w - 2 * (padding = (int)((double)w * 0.4 / 2.0)) < 16) {
            padding = (w - 16) / 2;
        }
        return w - 2 * padding;
    }

    public void draw(ViewTransform transform, Graphics2D g, ColorSet colorSet, boolean isSelected) {
        ConstraintWidget widget = this.getOwner();
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetDecorator decorator = companion.getWidgetDecorator(colorSet.getStyle());
        Color backgroundColor = decorator.getBackgroundColor();
        if (this.mType == ConstraintAnchor.Type.BASELINE) {
            int x = transform.getSwingX(this.getOwner().getDrawX());
            int y = transform.getSwingY(this.getOwner().getDrawY());
            int w = transform.getSwingDimension(this.getOwner().getDrawWidth());
            int baseline = transform.getSwingDimension(this.getOwner().getBaselineDistance());
            int padding = (w - this.getBaselineHandleWidth(transform)) / 2;
            int bh = 7;
            int by = y + baseline;
            if (isSelected) {
                Color pre = g.getColor();
                Stroke preStroke = g.getStroke();
                g.setColor(colorSet.getShadow());
                g.setStroke(colorSet.getShadowStroke());
                g.drawRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
                g.setStroke(preStroke);
                g.setColor(pre);
            }
            Color previous = g.getColor();
            g.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), previous.getAlpha()));
            g.fillRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
            g.setColor(previous);
            g.drawRoundRect(x + padding, by - bh / 2, w - 2 * padding, bh, bh, bh);
            g.drawLine(x, by, x + padding, by);
            g.drawLine(x + w - padding, by, x + w, by);
            if (this.mAnchor.isConnected()) {
                int margin = 2;
                g.fillRoundRect(x + padding + margin, by - bh / 2 + margin, w - 2 * padding - 2 * margin, bh - 2 * margin, bh, bh);
                g.drawRoundRect(x + padding + margin, by - bh / 2 + margin, w - 2 * padding - 2 * margin, bh - 2 * margin, bh, bh);
            }
        } else {
            int innerMargin = 3;
            int radius = ConnectionDraw.CONNECTION_ANCHOR_SIZE;
            int dimension = radius * 2;
            int cx = transform.getSwingFX(this.mX) - dimension / 2;
            int cy = transform.getSwingFY(this.mY) - dimension / 2;
            Ellipse2D.Float outerCircle = new Ellipse2D.Float(cx, cy, dimension, dimension);
            if (isSelected) {
                Color pre = g.getColor();
                Stroke preStroke = g.getStroke();
                g.setColor(sShadowColor);
                g.setStroke(sShadowStroke);
                g.draw(outerCircle);
                g.setStroke(preStroke);
                g.setColor(pre);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(backgroundColor);
            g2.fill(outerCircle);
            g2.dispose();
            g.draw(outerCircle);
            if (this.mAnchor.isConnected()) {
                int d = dimension - innerMargin * 2;
                g.fillRoundRect(cx + innerMargin, cy + innerMargin, d, d, d, d);
                g.drawRoundRect(cx + innerMargin, cy + innerMargin, d, d, d, d);
            }
        }
    }

    public void drawConnection(ViewTransform transform, Graphics2D g, ColorSet colorSet, boolean isSelected) {
        this.drawConnection(transform, g, colorSet, isSelected, true, -1, 0.0f);
    }

    public void drawConnection(ViewTransform transform, Graphics2D g, ColorSet colorSet, boolean isSelected, boolean showMargin, int originalCreator, float progress) {
        if (!this.mAnchor.isConnected()) {
            return;
        }
        if (this.mAnchor != null && this.mAnchor.getConnectionCreator() == 2) {
            this.startLock();
        }
        ConnectionDrawing drawing = new ConnectionDrawing();
        ConstraintWidget targetWidget = this.mAnchor.getTarget().getOwner();
        WidgetCompanion targetCompanion = (WidgetCompanion)targetWidget.getCompanionWidget();
        if (targetCompanion == null) {
            return;
        }
        WidgetInteractionTargets interactionTargets = targetCompanion.getWidgetInteractionTargets();
        ConstraintHandle targetHandle = interactionTargets.getConstraintHandle(this.mAnchor.getTarget());
        if (targetHandle == null) {
            return;
        }
        g.setStroke(sSimpleStroke);
        int sx = transform.getSwingFX(this.mX);
        int sy = transform.getSwingFY(this.mY);
        int tx = transform.getSwingFX(targetHandle.getDrawX());
        int ty = transform.getSwingFY(targetHandle.getDrawY());
        if (targetHandle.getOwner().isRootContainer()) {
            if (this.mAnchor.isVerticalAnchor()) {
                tx = sx;
            } else {
                ty = sy;
            }
        }
        int minimum = (int)(1.5 * (double)ConnectionDraw.CONNECTION_ANCHOR_SIZE);
        if (Math.abs(sx - tx) < minimum && Math.abs(sy - ty) < minimum) {
            switch (this.mAnchor.getType()) {
                case LEFT: {
                    ConstraintHandle.drawShadowedArrow(g, colorSet, ConnectionDraw.getLeftArrow(), sx, sy);
                    break;
                }
                case TOP: {
                    ConstraintHandle.drawShadowedArrow(g, colorSet, ConnectionDraw.getTopArrow(), sx, sy);
                    break;
                }
                case RIGHT: {
                    ConstraintHandle.drawShadowedArrow(g, colorSet, ConnectionDraw.getRightArrow(), sx, sy);
                    break;
                }
                case BOTTOM: {
                    ConstraintHandle.drawShadowedArrow(g, colorSet, ConnectionDraw.getBottomArrow(), sx, sy);
                }
            }
            return;
        }
        if (this.mAnchor.getOpposite() != null && this.mAnchor.getOpposite().isConnected()) {
            if (this.mAnchor.getOpposite().getTarget() == this.mAnchor.getTarget()) {
                this.addPathCenteredConnectionOnSameAnchor(transform, g, isSelected, drawing, targetHandle, targetWidget);
            } else if (this.mAnchor.getOpposite().getTarget().getOwner() == this.mAnchor.getTarget().getOwner() && targetWidget != this.getOwner().getParent()) {
                if (this.mAnchor.getConnectionCreator() == 2) {
                    g.setStroke(colorSet.getSoftConstraintStroke());
                }
                this.addPathCenteredConnectionOnSameWidget(transform, g, isSelected, drawing, colorSet, targetHandle, targetWidget);
            } else {
                if (this.mAnchor.getConnectionCreator() == 2) {
                    g.setStroke(colorSet.getSoftConstraintStroke());
                }
                this.addPathCenteredConnection(transform, g, isSelected, drawing, colorSet, targetHandle, targetWidget);
            }
        } else {
            this.addPathConnection(transform, g, isSelected, showMargin, drawing, colorSet, targetHandle.getDrawX(), targetHandle.getDrawY(), this.mAnchor.isConnected(), targetHandle.getAnchor().isConnected());
        }
        if (progress <= 1.0f && (double)progress >= 0.1) {
            int distance = ConstraintHandle.lengthOfPath(drawing.mPath);
            int dashFull = (int)((float)distance * progress);
            int dashEmpty = (int)((float)distance * (1.0f - progress));
            if (dashFull > 0 || dashEmpty > 0) {
                BasicStroke progressStroke;
                Stroke s = g.getStroke();
                if (originalCreator == 2 || originalCreator == 1) {
                    if (originalCreator != 1) {
                        g.setColor(colorSet.getSoftConstraintColor());
                        g.setStroke(colorSet.getSoftConstraintStroke());
                        drawing.draw(g);
                    }
                    progressStroke = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{dashFull, dashEmpty}, 0.0f);
                    g.setStroke(progressStroke);
                    if (progress != 1.0f) {
                        drawing.mDrawArrow = false;
                    }
                    if (originalCreator != 1) {
                        g.setColor(colorSet.getSelectedConstraints());
                    }
                    drawing.draw(g);
                } else {
                    g.setColor(colorSet.getSoftConstraintColor());
                    g.setStroke(colorSet.getSoftConstraintStroke());
                    drawing.draw(g);
                    progressStroke = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{dashEmpty, dashFull}, 0.0f);
                    g.setColor(colorSet.getSelectedConstraints());
                    g.setStroke(progressStroke);
                    if (progress == 1.0f) {
                        drawing.mDrawArrow = false;
                    }
                    drawing.draw(g);
                }
                int distanceCircle = 62;
                Color prev = g.getColor();
                int solidCircle = (int)((float)distanceCircle * progress);
                int emptyCircle = (int)((float)distanceCircle * (1.0f - progress));
                BasicStroke circleProgressStrokeOuter = new BasicStroke(4.0f, 0, 2, 0.0f, new float[]{solidCircle, emptyCircle}, 0.0f);
                g.setColor(colorSet.getBackground());
                g.setStroke(circleProgressStrokeOuter);
                int d = 20;
                g.drawRoundRect(sx - 10, sy - 10, d, d, d, d);
                BasicStroke circleProgressStroke = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{solidCircle, emptyCircle}, 0.0f);
                g.setColor(prev);
                g.setStroke(circleProgressStroke);
                g.drawRoundRect(sx - 10, sy - 10, d, d, d, d);
                g.setStroke(s);
            }
        } else {
            ConstraintHandle.paintShadow(g, colorSet, drawing);
            drawing.draw(g);
        }
    }

    public void drawConnection(ViewTransform transform, Graphics2D g, ColorSet colorSet, boolean isSelected, Point target) {
        boolean drawShadow;
        ConnectionDrawing drawing = new ConnectionDrawing();
        this.addPathConnection(transform, g, isSelected, false, drawing, colorSet, (int)target.getX(), (int)target.getY(), false, false);
        boolean bl = drawShadow = isSelected && this.mAnchor.getConnectionCreator() != 2;
        if (drawShadow) {
            Color pre = g.getColor();
            Stroke s = g.getStroke();
            g.setColor(sShadowColor);
            g.setStroke(sShadowStroke);
            drawing.draw(g);
            g.setColor(pre);
            g.setStroke(s);
        }
        drawing.draw(g);
    }

    private void addPathConnection(ViewTransform transform, Graphics2D g, boolean isSelected, boolean showMargin, ConnectionDrawing drawing, ColorSet colorSet, int targetX, int targetY, boolean isConnected, boolean isTargetConnected) {
        boolean beStraight;
        int radius = 4;
        int sradius = transform.getSwingDimension(radius);
        int scurvature = transform.getSwingDimension(2);
        int scurvature2 = transform.getSwingDimension(3);
        int marginLineOffset = transform.getSwingDimension(16);
        boolean isVertical = this.mAnchor.isVerticalAnchor();
        int x0 = transform.getSwingFX(this.mX);
        int y0 = transform.getSwingFY(this.mY);
        int x1 = transform.getSwingFX(targetX);
        int y1 = transform.getSwingFY(targetY);
        drawing.mPath.moveTo(x0, y0);
        int distanceX = Math.abs(targetX - this.mX);
        int distanceY = Math.abs(targetY - this.mY);
        int distance = (int)Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        int maxDistance = Math.min(24 + (int)(0.1f * (float)distance), 64);
        maxDistance = distance > maxDistance ? maxDistance : distance;
        int controlDistance = transform.getSwingDimension(maxDistance);
        if (isTargetConnected) {
            if (isVertical) {
                x1 = x0 < x1 ? x1 - 6 : x1 + 6;
            } else {
                y1 = y0 < y1 ? y1 - 6 : y1 + 6;
            }
        }
        boolean bl = beStraight = this.mAnchor.isConnected() && this.mAnchor.getTarget().getOwner() == this.getOwner().getParent();
        if (beStraight) {
            if (isVertical) {
                x1 = x0;
            } else {
                y1 = y0;
            }
        }
        if (isVertical) {
            boolean isTopConnection;
            boolean isBaseline = this.mAnchor.getType() == ConstraintAnchor.Type.BASELINE;
            boolean bl2 = isTopConnection = this.mAnchor.getType() == ConstraintAnchor.Type.TOP;
            if (isTopConnection |= isBaseline) {
                controlDistance = -controlDistance;
            }
            if (isConnected && this.mAnchor.getTarget() != null && this.mAnchor.getType() == this.mAnchor.getTarget().getType() && !isBaseline && this.mAnchor.getMargin() == 0) {
                int base = y0 - sradius - 5;
                if (!isTopConnection) {
                    base = y0 + sradius + 5;
                }
                if (x0 > x1) {
                    sradius = -sradius;
                }
                ConstraintHandle.addQuarterArc(drawing.mPath, x0, y0, x0 + sradius, base, scurvature, true);
                drawing.mPath.lineTo(x1 - 2 * sradius, base);
                int yt = y1 - 5;
                if (!isTopConnection) {
                    yt = y1 + 5;
                }
                ConstraintHandle.addQuarterArc(drawing.mPath, x1 - 2 * sradius, base, x1, yt, scurvature2, false);
                if (isTopConnection) {
                    drawing.setArrow(ConnectionDraw.getBottomArrow(), x1, y1);
                } else {
                    drawing.setArrow(ConnectionDraw.getTopArrow(), x1, y1);
                }
            } else {
                if (isBaseline) {
                    drawing.mDrawEndCircle = false;
                    int offset1 = (int)((float)transform.getSwingDimension(this.mAnchor.getOwner().getDrawWidth()) * 0.2f);
                    int offset2 = 0;
                    if (this.mAnchor.getTarget() != null) {
                        ConstraintWidget widget = this.mAnchor.getTarget().getOwner();
                        offset2 = (int)((float)transform.getSwingDimension(widget.getDrawWidth()) * 0.2f);
                        int tl = transform.getSwingX(widget.getDrawX());
                        int tr = transform.getSwingX(widget.getDrawRight());
                        int tt = transform.getSwingY(widget.getDrawY());
                        int tb = transform.getSwingDimension(widget.getBaselineDistance());
                        Line2D.Float line = new Line2D.Float(tl, tt + tb, tr, tt + tb);
                        drawing.addShape(line);
                    }
                    if (x0 < x1) {
                        x0 += offset1;
                        x1 -= offset2;
                    } else {
                        x0 -= offset1;
                        x1 += offset2;
                    }
                    drawing.mPath.moveTo(x0, y0);
                }
                int cx1 = x0;
                int cy1 = y0 + controlDistance;
                int cx2 = x1;
                int cy2 = y1 - controlDistance;
                int yt = y1 + 5;
                if (!isTopConnection) {
                    yt = y1 - 5;
                }
                drawing.mPath.curveTo(cx1, cy1, cx2, cy2, x1, yt);
                if (!isTopConnection) {
                    drawing.setArrow(ConnectionDraw.getBottomArrow(), x1, y1);
                } else {
                    drawing.setArrow(ConnectionDraw.getTopArrow(), x1, y1);
                }
            }
            if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0 && showMargin) {
                boolean drawMarginToTheRight;
                Color pre = g.getColor();
                g.setColor(colorSet.getMargins());
                ConstraintAnchor left = this.getOwner().getAnchor(ConstraintAnchor.Type.LEFT);
                ConstraintAnchor right = this.getOwner().getAnchor(ConstraintAnchor.Type.RIGHT);
                boolean centerConnectionAnchor = left != null && right != null && left.isConnected() && left.getTarget() == right.getTarget();
                boolean bl3 = drawMarginToTheRight = x0 > x1;
                if (centerConnectionAnchor) {
                    drawMarginToTheRight = left.getTarget().getType() == ConstraintAnchor.Type.LEFT;
                }
                int marginPosition = drawMarginToTheRight ? x0 + marginLineOffset : x0 - marginLineOffset;
                Stroke pres = g.getStroke();
                g.setStroke(sSimpleStroke);
                ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), marginPosition, y0, y1);
                g.setStroke(ConnectionDraw.sDashedStroke);
                if (x0 > x1) {
                    g.drawLine(marginPosition + marginLineOffset, y1, x1, y1);
                } else {
                    g.drawLine(marginPosition - marginLineOffset, y1, x1, y1);
                }
                g.setColor(pre);
                g.setStroke(pres);
            }
        } else {
            boolean isLeftConnection;
            boolean bl4 = isLeftConnection = this.mAnchor.getType() == ConstraintAnchor.Type.LEFT;
            if (isLeftConnection) {
                controlDistance = -controlDistance;
            }
            if (isConnected && this.mAnchor.getTarget() != null && this.mAnchor.getType() == this.mAnchor.getTarget().getType() & this.mAnchor.getMargin() == 0) {
                int base = x0 - sradius - 5;
                if (!isLeftConnection) {
                    base = x0 + sradius + 5;
                }
                if (y0 > y1) {
                    sradius = -sradius;
                }
                ConstraintHandle.addQuarterArc(drawing.mPath, x0, y0, base, y0 + sradius, scurvature, false);
                drawing.mPath.lineTo(base, y1 - 2 * sradius);
                int xt = x1 - 5;
                if (!isLeftConnection) {
                    xt = x1 + 5;
                }
                ConstraintHandle.addQuarterArc(drawing.mPath, base, y1 - 2 * sradius, xt, y1, scurvature2, true);
                if (isLeftConnection) {
                    drawing.setArrow(ConnectionDraw.getRightArrow(), x1, y1);
                } else {
                    drawing.setArrow(ConnectionDraw.getLeftArrow(), x1, y1);
                }
            } else {
                int cx1 = x0 + controlDistance;
                int cy1 = y0;
                int cx2 = x1 - controlDistance;
                int cy2 = y1;
                int xt = x1 + 5;
                if (!isLeftConnection) {
                    xt = x1 - 5;
                }
                drawing.mPath.curveTo(cx1, cy1, cx2, cy2, xt, y1);
                if (!isLeftConnection) {
                    drawing.setArrow(ConnectionDraw.getRightArrow(), x1, y1);
                } else {
                    drawing.setArrow(ConnectionDraw.getLeftArrow(), x1, y1);
                }
            }
            if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0 && showMargin) {
                boolean drawMarginToTheBottom;
                Color pre = g.getColor();
                g.setColor(colorSet.getMargins());
                ConstraintAnchor top = this.getOwner().getAnchor(ConstraintAnchor.Type.TOP);
                ConstraintAnchor bottom = this.getOwner().getAnchor(ConstraintAnchor.Type.BOTTOM);
                boolean centerConnectionAnchor = top != null && bottom != null && top.isConnected() && top.getTarget() == bottom.getTarget();
                boolean bl5 = drawMarginToTheBottom = y0 > y1;
                if (centerConnectionAnchor) {
                    drawMarginToTheBottom = top.getTarget().getType() == ConstraintAnchor.Type.TOP;
                }
                int marginPosition = drawMarginToTheBottom ? y0 + marginLineOffset : y0 - marginLineOffset;
                Stroke pres = g.getStroke();
                g.setStroke(sSimpleStroke);
                ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), x0, x1, marginPosition);
                g.setStroke(ConnectionDraw.sDashedStroke);
                if (y0 > y1) {
                    g.drawLine(x1, y0 + marginLineOffset, x1, y1);
                } else {
                    g.drawLine(x1, y0 - marginLineOffset, x1, y1);
                }
                g.setColor(pre);
                g.setStroke(pres);
            }
        }
    }

    private void addPathCenteredConnection(ViewTransform transform, Graphics2D g, boolean isSelected, ConnectionDrawing drawing, ColorSet colorSet, ConstraintHandle targetHandle, ConstraintWidget targetWidget) {
        boolean isVertical = this.mAnchor.isVerticalAnchor();
        int x0 = transform.getSwingFX(this.mX);
        int y0 = transform.getSwingFY(this.mY);
        int x1 = transform.getSwingFX(targetHandle.getDrawX());
        int y1 = transform.getSwingFY(targetHandle.getDrawY());
        if (targetHandle.getAnchor().isConnected()) {
            if (isVertical) {
                x1 = x0 < x1 ? x1 - 6 : x1 + 6;
            } else {
                y1 = y0 < y1 ? y1 - 6 : y1 + 6;
            }
        }
        drawing.mPath.moveTo(x0, y0);
        if (isVertical) {
            boolean isTopConnection;
            boolean bl = isTopConnection = targetHandle.getDrawY() < this.getDrawY();
            if (isSelected) {
                int start = y0;
                int end = y1;
                if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0) {
                    end = isTopConnection ? (int)((float)end + transform.getSwingDimensionF(this.mAnchor.getMargin())) : (int)((float)end - transform.getSwingDimensionF(this.mAnchor.getMargin()));
                    Color pre = g.getColor();
                    g.setColor(colorSet.getMargins());
                    Stroke pres = g.getStroke();
                    g.setStroke(sSimpleStroke);
                    ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), x0, end, y1);
                    g.setStroke(pres);
                    g.setColor(pre);
                    Line2D.Float line = new Line2D.Float(x0 - transform.getSwingDimension(4), end, x0 + transform.getSwingDimension(4), end);
                    drawing.addShape(line);
                }
                ConstraintHandle.addVerticalSmallSpring(drawing.mPath, x0, start, end);
                Line2D.Float line = new Line2D.Float(x0 - transform.getSwingDimension(4), y1, x0 + transform.getSwingDimension(4), y1);
                drawing.addShape(line);
            } else {
                drawing.mPath.lineTo(x0, y1);
                if (isTopConnection) {
                    drawing.setArrow(ConnectionDraw.getTopArrow(), x0, y1);
                } else {
                    drawing.setArrow(ConnectionDraw.getBottomArrow(), x0, y1);
                }
            }
            if (targetWidget != this.getOwner().getParent()) {
                Stroke pre = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                g.drawLine(x0, y1, x1, y1);
                g.setStroke(pre);
            }
        } else {
            boolean isLeftConnection;
            boolean bl = isLeftConnection = targetHandle.getDrawX() < this.getDrawX();
            if (isSelected) {
                int start = x0;
                int end = x1;
                if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0) {
                    end = isLeftConnection ? (int)((float)end + transform.getSwingDimensionF(this.mAnchor.getMargin())) : (int)((float)end - transform.getSwingDimensionF(this.mAnchor.getMargin()));
                    Color pre = g.getColor();
                    g.setColor(colorSet.getMargins());
                    Stroke pres = g.getStroke();
                    g.setStroke(sSimpleStroke);
                    ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), end, x1, y0);
                    g.setStroke(pres);
                    g.setColor(pre);
                    g.drawLine(end, y0 - transform.getSwingDimension(4), end, y0 + transform.getSwingDimension(4));
                }
                ConstraintHandle.addHorizontalSmallSpring(drawing.mPath, y0, start, end);
                g.drawLine(x1, y0 - transform.getSwingDimension(4), x1, y0 + transform.getSwingDimension(4));
            } else {
                drawing.mPath.lineTo(x1, y0);
                if (isLeftConnection) {
                    drawing.setArrow(ConnectionDraw.getLeftArrow(), x1, y0);
                } else {
                    drawing.setArrow(ConnectionDraw.getRightArrow(), x1, y0);
                }
            }
            if (targetWidget != this.getOwner().getParent()) {
                Stroke pre = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                g.drawLine(x1, y0, x1, y1);
                g.setStroke(pre);
            }
        }
    }

    private void addPathCenteredConnectionOnSameAnchor(ViewTransform transform, Graphics2D g, boolean isSelected, ConnectionDrawing drawing, ConstraintHandle targetHandle, ConstraintWidget targetWidget) {
        float l = this.getOwner().getDrawX();
        float t = this.getOwner().getDrawY();
        float r = this.getOwner().getDrawRight();
        float b = this.getOwner().getDrawBottom();
        float w = this.getOwner().getDrawWidth();
        float h = this.getOwner().getDrawHeight();
        int radius = 8;
        float connectionX = l + w / 2.0f + (float)radius;
        float connectionY = t + h / 2.0f + (float)radius;
        int connectionRadius = 16;
        int curvature = 2;
        connectionX = Math.max((float)(targetHandle.getDrawX() + 5 + radius), connectionX);
        connectionY = Math.max((float)(targetHandle.getDrawY() + 5 + radius), connectionY);
        boolean rightConnection = true;
        if (targetHandle.getAnchor().getType() == ConstraintAnchor.Type.LEFT) {
            rightConnection = false;
            connectionX = l + w / 2.0f - (float)radius;
            connectionX = Math.min((float)(targetHandle.getDrawX() - 5 - radius), connectionX);
        }
        boolean bottomConnection = true;
        if (targetHandle.getAnchor().getType() == ConstraintAnchor.Type.TOP) {
            bottomConnection = false;
            connectionY = t + h / 2.0f - (float)radius;
            connectionY = Math.min((float)(targetHandle.getDrawY() - 5 - radius), connectionY);
        }
        float xt = targetHandle.getDrawX();
        float yt = targetHandle.getDrawY();
        if (this.mAnchor.getType() == ConstraintAnchor.Type.LEFT || this.mAnchor.getType() == ConstraintAnchor.Type.RIGHT) {
            float x0 = this.mX;
            float y0 = this.mY;
            float x1 = this.mX - radius;
            float y1 = this.mY - radius;
            boolean isRightConnection = this.mAnchor.getType() == ConstraintAnchor.Type.RIGHT;
            boolean isAboveConnection = targetWidget.getDrawY() + targetWidget.getDrawHeight() / 2 < this.getOwner().getDrawY() + this.getOwner().getDrawHeight() / 2;
            drawing.mPath.moveTo(transform.getSwingFX(x0), transform.getSwingFY(y0));
            if (isSelected) {
                Stroke preStroke = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                int centerX = transform.getSwingFX(l + w / 2.0f);
                if (isAboveConnection) {
                    g.drawLine(centerX, transform.getSwingFY(t), centerX, transform.getSwingY(targetWidget.getDrawBottom()));
                } else {
                    g.drawLine(centerX, transform.getSwingFY(b), centerX, transform.getSwingY(targetWidget.getDrawY()));
                }
                g.setStroke(preStroke);
            }
            if (isRightConnection) {
                x1 = this.mX + radius;
            }
            if (!isAboveConnection) {
                y1 = this.mY + radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x0), transform.getSwingFY(y0), transform.getSwingFX(x1), transform.getSwingFY(y1), curvature, false);
            float x2 = x1;
            float y2 = Math.min(t, y1);
            float x3 = this.mX;
            float y3 = Math.min(t - (float)radius, y2 - (float)radius);
            if (!isAboveConnection) {
                y2 = Math.max(b, y1);
                y3 = Math.min(b + (float)radius, y2 + (float)radius);
            }
            drawing.mPath.lineTo(transform.getSwingFX(x2), transform.getSwingFY(y2));
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x2), transform.getSwingFY(y2), transform.getSwingFX(x3), transform.getSwingFY(y3), curvature, true);
            float x4 = Math.max(x3, connectionX - (float)connectionRadius);
            if (isRightConnection) {
                x4 = Math.min(x3, connectionX + (float)connectionRadius);
            }
            float y4 = y3;
            drawing.mPath.lineTo(transform.getSwingFX(x4), transform.getSwingFY(y4));
            float x5 = connectionX;
            float y5 = y4 - (float)radius;
            if (!isAboveConnection) {
                y5 = y4 + (float)radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x4), transform.getSwingFY(y4), transform.getSwingFX(x5), transform.getSwingFY(y5), curvature, false);
            float y6 = yt + (float)radius;
            if (!isAboveConnection) {
                y6 = yt - (float)radius;
            }
            drawing.mPath.lineTo(transform.getSwingFX(connectionX), transform.getSwingFY(y6));
            int sxt = transform.getSwingFX(xt);
            int syt = transform.getSwingFY(yt);
            if (targetHandle.getAnchor().isConnected()) {
                int n = syt = t < yt ? syt - 6 : syt + 6;
            }
            if (rightConnection) {
                ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(connectionX), transform.getSwingFY(y6), sxt + 5, syt, curvature, true);
                drawing.setArrow(ConnectionDraw.getLeftArrow(), sxt, syt);
            } else {
                ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(connectionX), transform.getSwingFY(y6), sxt - 5, syt, curvature, true);
                drawing.setArrow(ConnectionDraw.getRightArrow(), sxt, syt);
            }
        } else if (this.mAnchor.getType() == ConstraintAnchor.Type.TOP || this.mAnchor.getType() == ConstraintAnchor.Type.BOTTOM) {
            float x0 = this.mX;
            float y0 = this.mY;
            float x1 = this.mX - radius;
            float y1 = this.mY - radius;
            boolean isBottomConnection = this.mAnchor.getType() == ConstraintAnchor.Type.BOTTOM;
            boolean isLeftConnection = targetWidget.getDrawX() + targetWidget.getDrawWidth() / 2 < this.getOwner().getDrawX() + this.getOwner().getDrawWidth() / 2;
            drawing.mPath.moveTo(transform.getSwingFX(x0), transform.getSwingFY(y0));
            if (isSelected) {
                Stroke preStroke = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                int centerY = transform.getSwingFY(t + h / 2.0f);
                if (isLeftConnection) {
                    g.drawLine(transform.getSwingFX(targetWidget.getDrawRight()), centerY, transform.getSwingFX(l), centerY);
                } else {
                    g.drawLine(transform.getSwingFX(r), centerY, transform.getSwingFX(targetWidget.getDrawX()), centerY);
                }
                g.setStroke(preStroke);
            }
            if (isBottomConnection) {
                y1 = this.mY + radius;
            }
            if (!isLeftConnection) {
                x1 = this.mX + radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x0), transform.getSwingFY(y0), transform.getSwingFX(x1), transform.getSwingFY(y1), curvature, true);
            float y2 = y1;
            float x2 = Math.min(l, x1);
            float y3 = this.mY;
            float x3 = Math.min(l - (float)radius, x2 - (float)radius);
            if (!isLeftConnection) {
                x2 = Math.max(r, x1);
                x3 = Math.min(r + (float)radius, x2 + (float)radius);
            }
            drawing.mPath.lineTo(transform.getSwingFX(x2), transform.getSwingFY(y2));
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x2), transform.getSwingFY(y2), transform.getSwingFX(x3), transform.getSwingFY(y3), curvature, false);
            float y4 = Math.max(y3, connectionY - (float)connectionRadius);
            if (isBottomConnection) {
                y4 = Math.min(y3, connectionY + (float)connectionRadius);
            }
            float x4 = x3;
            drawing.mPath.lineTo(transform.getSwingFX(x4), transform.getSwingFY(y4));
            float y5 = connectionY;
            float x5 = x4 - (float)radius;
            if (!isLeftConnection) {
                x5 = x4 + (float)radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x4), transform.getSwingFY(y4), transform.getSwingFX(x5), transform.getSwingFY(y5), curvature, true);
            float x6 = xt + (float)radius;
            if (!isLeftConnection) {
                x6 = xt - (float)radius;
            }
            drawing.mPath.lineTo(transform.getSwingFX(x6), transform.getSwingFY(connectionY));
            int sxt = transform.getSwingFX(xt);
            int syt = transform.getSwingFY(yt);
            if (targetHandle.getAnchor().isConnected()) {
                int n = sxt = l < xt ? sxt - 6 : sxt + 6;
            }
            if (bottomConnection) {
                ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x6), transform.getSwingFY(connectionY), sxt, syt + 5, curvature, false);
                drawing.setArrow(ConnectionDraw.getTopArrow(), sxt, syt);
            } else {
                ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x6), transform.getSwingFY(connectionY), sxt, syt - 5, curvature, false);
                drawing.setArrow(ConnectionDraw.getBottomArrow(), sxt, syt);
            }
        }
    }

    private void addPathCenteredConnectionOnSameWidget(ViewTransform transform, Graphics2D g, boolean isSelected, ConnectionDrawing drawing, ColorSet colorSet, ConstraintHandle targetHandle, ConstraintWidget targetWidget) {
        int radius = 4;
        float x0 = this.mX;
        float y0 = this.mY;
        float xt = targetHandle.getDrawX();
        float yt = targetHandle.getDrawY();
        boolean isTopConnection = this.mAnchor.getType() == ConstraintAnchor.Type.TOP;
        boolean isLeftConnection = targetHandle.getDrawX() < this.getDrawX();
        boolean isVerticalConnection = this.mAnchor.isVerticalAnchor();
        int xdelta = 0;
        int ydelta = 0;
        if (targetHandle.getAnchor().isConnected()) {
            if (isVerticalConnection) {
                xdelta = x0 > xt ? -6 : 6;
            } else {
                int n = ydelta = y0 < yt ? -6 : 6;
            }
        }
        if (isVerticalConnection) {
            float base = Math.min(transform.getSwingFY(y0), transform.getSwingFY(yt) - 5);
            if (!isTopConnection) {
                base = Math.max(transform.getSwingFY(y0), transform.getSwingFY(yt) + 5);
            }
            drawing.mPath.moveTo(transform.getSwingFX(x0), transform.getSwingFY(y0));
            if (isSelected && Math.abs((float)transform.getSwingFY(y0) - base) > 0.0f) {
                int start = transform.getSwingFY(y0);
                int end = transform.getSwingFY(yt);
                if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0) {
                    end = isTopConnection ? (int)((float)end + transform.getSwingDimensionF(this.mAnchor.getMargin())) : (int)((float)end - transform.getSwingDimensionF(this.mAnchor.getMargin()));
                    Color pre = g.getColor();
                    g.setColor(colorSet.getMargins());
                    Stroke pres = g.getStroke();
                    g.setStroke(sSimpleStroke);
                    ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), transform.getSwingFX(x0) + 5, end, transform.getSwingFY(yt));
                    g.setStroke(pres);
                    g.setColor(pre);
                    g.drawLine(transform.getSwingFX(x0 - 4.0f), end, transform.getSwingFX(x0 + 4.0f), end);
                }
                ConstraintHandle.addVerticalSmallSpring(drawing.mPath, transform.getSwingFX(x0), start, end);
            }
            drawing.mPath.lineTo(transform.getSwingFX(x0), base);
            float x1 = x0 - (float)radius;
            float sy1 = base - (float)transform.getSwingDimension(radius);
            if (!isTopConnection) {
                sy1 = base + (float)transform.getSwingDimension(radius);
            }
            if (!isLeftConnection) {
                x1 = x0 + (float)radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x0), base, transform.getSwingFX(x1), sy1, 1.0f, true);
            float x2 = xt + (float)(2 * radius);
            if (!isLeftConnection) {
                x2 = xt - (float)(2 * radius);
            }
            drawing.mPath.lineTo(transform.getSwingFX(x2), sy1);
            float syt = transform.getSwingFY(yt) - 5;
            if (!isTopConnection) {
                syt = transform.getSwingFY(yt) + 5;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, transform.getSwingFX(x2), sy1, transform.getSwingFX(xt) + xdelta, syt + (float)ydelta, radius, false);
            if (isSelected) {
                Stroke pre = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                if (isLeftConnection) {
                    g.drawLine(transform.getSwingFX(targetWidget.getDrawRight()), transform.getSwingFY(yt), transform.getSwingFX(x0 - 4.0f), transform.getSwingFY(yt));
                } else {
                    g.drawLine(transform.getSwingFX(targetWidget.getDrawX()), transform.getSwingFY(yt), transform.getSwingFX(x0 - 4.0f), transform.getSwingFY(yt));
                }
                g.setStroke(pre);
                Line2D.Float line = new Line2D.Float(transform.getSwingFX(x0 - 4.0f), transform.getSwingFX(yt), transform.getSwingFX(x0 + 4.0f), transform.getSwingFX(yt));
                drawing.addShape(line);
            }
            if (isTopConnection) {
                drawing.setArrow(ConnectionDraw.getBottomArrow(), transform.getSwingFX(xt) + xdelta, transform.getSwingFY(yt) + ydelta);
            } else {
                drawing.setArrow(ConnectionDraw.getTopArrow(), transform.getSwingFX(xt) + xdelta, transform.getSwingFY(yt) + ydelta);
            }
        } else {
            isTopConnection = targetHandle.getDrawY() < this.getDrawY();
            isLeftConnection = this.mAnchor.getType() == ConstraintAnchor.Type.LEFT;
            float base = Math.min(transform.getSwingFX(x0), transform.getSwingFX(xt) - 5);
            if (!isLeftConnection) {
                base = Math.max(transform.getSwingFX(x0), transform.getSwingFX(xt) + 5);
            }
            drawing.mPath.moveTo(transform.getSwingFX(x0), transform.getSwingFY(y0));
            if (isSelected && Math.abs((float)transform.getSwingFX(x0) - base) > 0.0f) {
                int start = transform.getSwingFX(x0);
                int end = transform.getSwingFX(xt);
                if ((colorSet.alwaysShowMargins() || isSelected) && this.mAnchor.getMargin() > 0) {
                    end = isLeftConnection ? (int)((float)end + transform.getSwingDimensionF(this.mAnchor.getMargin())) : (int)((float)end - transform.getSwingDimensionF(this.mAnchor.getMargin()));
                    Color pre = g.getColor();
                    g.setColor(colorSet.getMargins());
                    Stroke pres = g.getStroke();
                    g.setStroke(sSimpleStroke);
                    ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(this.mAnchor.getMargin()), end, transform.getSwingFX(xt), transform.getSwingFY(y0) + 5);
                    g.setStroke(pres);
                    g.setColor(pre);
                    Line2D.Float line = new Line2D.Float(end, transform.getSwingFX(y0 - 4.0f), end, transform.getSwingFX(y0 + 4.0f));
                    drawing.addShape(line);
                }
                ConstraintHandle.addHorizontalSmallSpring(drawing.mPath, transform.getSwingFY(y0), start, end);
            }
            drawing.mPath.lineTo(base, transform.getSwingFY(y0));
            float y1 = y0 - (float)radius;
            float sx1 = base - (float)transform.getSwingDimension(radius);
            if (!isLeftConnection) {
                sx1 = base + (float)transform.getSwingDimension(radius);
            }
            if (!isTopConnection) {
                y1 = y0 + (float)radius;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, base, transform.getSwingFY(y0), sx1, transform.getSwingFY(y1), 1.0f, false);
            float y2 = yt + (float)(2 * radius);
            if (!isTopConnection) {
                y2 = yt - (float)(2 * radius);
            }
            drawing.mPath.lineTo(sx1, transform.getSwingFY(y2));
            float sxt = transform.getSwingFX(xt) - 5;
            if (!isLeftConnection) {
                sxt = transform.getSwingFX(xt) + 5;
            }
            ConstraintHandle.addQuarterArc(drawing.mPath, sx1, transform.getSwingFY(y2), sxt + (float)xdelta, transform.getSwingFY(yt) + ydelta, radius, true);
            if (isSelected) {
                Stroke pre = g.getStroke();
                g.setStroke(ConnectionDraw.sDashedStroke);
                if (isTopConnection) {
                    g.drawLine(transform.getSwingFX(xt), transform.getSwingFY(targetWidget.getDrawBottom()), transform.getSwingFX(xt), transform.getSwingFY(y0 - 4.0f));
                } else {
                    g.drawLine(transform.getSwingFX(xt), transform.getSwingFY(targetWidget.getDrawY()), transform.getSwingFX(xt), transform.getSwingFY(y0 - 4.0f));
                }
                g.setStroke(pre);
                Line2D.Float line = new Line2D.Float(transform.getSwingFX(xt), transform.getSwingFY(y0 - 4.0f), transform.getSwingFX(xt), transform.getSwingFY(y0 + 4.0f));
                drawing.addShape(line);
            }
            if (isLeftConnection) {
                drawing.setArrow(ConnectionDraw.getRightArrow(), transform.getSwingFX(xt) + xdelta, transform.getSwingFY(yt) + ydelta);
            } else {
                drawing.setArrow(ConnectionDraw.getLeftArrow(), transform.getSwingFX(xt) + xdelta, transform.getSwingFY(yt) + ydelta);
            }
        }
    }

    private static void paintShadow(Graphics2D g, ColorSet colorSet, ConnectionDrawing drawing) {
        Color pre = g.getColor();
        Stroke s = g.getStroke();
        if (colorSet.getStyle() == 0) {
            g.setPaint(colorSet.getBackgroundPaint());
            g.setStroke(sLineShadowStroke);
        } else {
            g.setColor(colorSet.getShadow());
            g.setStroke(colorSet.getShadowStroke());
        }
        drawing.draw(g);
        g.setColor(pre);
        g.setStroke(s);
    }

    private static void drawShadowedArrow(Graphics2D g, ColorSet colorSet, Polygon arrow, int x, int y) {
        Color pre = g.getColor();
        Stroke s = g.getStroke();
        if (colorSet.getStyle() == 0) {
            g.setPaint(colorSet.getBackgroundPaint());
            g.setStroke(sLineShadowStroke);
        } else {
            g.setColor(sShadowColor);
            g.setStroke(sShadowStroke);
        }
        ConnectionDraw.drawArrow(g, arrow, x, y);
        g.setColor(pre);
        g.setStroke(s);
        ConnectionDraw.drawArrow(g, arrow, x, y);
    }

    private static void addVerticalSmallSpring(Path2D.Float path, int x0, int y1, int y2) {
        int springHeight = 2;
        int springWidth = 2;
        int distance = Math.abs(y2 - y1);
        int numSprings = distance / springHeight;
        int leftOver = (distance - numSprings * springHeight) / 2;
        path.lineTo(x0, y1);
        path.lineTo(x0, y1 - leftOver);
        int count = 0;
        if (y1 > y2) {
            for (int y = y1 - leftOver; y > y2 + leftOver; y -= springHeight) {
                int x = count % 2 == 0 ? x0 - springWidth : x0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        } else {
            for (int y = y1 + leftOver; y < y2 - leftOver; y += springHeight) {
                int x = count % 2 == 0 ? x0 - springWidth : x0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        }
        path.lineTo(x0, y2 + leftOver);
        path.lineTo(x0, y2);
    }

    private static void addHorizontalSmallSpring(Path2D.Float path, int y0, int x1, int x2) {
        int springHeight = 2;
        int springWidth = 2;
        int distance = Math.abs(x2 - x1);
        int numSprings = distance / springHeight;
        int leftOver = (distance - numSprings * springHeight) / 2;
        path.lineTo(x1, y0);
        path.lineTo(x1 - leftOver, y0 - leftOver);
        int count = 0;
        if (x1 > x2) {
            for (int x = x1 - leftOver; x > x2 + leftOver; x -= springHeight) {
                int y = count % 2 == 0 ? y0 - springWidth : y0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        } else {
            for (int x = x1 + leftOver; x < x2 - leftOver; x += springHeight) {
                int y = count % 2 == 0 ? y0 - springWidth : y0 + springWidth;
                path.lineTo(x, y);
                ++count;
            }
        }
        path.lineTo(x2 + leftOver, y0);
        path.lineTo(x2, y0);
    }

    private static void addQuarterArc(Path2D.Float path, float x1, float y1, float x2, float y2, float curvature, boolean verticalStart) {
        boolean down = y1 < y2;
        boolean left = x1 > x2;
        float cx1 = 0.0f;
        float cy1 = 0.0f;
        float cx2 = 0.0f;
        float cy2 = 0.0f;
        if (verticalStart) {
            cx1 = x1;
            cy2 = y2;
            cx2 = left ? x1 - curvature : x1 + curvature;
            cy1 = down ? y2 - curvature : y2 + curvature;
        } else {
            cx2 = x2;
            cy1 = y1;
            cx1 = left ? x2 + curvature : x2 - curvature;
            cy2 = down ? y1 + curvature : y1 - curvature;
        }
        path.curveTo(cx1, cy1, cx2, cy2, x2, y2);
    }

    private static int lengthOfPath(Path2D.Float path) {
        FlatteningPathIterator f = new FlatteningPathIterator(path.getPathIterator(null), 1.0);
        double sum = 0.0;
        float[] coords = new float[6];
        f.currentSegment(coords);
        float x1 = coords[0];
        float y1 = coords[1];
        f.next();
        do {
            f.currentSegment(coords);
            f.next();
            float x2 = coords[0];
            float y2 = coords[1];
            sum += Math.hypot(x2 - x1, y2 - y1);
            x1 = x2;
            y1 = y2;
        } while (!f.isDone());
        return (int)sum;
    }

    public void startLock() {
        if (!this.mLocking) {
            this.mLockTimer.start();
            this.mLocking = true;
            this.mLockingStartTime = System.currentTimeMillis();
        }
    }

    public void stopLock() {
        this.mLockTimer.stop();
        this.mLocking = false;
        this.mLockingStartTime = 0L;
    }

    public boolean isLocking() {
        return this.mLocking;
    }

    public float getLockingProgress() {
        if (this.mLockingStartTime == 0L) {
            return 0.0f;
        }
        long delta = System.currentTimeMillis() - this.mLockingStartTime;
        if (delta > 3000L) {
            return 1.0f;
        }
        return (float)delta / 3000.0f;
    }

    public String toString() {
        return this.mAnchor.toString();
    }

    static class ConnectionDrawing {
        ArrayList<Shape> mShapes = new ArrayList();
        Path2D.Float mPath = new Path2D.Float();
        Polygon mArrow;
        boolean mDrawEndCircle = false;
        boolean mDrawArrow = true;
        int mArrowX;
        int mArrowY;

        ConnectionDrawing() {
        }

        public void draw(Graphics2D g) {
            g.draw(this.mPath);
            if (this.mArrow != null && this.mDrawArrow) {
                Stroke pre = g.getStroke();
                g.setStroke(sSimpleStroke);
                if (this.mDrawEndCircle) {
                    int radius = ConnectionDraw.CONNECTION_ANCHOR_SIZE;
                    int diameter = radius * 2;
                    g.drawRoundRect(this.mArrowX - radius, this.mArrowY - radius, diameter, diameter, diameter, diameter);
                }
                ConnectionDraw.drawArrow(g, this.mArrow, this.mArrowX, this.mArrowY);
                g.setStroke(pre);
            }
            for (Shape shape : this.mShapes) {
                g.draw(shape);
            }
        }

        public void setArrow(Polygon shape, int x, int y) {
            this.mArrow = shape;
            this.mArrowX = x;
            this.mArrowY = y;
        }

        public void addShape(Shape shape) {
            this.mShapes.add(shape);
        }
    }
}

