/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.drawing.decorator;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import java.awt.Color;
import java.awt.Graphics2D;

public class SeekBarWidget
extends WidgetDecorator {
    public SeekBarWidget(ConstraintWidget widget) {
        super(widget);
        this.wrapContent();
    }

    public void setTextSize() {
        this.wrapContent();
    }

    @Override
    public void applyDimensionBehaviour() {
        this.wrapContent();
    }

    protected void wrapContent() {
        this.mWidget.setMinWidth(100);
        this.mWidget.setMinHeight(30);
        int tw = this.mWidget.getMinWidth();
        int th = this.mWidget.getMinHeight();
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setWidth(tw);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setHeight(th);
        }
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getWidth() <= this.mWidget.getMinWidth()) {
            this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getHeight() <= this.mWidget.getMinHeight()) {
            this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        this.mWidget.setBaselineDistance(0);
    }

    @Override
    public void onPaintBackground(ViewTransform transform, Graphics2D g) {
        super.onPaintBackground(transform, g);
        if (this.mColorSet.drawBackground()) {
            int x = transform.getSwingX(this.mWidget.getDrawX());
            int y = transform.getSwingY(this.mWidget.getDrawY());
            int h = transform.getSwingDimension(this.mWidget.getDrawHeight());
            int w = transform.getSwingDimension(this.mWidget.getDrawWidth());
            g.setColor(Color.WHITE);
            g.fillRoundRect(x + 2, y + h / 2 - h / 8, w / 2, h / 4, h / 4, h / 4);
            g.drawRoundRect(x + 2, y + h / 2 - h / 8, w - 4, h / 4, h / 4, h / 4);
            g.fillArc(x + w / 2 - h / 3, y + h / 6, 2 * h / 3, 2 * h / 3, 0, 360);
        }
    }
}

