/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class AnimatedBlinkingText
extends Animation {
    private final String mText;
    private static Font sFont = new Font("Helvetica", 0, 12);
    int mTextWidth;
    int mTextHeight;
    Color mTextColor = Color.WHITE;
    int mCanvasWidth;
    int mCanvasHeight;

    public AnimatedBlinkingText(String text) {
        this.mText = text;
        this.setLoop(true);
        this.setDuration(2000);
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        int padding = 8;
        this.mTextWidth = fm.stringWidth(this.mText) + 2 * padding;
        this.mTextHeight = fm.getMaxAscent() + fm.getMaxDescent() + 2 * padding;
    }

    public void setCanvasDimension(int width, int height) {
        this.mCanvasWidth = width;
        this.mCanvasHeight = height;
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        int alpha = this.getPulsatingAlpha(this.getProgress());
        Color color = new Color(this.mTextColor.getRed(), this.mTextColor.getGreen(), this.mTextColor.getBlue(), alpha);
        g.setColor(color);
        g.drawString(this.mText, this.mCanvasWidth - this.mTextWidth, this.mTextHeight);
    }
}

