/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.widgets.ConstraintWidget;

public class Animator {
    private static final boolean DEBUG = false;
    private static final boolean USE_EASE_IN_OUT = true;
    private final ConstraintWidget mWidget;
    private Frame animTarget = new Frame();
    private Frame animStart = new Frame();
    private Frame animCurrent = new Frame();
    private long animStartTime = 0L;
    private long animDuration = 350L;
    private boolean mAnimating = false;
    private static boolean sAllowsAnimation = false;

    public static void setAnimationEnabled(boolean value) {
        sAllowsAnimation = value;
    }

    public static boolean doAnimation() {
        return sAllowsAnimation;
    }

    public static boolean isAnimationEnabled() {
        return sAllowsAnimation;
    }

    public Animator(ConstraintWidget widget) {
        this.mWidget = widget;
    }

    public boolean isAnimating() {
        return this.mAnimating;
    }

    public void start() {
        this.animStartTime = System.currentTimeMillis();
        this.mAnimating = true;
    }

    public static double EaseInOutinterpolator(double progress, double begin, double end) {
        double change = (end - begin) / 2.0;
        if ((progress *= 2.0) < 1.0) {
            return change * progress * progress + begin;
        }
        return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
    }

    private static float linearInterpolator(float progress, float begin, float end) {
        return end * progress + begin * (1.0f - progress);
    }

    private static int interpolator(float progress, float begin, float end) {
        return (int)Animator.EaseInOutinterpolator(progress, begin, end);
    }

    public void step() {
        long currentTime = System.currentTimeMillis();
        if (currentTime <= this.animStartTime + this.animDuration && currentTime >= this.animStartTime) {
            float progress = (float)(currentTime - this.animStartTime) / (float)this.animDuration;
            this.animCurrent.left = Animator.interpolator(progress, this.animStart.left, this.animTarget.left);
            this.animCurrent.right = Animator.interpolator(progress, this.animStart.right, this.animTarget.right);
            this.animCurrent.top = Animator.interpolator(progress, this.animStart.top, this.animTarget.top);
            this.animCurrent.bottom = Animator.interpolator(progress, this.animStart.bottom, this.animTarget.bottom);
        } else {
            this.animCurrent.left = this.animTarget.left;
            this.animCurrent.top = this.animTarget.top;
            this.animCurrent.right = this.animTarget.right;
            this.animCurrent.bottom = this.animTarget.bottom;
            this.mAnimating = false;
        }
    }

    public void animate(int left, int top, int right, int bottom) {
        this.animCurrent.set(left, top, right, bottom);
        if (!(this.isAnimating() || left == this.mWidget.getInternalDrawX() && top == this.mWidget.getInternalDrawY() && right == this.mWidget.getInternalDrawRight() && bottom == this.mWidget.getInternalDrawBottom())) {
            this.animStart.set(this.mWidget.getInternalDrawX(), this.mWidget.getInternalDrawY(), this.mWidget.getInternalDrawRight(), this.mWidget.getInternalDrawBottom());
            this.start();
        }
        if (this.isAnimating()) {
            this.animTarget.set(left, top, right, bottom);
            this.step();
        }
    }

    public int getCurrentLeft() {
        return this.animCurrent.left;
    }

    public int getCurrentTop() {
        return this.animCurrent.top;
    }

    public int getCurrentRight() {
        return this.animCurrent.right;
    }

    public int getCurrentBottom() {
        return this.animCurrent.bottom;
    }

    static class Frame {
        int left;
        int right;
        int top;
        int bottom;

        Frame() {
        }

        void set(int l, int t, int r, int b) {
            this.left = l;
            this.top = t;
            this.right = r;
            this.bottom = b;
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getRight() {
            return this.right;
        }

        public int getBottom() {
            return this.bottom;
        }
    }
}

