/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.ndk.internal.AbstractNativeToolSpecification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import org.gradle.nativeplatform.platform.NativePlatform;

public class GccNativeToolSpecification
extends AbstractNativeToolSpecification {
    private static final ListMultimap<String, String> RELEASE_CFLAGS = ImmutableListMultimap.builder().putAll((Object)"armeabi", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-march=armv5te", (Object)"-mtune=xscale", (Object)"-msoft-float", (Object)"-mthumb", (Object)"-Os", (Object)"-g", (Object)"-DNDEBUG", (Object[])new String[]{"-fomit-frame-pointer", "-fno-strict-aliasing", "-finline-limit=64"})).putAll((Object)"armeabi-v7a", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-march=armv7-a", (Object)"-mfpu=vfpv3-d16", (Object)"-mfloat-abi=softfp", (Object)"-mthumb", (Object)"-Os", (Object)"-g", (Object)"-DNDEBUG", (Object[])new String[]{"-fomit-frame-pointer", "-fno-strict-aliasing", "-finline-limit=64"})).putAll((Object)"arm64-v8a", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing", (Object)"-funswitch-loops", (Object)"-finline-limit=300", (Object[])new String[0])).putAll((Object)"x86", (Iterable)ImmutableList.of((Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-no-canonical-prefixes", (Object)"-fstack-protector", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing", (Object)"-funswitch-loops", (Object)"-finline-limit=300")).putAll((Object)"x86_64", (Iterable)ImmutableList.of((Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-no-canonical-prefixes", (Object)"-fstack-protector", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing", (Object)"-funswitch-loops", (Object)"-finline-limit=300")).putAll((Object)"mips", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-fno-strict-aliasing", (Object)"-finline-functions", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fmessage-length=0", (Object)"-fno-inline-functions-called-once", (Object)"-fgcse-after-reload", (Object)"-frerun-cse-after-loop", (Object)"-frename-registers", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object[])new String[]{"-g", "-DNDEBUG", "-fomit-frame-pointer", "-funswitch-loops", "-finline-limit=300"})).putAll((Object)"mips64", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-fno-strict-aliasing", (Object)"-finline-functions", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fmessage-length=0", (Object)"-fno-inline-functions-called-once", (Object)"-fgcse-after-reload", (Object)"-frerun-cse-after-loop", (Object)"-frename-registers", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object[])new String[]{"-g", "-DNDEBUG", "-fomit-frame-pointer", "-funswitch-loops", "-finline-limit=300"})).build();
    private static final ListMultimap<String, String> DEBUG_CFLAGS = ImmutableListMultimap.builder().putAll((Object)"armeabi", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing")).putAll((Object)"armeabi-v7a", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing")).putAll((Object)"arm64-v8a", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing")).putAll((Object)"x86", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing")).putAll((Object)"x86_64", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing")).putAll((Object)"mips", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-unswitch-loops")).putAll((Object)"mips64", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer")).build();
    private static final Iterable<String> LDFLAGS = ImmutableList.of((Object)"-no-canonical-prefixes");
    private NativePlatform platform;
    private boolean isDebugBuild;

    public GccNativeToolSpecification(NativePlatform platform, boolean isDebugBuild) {
        this.isDebugBuild = isDebugBuild;
        this.platform = platform;
    }

    @Override
    public Iterable<String> getCFlags() {
        return Iterables.concat((Iterable)RELEASE_CFLAGS.get((Object)this.platform.getName()), (Iterable)(this.isDebugBuild ? DEBUG_CFLAGS.get((Object)this.platform.getName()) : ImmutableList.of()));
    }

    @Override
    public Iterable<String> getCppFlags() {
        return this.getCFlags();
    }

    @Override
    public Iterable<String> getLdFlags() {
        return LDFLAGS;
    }
}

