/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.managed.AndroidConfig;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.ProductFlavor;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.AndroidComponentSpec;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.model.internal.AndroidComponentSpecInternal;
import com.android.build.gradle.model.internal.DefaultAndroidBinary;
import com.android.build.gradle.model.internal.DefaultAndroidComponentSpec;
import com.android.builder.core.VariantType;
import com.android.builder.model.DimensionAware;
import com.android.repository.Revision;
import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.tooling.BuildException;

public class AndroidComponentModelPlugin
implements Plugin<Project> {
    public static final String COMPONENT_NAME = "android";
    public static final String GRADLE_ACCEPTABLE_VERSION = "2.14";
    private static final String GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY = "com.android.build.gradle.overrideVersionCheck";

    public void apply(Project project) {
        AndroidComponentModelPlugin.checkGradleVersion(project);
        project.getPlugins().apply(ComponentModelBasePlugin.class);
    }

    private static void checkGradleVersion(Project project) {
        String gradleVersion = project.getGradle().getGradleVersion();
        if (!gradleVersion.startsWith(GRADLE_ACCEPTABLE_VERSION)) {
            boolean allowNonMatching = Boolean.getBoolean(GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
            File file = new File("gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            String errorMessage = String.format("Gradle version %s is required. Current version is %s. If using the gradle wrapper, try editing the distributionUrl in %s to gradle-%s-all.zip", GRADLE_ACCEPTABLE_VERSION, gradleVersion, file.getAbsolutePath(), GRADLE_ACCEPTABLE_VERSION);
            if (allowNonMatching) {
                project.getLogger().warn(errorMessage);
                project.getLogger().warn("As %s is set, continuing anyways.", (Object)GRADLE_VERSION_CHECK_OVERRIDE_PROPERTY);
            } else {
                throw new BuildException(errorMessage, null);
            }
        }
    }

    public static class Rules
    extends RuleSource {
        @Model(value="android")
        public void android(AndroidConfig androidModel) {
        }

        @Finalize
        public static void finalizeAndroidModel(AndroidConfig androidModel) {
            if (androidModel.getBuildToolsRevision() == null && androidModel.getBuildToolsVersion() != null) {
                androidModel.setBuildToolsRevision(Revision.parseRevision((String)androidModel.getBuildToolsVersion(), (Revision.Precision)Revision.Precision.MICRO));
            }
            if (androidModel.getCompileSdkVersion() != null && !androidModel.getCompileSdkVersion().startsWith("android-") && Ints.tryParse((String)androidModel.getCompileSdkVersion()) != null) {
                androidModel.setCompileSdkVersion("android-" + androidModel.getCompileSdkVersion());
            }
        }

        @Defaults
        public static void createDefaultBuildTypes(@Path(value="android.buildTypes") ModelMap<BuildType> buildTypes) {
            buildTypes.create("debug", (Action)new Action<BuildType>(){

                public void execute(BuildType buildType) {
                    buildType.setDebuggable(true);
                    buildType.setEmbedMicroApp(false);
                }
            });
            buildTypes.create("release");
        }

        @Model
        public static List<ProductFlavorCombo<ProductFlavor>> createProductFlavorCombo(@Path(value="android.productFlavors") ModelMap<ProductFlavor> productFlavors) {
            HashSet flavorDimensionList = Sets.newHashSet();
            for (ProductFlavor flavor : productFlavors.values()) {
                if (flavor.getDimension() == null) continue;
                flavorDimensionList.add(flavor.getDimension());
            }
            return ProductFlavorCombo.createCombinations((List)Lists.newArrayList((Iterable)flavorDimensionList), (Iterable)productFlavors.values());
        }

        @ComponentType
        public static void defineComponentType(TypeBuilder<AndroidComponentSpec> builder) {
            builder.defaultImplementation(DefaultAndroidComponentSpec.class);
            builder.internalView(AndroidComponentSpecInternal.class);
        }

        @Mutate
        public static void createAndroidComponents(ModelMap<AndroidComponentSpec> androidComponents) {
            androidComponents.create(AndroidComponentModelPlugin.COMPONENT_NAME);
        }

        @Mutate
        public static void createVariantSourceSet(@Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, @Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, @Path(value="android.productFlavors") ModelMap<ProductFlavor> flavors, List<ProductFlavorCombo<ProductFlavor>> flavorGroups, ProjectSourceSet projectSourceSet) {
            sources.create("main");
            sources.create(VariantType.ANDROID_TEST.getPrefix());
            sources.create(VariantType.UNIT_TEST.getPrefix());
            for (BuildType buildType : buildTypes.values()) {
                sources.create(buildType.getName());
                if (flavors.isEmpty()) continue;
                for (ProductFlavorCombo<ProductFlavor> group : flavorGroups) {
                    if (group.getFlavorList().isEmpty()) continue;
                    sources.create(group.getName() + StringHelper.capitalize((String)buildType.getName()));
                }
            }
            for (ProductFlavorCombo productFlavorCombo : flavorGroups) {
                sources.create(productFlavorCombo.getName());
            }
            if (flavorGroups.size() != flavors.size()) {
                for (ProductFlavor productFlavor : flavors.values()) {
                    sources.create(productFlavor.getName());
                }
            }
            sources.afterEach((Action)new Action<FunctionalSourceSet>(){

                public void execute(FunctionalSourceSet functionalSourceSet) {
                    functionalSourceSet.afterEach((Action)new Action<LanguageSourceSet>(){

                        public void execute(LanguageSourceSet languageSourceSet) {
                            SourceDirectorySet source = languageSourceSet.getSource();
                            if (source.getSrcDirs().isEmpty()) {
                                source.srcDir((Object)("src/" + languageSourceSet.getParentName() + "/" + languageSourceSet.getName()));
                            }
                        }
                    });
                }
            });
        }

        @ComponentType
        public static void defineBinaryType(TypeBuilder<AndroidBinary> builder) {
            builder.defaultImplementation(DefaultAndroidBinary.class);
            builder.internalView(AndroidBinaryInternal.class);
        }

        @ComponentBinaries
        public static void createBinaries(ModelMap<AndroidBinary> binaries, @Path(value="android") AndroidConfig androidConfig, @Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, List<ProductFlavorCombo<ProductFlavor>> flavorCombos, final @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, AndroidComponentSpec spec) {
            if (flavorCombos.isEmpty()) {
                flavorCombos.add((ProductFlavorCombo<ProductFlavor>)new ProductFlavorCombo((DimensionAware[])new ProductFlavor[0]));
            }
            for (final BuildType buildType : buildTypes.values()) {
                for (final ProductFlavorCombo<ProductFlavor> flavorCombo : flavorCombos) {
                    binaries.create(Rules.getBinaryName(buildType, flavorCombo), (Action)new Action<AndroidBinary>(){

                        public void execute(AndroidBinary androidBinary) {
                            AndroidBinaryInternal binary = (AndroidBinaryInternal)androidBinary;
                            binary.setBuildType(buildType);
                            binary.setProductFlavors(flavorCombo.getFlavorList());
                            Rules.sourceBinary(binary, (ModelMap<FunctionalSourceSet>)sources, "main");
                            Rules.sourceBinary(binary, (ModelMap<FunctionalSourceSet>)sources, buildType.getName());
                            for (ProductFlavor flavor : flavorCombo.getFlavorList()) {
                                Rules.sourceBinary(binary, (ModelMap<FunctionalSourceSet>)sources, flavor.getName());
                            }
                            if (flavorCombo.getFlavorList().size() > 1) {
                                Rules.sourceBinary(binary, (ModelMap<FunctionalSourceSet>)sources, flavorCombo.getName());
                            }
                        }
                    });
                }
            }
        }

        private static void sourceBinary(BinarySpec binary, ModelMap<FunctionalSourceSet> projectSourceSet, String sourceSetName) {
            FunctionalSourceSet sourceSet = (FunctionalSourceSet)projectSourceSet.get(sourceSetName);
            if (sourceSet != null) {
                binary.getInputs().addAll(sourceSet.values());
            }
        }

        private static String getBinaryName(BuildType buildType, ProductFlavorCombo flavorCombo) {
            if (flavorCombo.getFlavorList().isEmpty()) {
                return buildType.getName();
            }
            return flavorCombo.getName() + StringHelper.capitalize((String)buildType.getName());
        }
    }
}

